/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.QueueState;

public class QueueMessageEntity {
    public static final String ID = "_id";
    public static final String STATE = "queue_state";
    public static final String PRIORITY = "queue_priority";
    public static final String MESSAGE_TYPE = "queue_message_type";
    public static final String TAG_CREATION_DATE = "queue_creation_date";
    public static final String TAG_LAST_UPDATE = "queue_last-update";
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="queue_state")
    private QueueState state = QueueState.READY;
    @JsonProperty(value="queue_last-update")
    private String lastUpdate = LocalDateUtil.nowFormatted();
    @JsonProperty(value="queue_creation_date")
    private String created = LocalDateUtil.nowFormatted();
    @JsonProperty(value="queue_message_type")
    private QueueMessageType messageType;
    @JsonProperty(value="queue_priority")
    private int priority = 1;

    public QueueMessageEntity(String id, QueueMessageType messageType) {
        this.id = id;
        this.messageType = messageType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public QueueState getState() {
        return this.state;
    }

    public void setState(QueueState state) {
        this.state = state;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public QueueMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(QueueMessageType messageType) {
        this.messageType = messageType;
    }
}

