/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.common.model;

public enum DataCategory {
    UNIT("units", "unit", true, true),
    OBJECT("objects", "object", false, true),
    OBJECTGROUP("objectgroups", "objectGroup", true, true),
    LOGBOOK("logbooks", "logbook", false, false),
    REPORT("reports", "report", false, false),
    PROBATIVE_REPORT("probativereports", "report", false, false),
    MANIFEST("manifests", "manifest", false, false),
    PROFILE("profiles", "profile", false, false),
    STORAGELOG("storagelog", "storagelog", false, false),
    STORAGEACCESSLOG("storageaccesslog", "storageaccesslog", false, false),
    STORAGETRACEABILITY("storagetraceability", "storagetraceability", false, false),
    RULES("rules", "rules", false, false),
    BATCH_REPORT("batch_report", "report", false, false),
    REFERENTIAL_RULES_CSV("referential_rules_csv", "rules", false, false),
    REFERENTIAL_AGENCIES_CSV("referential_agencies_csv", "report", false, false),
    DIP("dip", "dip", false, true),
    AGENCIES("agencies", "agencies", false, false),
    BACKUP("backup", "backup", false, false),
    BACKUP_OPERATION("backupoperations", "backup_operation", true, false),
    UNIT_GRAPH("unitgraph", "unitgraph", false, true),
    OBJECTGROUP_GRAPH("objectgroupgraph", "objectgroupgraph", false, true),
    DISTRIBUTIONREPORTS("distributionreports", "distribution_reports", true, true),
    ACCESSION_REGISTER_DETAIL("accessionregistersdetail", "accessionregisterdetail", true, true),
    ARCHIVAL_TRANSFER_REPLY("archivaltransferreply", "archivaltransferreply", false, false),
    ACCESSION_REGISTER_SYMBOLIC("accessionregisterssymbolic", "accessionregistersymbolic", true, true),
    TMP("tmp", "tmp", true, true);

    private String collectionName;
    private String folder;
    private boolean updatable;
    private boolean deletable;

    private DataCategory(String collectionName, String folder, boolean udpatable, boolean deletable) {
        this.collectionName = collectionName;
        this.folder = folder;
        this.updatable = udpatable;
        this.deletable = deletable;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFolder() {
        return this.folder;
    }

    public boolean canUpdate() {
        return this.updatable;
    }

    public boolean canDelete() {
        return this.deletable;
    }

    public static DataCategory getByFolder(String folder) {
        for (DataCategory v : DataCategory.values()) {
            if (!v.getFolder().equalsIgnoreCase(folder)) continue;
            return v;
        }
        return null;
    }

    public static DataCategory getByCollectionName(String collectionName) {
        for (DataCategory v : DataCategory.values()) {
            if (!v.getCollectionName().equalsIgnoreCase(collectionName)) continue;
            return v;
        }
        throw new IllegalArgumentException(collectionName + " is not a collectionName in DataCategory entry");
    }
}

