/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.batch.report.model.UnitComputedInheritedRulesInvalidationModel;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.database.server.mongodb.SimpleMongoDBAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UnitComputedInheritedRulesInvalidationRepository
extends ReportCommonRepository {
    static final String UNIT_COMPUTED_INHERITED_RULES_INVALIDATION_COLLECTION_NAME = "InvalidUnits";
    private final MongoCollection<Document> collection;

    @VisibleForTesting
    UnitComputedInheritedRulesInvalidationRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.collection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public UnitComputedInheritedRulesInvalidationRepository(SimpleMongoDBAccess mongoDbAccess) {
        this((MongoDbAccess)mongoDbAccess, UNIT_COMPUTED_INHERITED_RULES_INVALIDATION_COLLECTION_NAME);
    }

    public void bulkAppendReport(List<UnitComputedInheritedRulesInvalidationModel> reports) {
        HashSet<UnitComputedInheritedRulesInvalidationModel> reportsWithoutDuplicate = new HashSet<UnitComputedInheritedRulesInvalidationModel>(reports);
        List<Document> entries = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(entries, this.collection);
    }

    public CloseableIterator<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        final MongoCursor cursor = this.collection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("id", (Object)"$_metadata.id")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
        return new CloseableIterator<Document>(){

            public void close() {
                cursor.close();
            }

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public Document next() {
                return (Document)cursor.next();
            }
        };
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.collection);
    }
}

