/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.batch.report.model.TransferReplyUnitModel;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TransferReplyUnitRepository
extends ReportCommonRepository {
    public static final String TRANSFER_REPLY_UNIT = "TransferReplyUnit";
    private final MongoCollection<Document> transferReplyReportCollection;

    @VisibleForTesting
    public TransferReplyUnitRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.transferReplyReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public TransferReplyUnitRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, TRANSFER_REPLY_UNIT);
    }

    public void bulkAppendReport(List<TransferReplyUnitModel> reports) {
        HashSet<TransferReplyUnitModel> reportsWithoutDuplicate = new HashSet<TransferReplyUnitModel>(reports);
        List<Document> transferReplyUnitDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(transferReplyUnitDocument, this.transferReplyReportCollection);
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.transferReplyReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("id", (Object)"$_metadata.id"), new Document("distribGroup", null), new Document("params.id", (Object)"$_metadata.id"), new Document("params.type", (Object)new Document("$literal", (Object)"Unit")), new Document("params.status", (Object)"$_metadata.status")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.transferReplyReportCollection);
    }
}

