/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.batch.report.rest.repository;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.batch.report.model.PurgeUnitModel;
import fr.gouv.vitam.batch.report.rest.repository.ReportCommonRepository;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.model.UnitType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PurgeUnitRepository
extends ReportCommonRepository {
    public static final String PURGE_UNIT = "PurgeUnit";
    public static final String METADATA_OBJECT_GROUP_ID = "_metadata.objectGroupId";
    private final MongoCollection<Document> purgeUnitReportCollection;

    @VisibleForTesting
    public PurgeUnitRepository(MongoDbAccess mongoDbAccess, String collectionName) {
        this.purgeUnitReportCollection = mongoDbAccess.getMongoDatabase().getCollection(collectionName);
    }

    public PurgeUnitRepository(MongoDbAccess mongoDbAccess) {
        this(mongoDbAccess, PURGE_UNIT);
    }

    public void bulkAppendReport(List<PurgeUnitModel> reports) {
        HashSet<PurgeUnitModel> reportsWithoutDuplicate = new HashSet<PurgeUnitModel>(reports);
        List<Document> eliminationUnitDocument = reportsWithoutDuplicate.stream().map(ReportCommonRepository::pojoToDocument).collect(Collectors.toList());
        super.bulkAppendReport(eliminationUnitDocument, this.purgeUnitReportCollection);
    }

    public MongoCursor<Document> findCollectionByProcessIdTenant(String processId, int tenantId) {
        return this.purgeUnitReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId)})), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("id", (Object)"$_metadata.id"), new Document("distribGroup", null), new Document("params.id", (Object)"$_metadata.id"), new Document("params.type", (Object)new Document("$literal", (Object)"Unit")), new Document("params.status", (Object)"$_metadata.status"), new Document("params.opi", (Object)"$_metadata.opi"), new Document("params.originatingAgency", (Object)"$_metadata.originatingAgency"), new Document("params.objectGroupId", (Object)"$_metadata.objectGroupId"), new Document("params.archivalAgencyIdentifier", (Object)"$_metadata.archivalAgencyIdentifier"), new Document("params.persistentIdentifier", (Object)"$_metadata.persistentIdentifier"), new Document("params.extraInfo", (Object)"$_metadata.extraInfo")})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }

    public void deleteReportByIdAndTenant(String processId, int tenantId) {
        super.deleteReportByIdAndTenant(processId, tenantId, this.purgeUnitReportCollection);
    }

    public MongoCursor<String> distinctObjectGroupOfDeletedUnits(String processId, int tenantId) {
        DistinctIterable distinctObjectGroup = this.purgeUnitReportCollection.distinct(METADATA_OBJECT_GROUP_ID, Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_metadata.status", (Object)"DELETED"), Filters.eq((String)"_tenant", (Object)tenantId)}), String.class);
        return distinctObjectGroup.iterator();
    }

    public MongoCursor<Document> computeOwnAccessionRegisterDetails(String processId, int tenantId) {
        return this.purgeUnitReportCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"processId", (Object)processId), Filters.eq((String)"_tenant", (Object)tenantId), Filters.eq((String)"_metadata.status", (Object)"DELETED"), Filters.ne((String)"_metadata.type", (Object)UnitType.HOLDING_UNIT.name())})), Aggregates.group((Object)"$_metadata.opi", (BsonField[])new BsonField[]{Accumulators.first((String)"originatingAgency", (Object)"$_metadata.originatingAgency"), Accumulators.sum((String)"totalUnits", (Object)1)}), Aggregates.project((Bson)Projections.fields((Bson[])new Bson[]{new Document("_id", (Object)0), new Document("opi", (Object)"$_id"), new Document("originatingAgency", (Object)1), new Document("totalUnits", (Object)1)})), Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"opi"})))).allowDiskUse(Boolean.valueOf(true)).iterator();
    }
}

