/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.BatchRulesUpdateInfo;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollLimitExceededException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollThresholdExceededException;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertRequest;
import fr.gouv.vitam.metadata.api.model.ObjectGroupPerOriginatingAgency;
import fr.gouv.vitam.metadata.api.model.PersistentIdentifierReconstructionRequest;
import fr.gouv.vitam.metadata.api.model.ReclassificationChildNodeExportRequest;
import fr.gouv.vitam.metadata.api.model.ReconstructionRequestItem;
import fr.gouv.vitam.metadata.api.model.ReconstructionResponseItem;
import fr.gouv.vitam.metadata.api.model.UnitPerOriginatingAgency;
import fr.gouv.vitam.metadata.client.ErrorMessage;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaDataClientRest
extends DefaultClient
implements MetaDataClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetaDataClientRest.class);
    private static final String COMPUTE_GRAPH_URI = "/computegraph";
    private static final String REINDEX_URI = "/reindex";
    private static final String ALIASES_URI = "/alias";
    private static final String RECONSTRUCTION_URI = "/reconstruction";
    private static final String PERSISTENT_IDENTIFIER_RECONSTRUCTION_URI = "/reconstruction-persistent-identifier";
    private static final String STORE_GRAPH_URI = "/storegraph";
    private static final String COMPUTED_INHERITED_RULES_OBSOLETE_URI = "/units/computedInheritedRules/processObsoletes";
    private static final String PURGE_EXPIRED_DIP_FILES_URI = "/purgeDIP";
    private static final String PURGE_EXPIRED_TRANSFER_SIP_FILES_URI = "/purgeTransfersSIP";
    private static final String AUDIT_DATA_CONSISTENCY_URI = "/auditDataConsistency";
    private static final String PERSISTENT_IDENTIFIER_URI = "/purgedPersistentIdentifier";
    public static final String CLEAR_SCROLL_FILTER_URI = "/scroll";

    public MetaDataClientRest(VitamClientFactoryInterface<MetaDataClient> factory) {
        super(factory);
    }

    @Override
    public JsonNode insertUnitBulk(BulkUnitInsertRequest request) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/units/bulk").withBody((Object)request, ErrorMessage.INSERT_UNITS_QUERY_NULL.getMessage()).withJson());
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectUnits(JsonNode selectQuery) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode jsonNode;
        block11: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/units").withBody((Object)selectQuery, ErrorMessage.SELECT_UNITS_QUERY_NULL.getMessage()).withJson());
            try {
                try {
                    this.check(response);
                }
                catch (InvalidParseOperationException e) {
                    JsonNode resp = (JsonNode)response.readEntity(JsonNode.class);
                    if (resp != null && resp.get("description") != null) {
                        throw new InvalidParseOperationException(resp.get("description").asText(), (Throwable)e);
                    }
                    throw new InvalidParseOperationException(ErrorMessage.INVALID_PARSE_OPERATION.getMessage(), (Throwable)e);
                }
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RequestResponseOK<JsonNode>> selectUnitsBulk(List<JsonNode> selectQueryBulk) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath("/units/bulk").withBody(selectQueryBulk, ErrorMessage.SELECT_UNITS_QUERY_BULK_NULL.getMessage()).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response);
            if (!requestResponse.isOk()) throw new MetaDataExecutionException((VitamError)requestResponse);
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            ArrayList<RequestResponseOK> result = new ArrayList<RequestResponseOK>();
            for (JsonNode jsonNode : requestResponseOK.getResults()) {
                result.add(RequestResponseOK.getFromJsonNode((JsonNode)jsonNode));
            }
            ArrayList<RequestResponseOK> arrayList = result;
            return arrayList;
        }
        catch (VitamClientInternalException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    @Override
    public JsonNode selectObjectGroups(JsonNode selectQuery) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withPath("/objectgroups").withBody((Object)selectQuery, ErrorMessage.SELECT_OBJECT_GROUP_QUERY_NULL.getMessage()).withJson());
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectUnitbyId(JsonNode selectQuery, String unitId) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode jsonNode;
        block9: {
            if (Strings.isNullOrEmpty((String)unitId)) {
                throw new InvalidParseOperationException("unitId MUST NOT be empty.");
            }
            Response response = this.make(VitamRequestBuilder.get().withPath("/units/" + unitId).withBody((Object)selectQuery, "selectQuery MUST NOT be empty.").withJson());
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode selectObjectGrouptbyId(JsonNode selectQuery, String objectGroupId) throws MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode jsonNode;
        block10: {
            if (Strings.isNullOrEmpty((String)objectGroupId)) {
                throw new InvalidParseOperationException("objectGroupId may not be empty");
            }
            Response response = this.make(VitamRequestBuilder.get().withPath("/objectgroups/" + objectGroupId).withBody((Object)selectQuery, ErrorMessage.SELECT_OBJECT_GROUP_QUERY_NULL.getMessage()).withJson());
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode updateUnitById(JsonNode updateQuery, String unitId) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException, MetaDataNotFoundException {
        JsonNode jsonNode;
        block12: {
            if (Strings.isNullOrEmpty((String)unitId)) {
                throw new InvalidParseOperationException("unitId MUST NOT be empty.");
            }
            Response response = this.make(VitamRequestBuilder.put().withJson().withPath("/units/" + unitId).withBody((Object)updateQuery, ErrorMessage.UPDATE_UNITS_QUERY_NULL.getMessage()));
            try {
                try {
                    this.check(response);
                }
                catch (InvalidParseOperationException e) {
                    JsonNode resp = (JsonNode)response.readEntity(JsonNode.class);
                    if (resp != null && resp.get("description") != null) {
                        throw new InvalidParseOperationException(JsonHandler.unprettyPrint((Object)resp.get("description")), (Throwable)e);
                    }
                    throw new InvalidParseOperationException(ErrorMessage.INVALID_PARSE_OPERATION.getMessage(), (Throwable)e);
                }
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode insertObjectGroup(JsonNode insertQuery) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath("/objectgroups").withBody((Object)insertQuery, "Insert Request is a mandatory parameter"));
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode insertObjectGroups(List<JsonNode> insertQueries) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath("/objectgroups/bulk").withBody(insertQueries, "Insert Request is a mandatory parameter"));
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public void updateObjectGroupById(JsonNode queryUpdate, String objectGroupId) throws InvalidParseOperationException, MetaDataClientServerException, MetaDataExecutionException {
        if (Strings.isNullOrEmpty((String)objectGroupId)) {
            throw new InvalidParseOperationException("objectGroupId may not be empty");
        }
        try (Response response = this.make(VitamRequestBuilder.put().withJson().withPath("/objectgroups/" + objectGroupId).withBody((Object)queryUpdate, ErrorMessage.UPDATE_UNITS_QUERY_NULL.getMessage()));){
            this.check(response);
        }
        catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<UnitPerOriginatingAgency> selectAccessionRegisterOnUnitByOperationId(String operationId) throws MetaDataClientServerException {
        try (Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/accession-registers/units/" + operationId));){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response);
            if (requestResponse.isOk()) {
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                ArrayList<UnitPerOriginatingAgency> unitPerOriginatingAgencies = new ArrayList<UnitPerOriginatingAgency>();
                Object arrayList = requestResponseOK.getResults().iterator();
                while (true) {
                    if (!arrayList.hasNext()) {
                        arrayList = unitPerOriginatingAgencies;
                        return arrayList;
                    }
                    JsonNode jsonNode = (JsonNode)arrayList.next();
                    unitPerOriginatingAgencies.add((UnitPerOriginatingAgency)JsonHandler.getFromJsonNode((JsonNode)jsonNode, UnitPerOriginatingAgency.class));
                }
            }
            VitamError vitamError = (VitamError)requestResponse;
            LOGGER.error("find accession register for unit failed, http code is {}, error is {}", (Object)vitamError.getCode(), (Object)vitamError.getErrors());
            throw new MetaDataClientServerException(vitamError.getDescription());
        }
        catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ObjectGroupPerOriginatingAgency> selectAccessionRegisterOnObjectByOperationId(String operationId) throws MetaDataClientServerException {
        try (Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/accession-registers/objects/" + operationId));){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, ObjectGroupPerOriginatingAgency.class);
            if (requestResponse.isOk()) {
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                List list = requestResponseOK.getResults();
                return list;
            }
            VitamError vitamError = (VitamError)requestResponse;
            LOGGER.error("find accession register for object group failed, http code is {}, error is {}", (Object)vitamError.getCode(), (Object)vitamError.getErrors());
            throw new MetaDataClientServerException(vitamError.getDescription());
        }
        catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    @Override
    public boolean refreshUnits() throws MetaDataClientServerException {
        boolean bl;
        block8: {
            Response response = this.make(VitamRequestBuilder.put().withJsonAccept().withPath("/units"));
            try {
                this.check(response);
                boolean bl2 = bl = response.getStatus() == Response.Status.OK.getStatusCode();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    public boolean refreshObjectGroups() throws MetaDataClientServerException {
        boolean bl;
        block8: {
            Response response = this.make(VitamRequestBuilder.put().withJsonAccept().withPath("/objectgroups"));
            try {
                this.check(response);
                boolean bl2 = bl = response.getStatus() == Response.Status.OK.getStatusCode();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    public JsonNode reindex(IndexParameters indexParam) throws InvalidParseOperationException, MetaDataClientServerException, MetaDataNotFoundException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath(REINDEX_URI).withBody((Object)indexParam, "The options are mandatory"));
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public SwitchIndexResult switchIndexes(SwitchIndexParameters switchIndexParam) throws InvalidParseOperationException, MetaDataClientServerException, MetaDataNotFoundException {
        SwitchIndexResult switchIndexResult;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath(ALIASES_URI).withBody((Object)switchIndexParam, "The options are mandatory"));
            try {
                this.check(response);
                switchIndexResult = (SwitchIndexResult)response.readEntity(SwitchIndexResult.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return switchIndexResult;
    }

    @Override
    public RequestResponse<JsonNode> getUnitByIdRaw(String unitId) throws VitamClientException {
        RequestResponse requestResponse;
        block10: {
            Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/raw/units/" + unitId));
            try {
                try {
                    this.check(response);
                }
                catch (MetaDataNotFoundException metaDataNotFoundException) {
                    // empty catch block
                }
                requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | IllegalStateException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> getUnitsByIdsRaw(Collection<String> unitIds) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/raw/units").withBody(unitIds, "The unit ids are mandatory"));
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> getObjectGroupByIdRaw(String objectGroupId) throws VitamClientException {
        RequestResponse requestResponse;
        block10: {
            Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/raw/objectgroups/" + objectGroupId));
            try {
                try {
                    this.check(response);
                }
                catch (MetaDataNotFoundException metaDataNotFoundException) {
                    // empty catch block
                }
                requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | IllegalStateException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> getObjectGroupsByIdsRaw(Collection<String> objectGroupId) throws VitamClientException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/raw/objectgroups").withBody(objectGroupId, "The object group ids are mandatory"));
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public GraphComputeResponse computeGraph(JsonNode queryDsl) throws VitamClientException {
        GraphComputeResponse graphComputeResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath(COMPUTE_GRAPH_URI).withBody((Object)queryDsl, "The queryDsl is mandatory"));
            try {
                this.check(response);
                graphComputeResponse = (GraphComputeResponse)response.readEntity(GraphComputeResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return graphComputeResponse;
    }

    @Override
    public GraphComputeResponse computeGraph(GraphComputeResponse.GraphComputeAction action, Set<String> ids) throws VitamClientException {
        GraphComputeResponse graphComputeResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath("/computegraph/" + action.name()).withBody(ids, "All params are mandatory"));
            try {
                this.check(response);
                graphComputeResponse = (GraphComputeResponse)response.readEntity(GraphComputeResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new VitamClientException(e);
                }
            }
            response.close();
        }
        return graphComputeResponse;
    }

    @Override
    public void exportReclassificationChildNodes(Set<String> ids, String unitsToUpdateJsonLineFileName, String objectGroupsToUpdateJsonLineFileName) throws VitamClientException, MetaDataExecutionException {
        ReclassificationChildNodeExportRequest reclassificationChildNodeExportRequest = new ReclassificationChildNodeExportRequest(ids, unitsToUpdateJsonLineFileName, objectGroupsToUpdateJsonLineFileName);
        try (Response response = this.make(VitamRequestBuilder.post().withJson().withPath("exportReclassificationChildNodes").withBody((Object)reclassificationChildNodeExportRequest, "All params are mandatory"));){
            this.check(response);
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataNotFoundException e) {
            throw new MetaDataExecutionException(e);
        }
    }

    @Override
    public void deleteUnitsBulk(Collection<String> listIds) throws MetaDataExecutionException, MetaDataClientServerException {
        try (Response response = this.make(VitamRequestBuilder.delete().withJson().withPath("/units/bulkDelete").withBody(listIds, ErrorMessage.INSERT_UNITS_QUERY_NULL.getMessage()));){
            this.check(response);
        }
        catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    @Override
    public void deleteObjectGroupBulk(Collection<String> listIds) throws MetaDataExecutionException, MetaDataClientServerException {
        try (Response response = this.make(VitamRequestBuilder.delete().withJson().withPath("/objectGroups/bulkDelete").withBody(listIds, ErrorMessage.INSERT_UNITS_QUERY_NULL.getMessage()));){
            this.check(response);
        }
        catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataNotFoundException e) {
            throw new MetaDataClientServerException(e);
        }
    }

    @Override
    public Response storeGraph() throws MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataExecutionException, InvalidParseOperationException, MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.get().withJsonContentType().withPath(STORE_GRAPH_URI));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response2.close();
        }
        return response;
    }

    @Override
    public List<ReconstructionResponseItem> reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        List list;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath(RECONSTRUCTION_URI).withBody(reconstructionItems));
            try {
                this.check(response);
                list = ((RequestResponseOK)RequestResponse.parseFromResponse((Response)response, ReconstructionResponseItem.class)).getResults();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public RequestResponse<JsonNode> reconstructPersistentIdentifiers(PersistentIdentifierReconstructionRequest requestItem) throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath(PERSISTENT_IDENTIFIER_RECONSTRUCTION_URI).withBody((Object)requestItem));
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public JsonNode getPurgedPersistentIdentifiers(String persistentIdentifier, @Nullable PurgedCollectionType type) throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode jsonNode;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withJson().withPath("/purgedPersistentIdentifier/" + persistentIdentifier);
            if (type != null) {
                request = request.withQueryParam("type", type.getValue());
            }
            Response response = this.make(request);
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public RequestResponse<JsonNode> updateUnitBulk(JsonNode updateQuery) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath("/units/updatebulk").withBody((Object)updateQuery, ErrorMessage.INSERT_UNITS_QUERY_NULL.getMessage()));
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> atomicUpdateBulk(List<JsonNode> updateQueries) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withPath("/units/atomicupdatebulk").withBody(updateQueries, ErrorMessage.UPDATE_UNITS_QUERY_BULK_NULL.getMessage()).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> updateUnitsRulesBulk(List<String> unitsIds, RuleActions actions, Map<String, DurationData> rulesToDurationData) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        RequestResponse requestResponse;
        block8: {
            BatchRulesUpdateInfo requestContext = new BatchRulesUpdateInfo(unitsIds, actions, rulesToDurationData);
            Response response = this.make(VitamRequestBuilder.post().withJson().withPath("/units/updaterulesbulk").withBody((Object)JsonHandler.toJsonNode((Object)requestContext), ErrorMessage.INSERT_UNITS_QUERY_NULL.getMessage()));
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException e) {
                    throw new MetaDataClientServerException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public JsonNode selectUnitsWithInheritedRules(JsonNode selectQuery) throws MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException, MetaDataExecutionException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.get().withJson().withPath("/unitsWithInheritedRules").withBody((Object)selectQuery, ErrorMessage.SELECT_UNITS_QUERY_NULL.getMessage()));
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public JsonNode createAccessionRegisterSymbolic() throws MetaDataClientServerException, MetaDataExecutionException {
        JsonNode jsonNode;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withJsonAccept().withPath("accession-registers/symbolic"));
            try {
                this.check(response);
                jsonNode = (JsonNode)response.readEntity(JsonNode.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException | MetaDataDocumentSizeException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    @Override
    public Response streamUnits(JsonNode selectQuery) throws MetaDataClientServerException, MetadataScrollThresholdExceededException, MetadataScrollLimitExceededException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withJsonContentType().withOctetAccept().withPath("/units/stream").withBody((Object)selectQuery, ErrorMessage.SELECT_UNITS_QUERY_NULL.getMessage()));
            Response.Status status = response.getStatusInfo().toEnum();
            if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
                doNotCloseResponse = true;
                Response response2 = response;
                return response2;
            }
            try {
                switch (status) {
                    case CONFLICT: {
                        throw new MetadataScrollThresholdExceededException(status.toString());
                    }
                    case UNAUTHORIZED: {
                        throw new MetadataScrollLimitExceededException(status.toString());
                    }
                }
                throw new MetaDataClientServerException(status.toString());
            }
            catch (VitamClientInternalException e) {
                throw new MetaDataClientServerException((Throwable)e);
            }
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response streamObjects(JsonNode selectQuery) throws MetaDataClientServerException, MetadataScrollThresholdExceededException, MetadataScrollLimitExceededException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withPath("/objects/stream").withJsonContentType().withOctetAccept().withBody((Object)selectQuery, ErrorMessage.SELECT_OBJECT_GROUP_QUERY_NULL.getMessage()));
            Response.Status status = response.getStatusInfo().toEnum();
            if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
                doNotCloseResponse = true;
                Response response2 = response;
                return response2;
            }
            try {
                switch (status) {
                    case CONFLICT: {
                        throw new MetadataScrollThresholdExceededException(status.toString());
                    }
                    case UNAUTHORIZED: {
                        throw new MetadataScrollLimitExceededException(status.toString());
                    }
                }
                throw new MetaDataClientServerException(status.toString());
            }
            catch (VitamClientInternalException e) {
                throw new MetaDataClientServerException((Throwable)e);
            }
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response processObsoleteComputedInheritedRules() throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.post().withJson().withPath(COMPUTED_INHERITED_RULES_OBSOLETE_URI));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    LOGGER.error(e);
                    throw new MetaDataClientServerException(e);
                }
            }
            response2.close();
        }
        return response;
    }

    @Override
    public Response purgeExpiredDipFiles() throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.delete().withJson().withPath(PURGE_EXPIRED_DIP_FILES_URI));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response2.close();
        }
        return response;
    }

    @Override
    public Response purgeExpiredTransfersSIPFiles() throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.delete().withJson().withPath(PURGE_EXPIRED_TRANSFER_SIP_FILES_URI));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response2.close();
        }
        return response;
    }

    @Override
    public Response runAuditDataConsistencyMongoEs() throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.get().withJson().withPath(AUDIT_DATA_CONSISTENCY_URI));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientInternalException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response2.close();
        }
        return response;
    }

    @Override
    public Response clearESScrollFilter(String scrollId) throws MetaDataClientServerException {
        Response response;
        block8: {
            Response response2 = this.make(VitamRequestBuilder.delete().withJson().withPath(CLEAR_SCROLL_FILTER_URI).withBody((Object)scrollId, "The scroll id is mandatory"));
            try {
                this.check(response2);
                response = response2;
                if (response2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | VitamClientInternalException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new MetaDataClientServerException(e);
                }
            }
            response2.close();
        }
        return response;
    }

    private void check(Response response) throws MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                throw new MetaDataExecutionException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
            }
            case NOT_FOUND: {
                throw new MetaDataNotFoundException(ErrorMessage.NOT_FOUND.getMessage());
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                throw new MetaDataDocumentSizeException(ErrorMessage.SIZE_TOO_LARGE.getMessage());
            }
            case BAD_REQUEST: {
                throw new InvalidParseOperationException(ErrorMessage.INVALID_PARSE_OPERATION.getMessage());
            }
            case PRECONDITION_FAILED: {
                throw new IllegalArgumentException(ErrorMessage.INVALID_METADATA_VALUE.getMessage());
            }
        }
        throw new MetaDataClientServerException(status.toString());
    }
}

