/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.client.ClientMockResultHelper;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parameter.SwitchIndexParameters;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DurationData;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.exception.MetadataInvalidSelectException;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertRequest;
import fr.gouv.vitam.metadata.api.model.ObjectGroupPerOriginatingAgency;
import fr.gouv.vitam.metadata.api.model.PersistentIdentifierReconstructionRequest;
import fr.gouv.vitam.metadata.api.model.ReconstructionRequestItem;
import fr.gouv.vitam.metadata.api.model.ReconstructionResponseItem;
import fr.gouv.vitam.metadata.api.model.UnitPerOriginatingAgency;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaDataClientMock
extends AbstractMockClient
implements MetaDataClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetaDataClientMock.class);
    public static final String STOP_USING_MOCKS_IN_PRODUCTION = "Stop using mocks in production";

    @Override
    public JsonNode insertUnitBulk(BulkUnitInsertRequest request) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        ArrayNode arrayNode = JsonHandler.createArrayNode();
        JsonNode jsonNode = ClientMockResultHelper.getMetaDataResult().toJsonNode();
        arrayNode.add(jsonNode);
        return arrayNode;
    }

    @Override
    public JsonNode selectUnits(JsonNode selectQuery) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode res = null;
        try {
            res = JsonHandler.getFromFile((File)PropertiesUtils.getResourceFile((String)"result.json"));
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
        }
        return res;
    }

    @Override
    public List<RequestResponseOK<JsonNode>> selectUnitsBulk(List<JsonNode> selectQueryBulk) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        List<RequestResponseOK> res = null;
        try {
            RequestResponseOK result = RequestResponseOK.getFromJsonNode((JsonNode)JsonHandler.getFromFile((File)PropertiesUtils.getResourceFile((String)"result.json")));
            res = Collections.singletonList(result);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
        }
        return res;
    }

    @Override
    public JsonNode selectUnitbyId(JsonNode selectQuery, String unitId) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        JsonNode res = null;
        try {
            res = JsonHandler.getFromFile((File)PropertiesUtils.getResourceFile((String)"result.json"));
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
        }
        return res;
    }

    @Override
    public JsonNode selectObjectGrouptbyId(JsonNode selectQuery, String objectGroupId) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetadataInvalidSelectException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult().toJsonNode();
    }

    @Override
    public JsonNode updateUnitById(JsonNode updateQuery, String unitId) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult().toJsonNode();
    }

    @Override
    public JsonNode insertObjectGroup(JsonNode insertQuery) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult().toJsonNode();
    }

    @Override
    public JsonNode insertObjectGroups(List<JsonNode> insertQuery) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult().toJsonNode();
    }

    @Override
    public List<UnitPerOriginatingAgency> selectAccessionRegisterOnUnitByOperationId(String operationId) throws MetaDataClientServerException {
        return new ArrayList<UnitPerOriginatingAgency>();
    }

    @Override
    public List<ObjectGroupPerOriginatingAgency> selectAccessionRegisterOnObjectByOperationId(String operationId) throws MetaDataClientServerException {
        return new ArrayList<ObjectGroupPerOriginatingAgency>();
    }

    @Override
    public JsonNode selectObjectGroups(JsonNode selectQuery) throws MetaDataExecutionException, MetaDataDocumentSizeException, InvalidParseOperationException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult().toJsonNode();
    }

    @Override
    public void updateObjectGroupById(JsonNode objectGroup, String objectGroupId) {
    }

    @Override
    public boolean refreshUnits() {
        return true;
    }

    @Override
    public boolean refreshObjectGroups() {
        return true;
    }

    @Override
    public JsonNode reindex(IndexParameters indexParam) throws InvalidParseOperationException {
        return JsonHandler.toJsonNode((Object)new ReindexationResult().setCollectionName(indexParam.getCollectionName()).addIndexOK(new ReindexationOK("alias", "indexname", indexParam.getTenants(), "")));
    }

    @Override
    public SwitchIndexResult switchIndexes(SwitchIndexParameters switchIndexParam) throws InvalidParseOperationException {
        return new SwitchIndexResult().setAlias(switchIndexParam.getAlias()).setIndexName(switchIndexParam.getIndexName()).setStatusCode(StatusCode.OK);
    }

    @Override
    public RequestResponse<JsonNode> getUnitByIdRaw(String unitId) throws VitamClientException {
        try {
            return ClientMockResultHelper.getArchiveUnitRawResult();
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    @Override
    public RequestResponse<JsonNode> getObjectGroupByIdRaw(String objectGroupId) throws VitamClientException {
        try {
            return ClientMockResultHelper.getObjectGroupRawResult();
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException((Throwable)e);
        }
    }

    @Override
    public RequestResponse<JsonNode> getUnitsByIdsRaw(Collection<String> unitIds) {
        throw new UnsupportedOperationException("No need for mocks");
    }

    @Override
    public RequestResponse<JsonNode> getObjectGroupsByIdsRaw(Collection<String> objectGroupIds) {
        throw new UnsupportedOperationException("No need for mocks");
    }

    @Override
    public GraphComputeResponse computeGraph(JsonNode queryDsl) throws VitamClientException {
        return new GraphComputeResponse(Integer.valueOf(3), Integer.valueOf(3));
    }

    @Override
    public GraphComputeResponse computeGraph(GraphComputeResponse.GraphComputeAction action, Set<String> ids) throws VitamClientException {
        return new GraphComputeResponse(Integer.valueOf(3), Integer.valueOf(3));
    }

    @Override
    public RequestResponse<JsonNode> reconstructPersistentIdentifiers(PersistentIdentifierReconstructionRequest requestItem) {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    public JsonNode getPurgedPersistentIdentifiers(String persistentIdentifier, @Nullable PurgedCollectionType type) throws MetaDataNotFoundException, InvalidParseOperationException, MetaDataClientServerException {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    public RequestResponse<JsonNode> updateUnitBulk(JsonNode updateQuery) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult();
    }

    @Override
    public RequestResponse<JsonNode> atomicUpdateBulk(List<JsonNode> updateQueries) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        RequestResponseOK res = null;
        try {
            JsonNode result = JsonHandler.getFromFile((File)PropertiesUtils.getResourceFile((String)"resultUpdate.json"));
            ArrayList<JsonNode> nodeList = new ArrayList<JsonNode>();
            nodeList.add(result);
            res = new RequestResponseOK().addAllResults(nodeList).setHttpCode(Response.Status.OK.getStatusCode());
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
        }
        return res;
    }

    @Override
    public RequestResponse<JsonNode> updateUnitsRulesBulk(List<String> unitsIds, RuleActions actions, Map<String, DurationData> rulesToDurationData) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataClientServerException {
        return ClientMockResultHelper.getMetaDataResult();
    }

    @Override
    public void exportReclassificationChildNodes(Set<String> ids, String unitsToUpdateJsonLineFileName, String objectGroupsToUpdateJsonLineFileName) {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public JsonNode selectUnitsWithInheritedRules(JsonNode selectQuery) {
        throw new UnsupportedOperationException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public JsonNode createAccessionRegisterSymbolic() {
        throw new RuntimeException("Do not use this");
    }

    @Override
    public void deleteUnitsBulk(Collection<String> listIds) {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public void deleteObjectGroupBulk(Collection<String> listIds) {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response storeGraph() {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public List<ReconstructionResponseItem> reconstructCollection(List<ReconstructionRequestItem> reconstructionItems) {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response processObsoleteComputedInheritedRules() {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response purgeExpiredDipFiles() {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response purgeExpiredTransfersSIPFiles() {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response runAuditDataConsistencyMongoEs() {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response streamUnits(JsonNode selectQuery) throws MetaDataClientServerException {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }

    @Override
    public Response streamObjects(JsonNode selectQuery) {
        return Response.ok((Object)selectQuery).build();
    }

    @Override
    public Response clearESScrollFilter(String scrollId) throws MetaDataClientServerException {
        throw new IllegalStateException(STOP_USING_MOCKS_IN_PRODUCTION);
    }
}

