/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalNotFoundException;
import fr.gouv.vitam.collect.common.exception.CollectRequestResponse;
import fr.gouv.vitam.collect.internal.core.common.Batch;
import fr.gouv.vitam.collect.internal.core.common.BatchStatus;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.repository.TransactionRepository;
import fr.gouv.vitam.collect.internal.core.service.FluxService;
import fr.gouv.vitam.collect.internal.core.service.ProjectService;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.QueryProjection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceCollectClientFactory;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.bson.conversions.Bson;

public class TransactionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransactionService.class);
    private static final String TRANSACTION_NOT_FOUND = "Transaction not found";
    private static final String PROJECT_ID = "ProjectId";
    private static final String STATUS = "Status";
    private static final String AUTOMATIC_INGEST = "AutomaticIngest";
    private static final String PROCESS_SIP_UNITARY = "PROCESS_SIP_UNITARY";
    private static final String FOLDER_SIP = "SIP";
    private static final Map<String, TransactionStatus> OPERATION_STATUS_TO_TRANSACTION_STATUS_MAP = Map.of(StatusCode.OK.name(), TransactionStatus.ACK_OK, StatusCode.KO.name(), TransactionStatus.ACK_KO, StatusCode.WARNING.name(), TransactionStatus.ACK_WARNING);
    private static final int MAX_RETRY = 3;
    private final TransactionRepository transactionRepository;
    private final MetadataRepository metadataRepository;
    private final ProjectService projectService;
    private final FluxService fluxService;
    private final WorkspaceCollectClientFactory workspaceCollectClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final AccessInternalClientFactory accessInternalClientFactory;
    private final IngestInternalClientFactory ingestInternalClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final int maxWaitDelayForTransactionValidationInSeconds;

    public TransactionService(TransactionRepository transactionRepository, ProjectService projectService, MetadataRepository metadataRepository, FluxService fluxService, WorkspaceCollectClientFactory workspaceCollectClientFactory, WorkspaceClientFactory workspaceClientFactory, AccessInternalClientFactory accessInternalClientFactory, IngestInternalClientFactory ingestInternalClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, CollectInternalConfiguration configuration) {
        this.transactionRepository = transactionRepository;
        this.projectService = projectService;
        this.metadataRepository = metadataRepository;
        this.fluxService = fluxService;
        this.workspaceCollectClientFactory = workspaceCollectClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.accessInternalClientFactory = accessInternalClientFactory;
        this.ingestInternalClientFactory = ingestInternalClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.maxWaitDelayForTransactionValidationInSeconds = configuration.getMaxWaitDelayForTransactionValidationInSeconds();
    }

    public void createTransaction(TransactionDto transactionDto, ProjectDto projectDto) throws CollectInternalException {
        String creationDate = LocalDateUtil.nowFormatted();
        TransactionModel transactionModel = new TransactionModel(transactionDto.getId(), transactionDto.getName(), CollectHelper.mapTransactionDtoToManifestContext(transactionDto, projectDto), TransactionStatus.OPEN, projectDto.getId(), creationDate, creationDate, transactionDto.getTenant(), projectDto.getAutomaticIngest());
        this.transactionRepository.createTransaction(transactionModel);
    }

    public void deleteTransaction(String id) throws CollectInternalException {
        this.deleteTransactionContent(id);
        this.transactionRepository.deleteTransaction(id);
    }

    public Optional<TransactionModel> findTransaction(String id) throws CollectInternalException {
        return this.transactionRepository.findTransaction(id);
    }

    @Deprecated
    public Optional<TransactionModel> findLastTransactionByProjectId(String id) throws CollectInternalException {
        LOGGER.debug("Project id to find : {}", (Object)id);
        return this.transactionRepository.findTransactionByQuery(Filters.eq((String)PROJECT_ID, (Object)id));
    }

    public List<TransactionDto> findTransactionsByProjectId(String id) throws CollectInternalException {
        LOGGER.debug("Transaction id to find : {}", (Object)id);
        List<TransactionModel> listTransactions = this.transactionRepository.findTransactionsByQuery(Filters.eq((String)PROJECT_ID, (Object)id));
        return listTransactions.stream().map(CollectHelper::convertTransactionModelToTransactionDto).collect(Collectors.toList());
    }

    public void ensureTransactionIsOpen(TransactionModel transactionModel) throws CollectInternalException {
        if (transactionModel.getStatus() != TransactionStatus.OPEN) {
            throw new CollectInternalInvalidRequestException("Transaction " + transactionModel.getId() + " must be OPEN but was " + String.valueOf(transactionModel.getStatus()));
        }
    }

    public void replaceTransaction(TransactionModel transactionModel) throws CollectInternalException {
        String updateDate = LocalDateUtil.nowFormatted();
        transactionModel.setLastUpdate(updateDate);
        this.transactionRepository.replaceTransaction(transactionModel);
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus, TransactionModel transactionModel) throws CollectInternalException {
        switch (transactionStatus) {
            case OPEN: {
                this.checkTransitionToOpenStatus(transactionModel);
                break;
            }
            case READY: {
                this.checkTransactionToReadyStatus(transactionModel);
                break;
            }
            case VALIDATED: {
                this.checkTransitionToValidatedStatus(transactionModel);
                break;
            }
            case SENDING: {
                this.checkTransitionToSendingStatus(transactionModel);
                break;
            }
            case SENT: {
                this.checkTransitionToSentStatus(transactionModel);
                break;
            }
            case ACK_OK: {
                this.checkTransactionToAckOKStatus(transactionModel);
                break;
            }
            case ACK_WARNING: {
                this.checkTransactionToAckWarningStatus(transactionModel);
                break;
            }
            case ACK_KO: {
                this.checkTransactionToAckKOStatus(transactionModel);
                break;
            }
            case ABORTED: {
                this.checkTransitionToAbortedStatus(transactionModel);
                break;
            }
            case KO: {
                this.checkTransitionToKoStatus(transactionModel);
                break;
            }
            case ACK_WAITING: {
                throw new IllegalStateException("Unused status. Should never occur.");
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(transactionStatus));
            }
        }
        LOGGER.info("Updating transaction status from " + String.valueOf(transactionModel.getStatus()) + " to " + String.valueOf(transactionStatus) + " for transaction " + transactionModel.getId());
        transactionModel.setStatus(transactionStatus);
        transactionModel.setLastUpdate(LocalDateUtil.nowFormatted());
        this.replaceTransaction(transactionModel);
    }

    public void checkTransitionToOpenStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.OPEN, transactionModel, TransactionStatus.READY, TransactionStatus.VALIDATED, TransactionStatus.ACK_KO, TransactionStatus.KO);
    }

    public void checkTransactionToReadyStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.READY, transactionModel, TransactionStatus.OPEN);
    }

    private void checkTransitionToValidatedStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.VALIDATED, transactionModel, TransactionStatus.READY);
    }

    public void checkTransitionToSendingStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.SENDING, transactionModel, TransactionStatus.VALIDATED);
    }

    public void checkTransitionToSentStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.SENT, transactionModel, TransactionStatus.SENDING);
    }

    private void checkTransactionToAckOKStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.ACK_OK, transactionModel, TransactionStatus.SENT);
    }

    private void checkTransactionToAckWarningStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.ACK_WARNING, transactionModel, TransactionStatus.SENT);
    }

    private void checkTransactionToAckKOStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.ACK_KO, transactionModel, TransactionStatus.SENT);
    }

    public void checkTransitionToAbortedStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.ABORTED, transactionModel, TransactionStatus.OPEN, TransactionStatus.READY, TransactionStatus.VALIDATED, TransactionStatus.ACK_KO, TransactionStatus.KO);
    }

    private void checkTransitionToKoStatus(TransactionModel transactionModel) throws CollectInternalException {
        this.checkStatus(TransactionStatus.KO, transactionModel, TransactionStatus.OPEN, TransactionStatus.READY, TransactionStatus.KO);
    }

    public void checkStatus(TransactionStatus targetStatus, TransactionModel transactionModel, TransactionStatus ... acceptableTransactionStatuses) throws CollectInternalException {
        if (Arrays.stream(acceptableTransactionStatuses).noneMatch(tr -> transactionModel.getStatus().equals(tr))) {
            throw new CollectInternalInvalidRequestException("Cannot change transaction state from " + String.valueOf(transactionModel.getStatus()) + " to " + String.valueOf(targetStatus));
        }
    }

    public void attachVitamOperationId(String transactionId, String operationId) throws CollectInternalException {
        Optional<TransactionModel> transactionModelOptional = this.findTransaction(transactionId);
        if (transactionModelOptional.isEmpty()) {
            throw new CollectInternalNotFoundException(TRANSACTION_NOT_FOUND);
        }
        if (transactionModelOptional.get().getStatus() != TransactionStatus.SENDING) {
            throw new CollectInternalInvalidRequestException(TRANSACTION_NOT_FOUND);
        }
        TransactionModel transactionModel = transactionModelOptional.get();
        transactionModel.setVitamOperationId(operationId);
        transactionModel.setLastUpdate(LocalDateUtil.nowFormatted());
        this.replaceTransaction(transactionModel);
    }

    public List<TransactionModel> getListTransactionToDeleteByTenant(Integer tenantId) throws CollectInternalException {
        return this.transactionRepository.getListTransactionToDeleteByTenant(tenantId);
    }

    private List<TransactionModel> prepareTransactionsToUpdate(Map<String, String> statusOperation, List<TransactionModel> transactions) {
        ArrayList<TransactionModel> transactionsToUpdate = new ArrayList<TransactionModel>();
        for (TransactionModel transaction : transactions) {
            String operationStatus = statusOperation.get(transaction.getVitamOperationId());
            if (!OPERATION_STATUS_TO_TRANSACTION_STATUS_MAP.containsKey(operationStatus)) continue;
            transaction.setStatus(OPERATION_STATUS_TO_TRANSACTION_STATUS_MAP.get(statusOperation.get(transaction.getVitamOperationId())));
            transactionsToUpdate.add(transaction);
        }
        return transactionsToUpdate;
    }

    private JsonNode getDslForSelectOperation(List<String> vitamOperationsIds) throws CollectInternalException {
        Select select = new Select();
        try {
            InQuery in = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])vitamOperationsIds.toArray(new String[0]));
            select.setQuery((Query)in);
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Error when generate DSL for get Operations:", (Throwable)e);
            throw new CollectInternalException((Throwable)e);
        }
        return select.getFinalSelect();
    }

    private Map<String, String> getIngestOperationStatusesFromProcessing(List<TransactionModel> transactions) throws CollectInternalException {
        Map<String, String> map;
        block9: {
            Set operationIds = transactions.stream().map(TransactionModel::getVitamOperationId).collect(Collectors.toSet());
            ProcessQuery processQuery = new ProcessQuery();
            processQuery.setListProcessTypes(List.of(LogbookTypeProcess.INGEST.toString()));
            IngestInternalClient client = this.ingestInternalClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.listOperationsDetails(processQuery);
                if (!requestResponse.isOk()) {
                    LOGGER.error("Error from access client: {}", (Object)requestResponse.toString());
                    throw new CollectInternalException("Error from access client: " + String.valueOf(requestResponse));
                }
                RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                map = requestResponseOK.getResults().stream().filter(processDetail -> operationIds.contains(processDetail.getOperationId())).collect(Collectors.toMap(ProcessDetail::getOperationId, ProcessDetail::getStepStatus));
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    throw new CollectInternalException("Error when select operation", (Throwable)e);
                }
            }
            client.close();
        }
        return map;
    }

    private Map<String, String> getIngestOperationStatusesFromLogbook(List<String> transactionIds) throws CollectInternalException {
        HashMap<String, String> hashMap;
        block12: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                HashMap<String, String> results = new HashMap<String, String>();
                for (List batchTransactionIds : Lists.partition(transactionIds, (int)VitamConfiguration.getBatchSize())) {
                    JsonNode select = this.getDslForSelectOperation(batchTransactionIds);
                    RequestResponse requestResponse = client.selectOperation(select, true, true);
                    if (!requestResponse.isOk()) {
                        throw new CollectInternalException("Error from access client: " + String.valueOf(requestResponse));
                    }
                    RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
                    List logbookOperations = JsonHandler.getFromJsonNodeList((List)requestResponseOK.getResults(), (TypeReference)new TypeReference<LogbookOperation>(this){});
                    logbookOperations.forEach(logbookOperation -> results.put(logbookOperation.getId(), this.getOperationStatus((LogbookOperation)logbookOperation)));
                }
                List notFoundTransactionIds = transactionIds.stream().filter(transactionId -> !results.containsKey(transactionId)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(notFoundTransactionIds)) {
                    LOGGER.error("Invalid state. Transactions ids have not been found " + String.valueOf(notFoundTransactionIds));
                    throw new CollectInternalException("Invalid state. At least one transaction have not been found in Vitam");
                }
                hashMap = results;
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error("Error when select operation:", (Throwable)e);
                    throw new CollectInternalException((Throwable)e);
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new CollectInternalException(e);
                }
            }
            client.close();
        }
        return hashMap;
    }

    private String getOperationStatus(LogbookOperation logbookOperation) {
        if (CollectionUtils.isNotEmpty((Collection)logbookOperation.getEvents()) && PROCESS_SIP_UNITARY.equals(((LogbookEventOperation)logbookOperation.getEvents().get(logbookOperation.getEvents().size() - 1)).getEvType())) {
            return ((LogbookEventOperation)logbookOperation.getEvents().get(logbookOperation.getEvents().size() - 1)).getOutcome();
        }
        LOGGER.warn("Cannot retrieve ingest operation status from logbook operations for id " + logbookOperation.getId());
        return StatusCode.UNKNOWN.name();
    }

    public List<TransactionModel> findValidatedAutoIngestTransactions() throws CollectInternalException {
        return this.transactionRepository.findTransactionsByQueryWithoutTenant(Filters.and((Bson[])new Bson[]{Filters.eq((String)STATUS, (Object)TransactionStatus.VALIDATED.name()), Filters.eq((String)AUTOMATIC_INGEST, (Object)true)}));
    }

    public void manageTransactionsStatus() throws CollectInternalException {
        List<TransactionModel> transactions = this.transactionRepository.findTransactionsByQuery(Filters.eq((String)STATUS, (Object)TransactionStatus.SENT.name()));
        if (CollectionUtils.isEmpty(transactions)) {
            return;
        }
        Map<String, String> statusOperationFromProcessing = this.getIngestOperationStatusesFromProcessing(transactions);
        List<String> operationsWithoutStatusFromProcessing = transactions.stream().map(TransactionModel::getVitamOperationId).filter(id -> !statusOperationFromProcessing.containsKey(id)).collect(Collectors.toList());
        Map<String, String> operationStatusesFromLogbook = this.getIngestOperationStatusesFromLogbook(operationsWithoutStatusFromProcessing);
        Map<String, String> operationStatuses = Stream.concat(statusOperationFromProcessing.entrySet().stream(), operationStatusesFromLogbook.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<TransactionModel> transactionsToUpdate = this.prepareTransactionsToUpdate(operationStatuses, transactions);
        if (CollectionUtils.isNotEmpty(transactionsToUpdate)) {
            this.transactionRepository.replaceTransactions(transactionsToUpdate);
        }
    }

    public TransactionModel replaceTransaction(TransactionDto transactionDto) throws CollectInternalException {
        String projectId = transactionDto.getProjectId();
        Optional<ProjectDto> projectOpt = this.projectService.findProject(projectId);
        if (projectOpt.isEmpty()) {
            throw new CollectInternalException("project with id " + projectId + " not found");
        }
        String id = transactionDto.getId();
        TransactionModel transactionModel = this.findTransaction(id).orElseThrow(() -> new CollectInternalNotFoundException("transaction with id " + id + " not found"));
        transactionModel.setName(transactionDto.getName());
        transactionModel.setManifestContext(CollectHelper.mapTransactionDtoToManifestContext(transactionDto, projectOpt.get()));
        transactionModel.setLastUpdate(LocalDateUtil.nowFormatted());
        this.transactionRepository.replaceTransaction(transactionModel);
        return transactionModel;
    }

    public boolean isTransactionContentEmpty(String id) throws CollectInternalException {
        boolean bl;
        block8: {
            WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
            try {
                boolean bl2 = bl = !workspaceClient.isExistingContainer(id);
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new CollectInternalException((Throwable)e);
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    public void deleteTransactionContent(String transactionId) throws CollectInternalException {
        try (WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();){
            if (workspaceClient.isExistingContainer(transactionId)) {
                workspaceClient.deleteContainer(transactionId, true);
            }
        }
        catch (ContentAddressableStorageException e2) {
            throw new CollectInternalException("Error when trying to delete stream from workspace: ", (Throwable)e2);
        }
        try {
            SelectMultiQuery request = new SelectMultiQuery();
            QueryProjection queryProjection = new QueryProjection();
            queryProjection.setFields(Map.of(VitamFieldsHelper.id(), 1, VitamFieldsHelper.object(), 1));
            request.setProjection(JsonHandler.toJsonNode((Object)queryProjection));
            ScrollSpliterator<JsonNode> scrollRequest = this.metadataRepository.selectUnits(request, transactionId);
            UnmodifiableIterator iterator = Iterators.partition((Iterator)new SpliteratorIterator(scrollRequest), (int)VitamConfiguration.getBatchSize());
            while (iterator.hasNext()) {
                List units = (List)iterator.next();
                List<String> idObjectGroups = units.stream().map(e -> e.get(VitamFieldsHelper.object())).filter(Objects::nonNull).map(JsonNode::asText).collect(Collectors.toList());
                this.metadataRepository.deleteObjectGroups(idObjectGroups);
                List<String> idUnits = units.stream().map(e -> e.get(VitamFieldsHelper.id())).map(JsonNode::asText).collect(Collectors.toList());
                this.metadataRepository.deleteUnits(idUnits);
            }
        }
        catch (InvalidParseOperationException e3) {
            throw new CollectInternalException((Throwable)e3);
        }
    }

    private void purgeFailedUploadSilently(TransactionModel transactionModel) {
        Optional<TransactionModel> optionalTransactionModel;
        List batches;
        String batchId = VitamThreadUtils.getVitamSession().getRequestId();
        Batch batch = new Batch();
        batch.setBatchId(batchId);
        batch.setBatchStatus(BatchStatus.KO);
        try {
            batches = Optional.ofNullable(transactionModel.getBatches()).orElse(new ArrayList());
            batches.add(batch);
            optionalTransactionModel = this.traceTransaction(batches, transactionModel);
            if (optionalTransactionModel.isEmpty()) {
                return;
            }
        }
        catch (CollectInternalException e) {
            LOGGER.info("unable to Update Transaction :", (Throwable)e);
            return;
        }
        TransactionModel newTransactionModel = optionalTransactionModel.get();
        try {
            this.purgeByBatchId(batchId, newTransactionModel);
        }
        catch (CollectInternalException e) {
            LOGGER.error("unable to purge uploaded content :", (Throwable)e);
            return;
        }
        try {
            batch.setBatchStatus(BatchStatus.PURGED);
            this.traceTransaction(batches, newTransactionModel);
        }
        catch (CollectInternalException e) {
            LOGGER.info("unable to Update Transaction :", (Throwable)e);
        }
    }

    private Optional<TransactionModel> traceTransaction(List<Batch> batches, TransactionModel transactionModel) throws CollectInternalException {
        String errorMsg = "concurrency problem: The transaction was deleted by someone else";
        transactionModel.setBatches(batches);
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            if (this.tryUpdateTransaction(transactionModel)) {
                return Optional.of(transactionModel);
            }
            LOGGER.info("Failed to update transaction with the provided model. Retrying with findTransaction...");
            Optional<TransactionModel> optionalTransaction = this.transactionRepository.findTransaction(transactionModel.getId());
            if (optionalTransaction.isEmpty()) {
                LOGGER.error(errorMsg);
                return Optional.empty();
            }
            TransactionModel retrievedTransaction = optionalTransaction.get();
            retrievedTransaction.setBatches(transactionModel.getBatches());
            if (!this.tryUpdateTransaction(retrievedTransaction)) continue;
            return Optional.of(retrievedTransaction);
        }
        LOGGER.info(errorMsg);
        return Optional.empty();
    }

    private boolean tryUpdateTransaction(TransactionModel transactionModel) {
        try {
            return this.transactionRepository.findOneAndReplace(transactionModel);
        }
        catch (CollectInternalException e) {
            LOGGER.error("Unable to update transaction: ", (Throwable)e);
            return false;
        }
    }

    public void purgeByBatchId(String batchId, TransactionModel transactionModel) throws CollectInternalException {
        String transactionId = transactionModel.getId();
        this.purgeObjectAndWorkspace(batchId, transactionId);
        this.purgeUnits(batchId, transactionId);
    }

    private void purgeObjectAndWorkspace(String batchId, String transactionId) throws CollectInternalException {
        UnmodifiableIterator selectObjectIterator;
        try {
            Select select = this.buildSelectWithBatchId(batchId);
            SelectMultiQuery selectObjectRequest = new SelectMultiQuery();
            selectObjectRequest.setQuery(select.getQuery());
            ScrollSpliterator<JsonNode> selectObjectScrollRequest = this.metadataRepository.selectObjectGroups(selectObjectRequest, transactionId);
            selectObjectIterator = Iterators.partition((Iterator)new SpliteratorIterator(selectObjectScrollRequest), (int)VitamConfiguration.getBatchSize());
        }
        catch (InvalidCreateOperationException e) {
            throw new CollectInternalException("Invalid operation during object creation : ", (Throwable)e);
        }
        while (selectObjectIterator.hasNext()) {
            List objectsGroup = (List)selectObjectIterator.next();
            this.purgeWorkspace(objectsGroup, transactionId);
            this.deleteGots(objectsGroup);
        }
    }

    private void purgeWorkspace(List<JsonNode> objects, String transactionId) throws CollectInternalException {
        for (JsonNode object : objects) {
            for (JsonNode qualifier : object.get(VitamFieldsHelper.qualifiers())) {
                if (DataObjectVersionType.PHYSICAL_MASTER.getName().equals(qualifier.get("qualifier").textValue())) continue;
                for (JsonNode version : qualifier.get("versions")) {
                    try {
                        WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
                        try {
                            String uri = version.get("Uri").textValue();
                            if (!workspaceClient.isExistingContainer(transactionId) || !workspaceClient.isExistingObject(transactionId, uri)) continue;
                            workspaceClient.deleteObject(transactionId, uri);
                        }
                        finally {
                            if (workspaceClient == null) continue;
                            workspaceClient.close();
                        }
                    }
                    catch (ContentAddressableStorageException e) {
                        throw new CollectInternalException("Error when trying to delete stream from workspace: ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void deleteGots(List<JsonNode> objects) throws CollectInternalException {
        List<String> idObjectGroups = objects.stream().map(object -> object.get(VitamFieldsHelper.id()).textValue()).collect(Collectors.toList());
        this.metadataRepository.deleteObjectGroups(idObjectGroups);
    }

    private void purgeUnits(String batchId, String transactionId) throws CollectInternalException {
        try {
            Select select = this.buildSelectWithBatchId(batchId);
            SelectMultiQuery request = new SelectMultiQuery();
            request.setQuery(select.getQuery());
            request.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            ScrollSpliterator<JsonNode> scrollRequest = this.metadataRepository.selectUnits(request, transactionId);
            UnmodifiableIterator iterator = Iterators.partition((Iterator)new SpliteratorIterator(scrollRequest), (int)VitamConfiguration.getBatchSize());
            while (iterator.hasNext()) {
                List units = (List)iterator.next();
                List<String> idUnits = units.stream().map(e -> e.get(VitamFieldsHelper.id()).asText()).collect(Collectors.toList());
                this.metadataRepository.deleteUnits(idUnits);
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e2) {
            throw new CollectInternalException("Invalid operation during unit creation : ", e2);
        }
    }

    private Select buildSelectWithBatchId(String batchId) throws InvalidCreateOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.batchId(), (String)batchId));
        return select;
    }

    public Response uploadTransactionZip(InputStream inputStreamObject, TransactionModel transactionModel, @Nullable String encoding, @Nullable String attachementId) throws CollectInternalException {
        try {
            this.fluxService.processStream(inputStreamObject, transactionModel.getProjectId(), transactionModel.getId(), encoding, attachementId);
            return Response.ok().build();
        }
        catch (CollectInternalInvalidRequestException e) {
            LOGGER.error("An error occurs when try to upload the ZIP:", (Throwable)e);
            return CollectRequestResponse.toVitamError((Response.Status)Response.Status.BAD_REQUEST, (String)e.getLocalizedMessage());
        }
        catch (CollectInternalException e) {
            this.purgeFailedUploadSilently(transactionModel);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public Response startEliminationActionWorkflow(String transactionId, EliminationRequestBody eliminationRequestBody, Contexts eliminationWorkflowContext) throws CollectInternalException, InternalServerException, BadRequestException, OperationContextException, InvalidParseOperationException, ContentAddressableStorageServerException, LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException, InvalidGuidOperationException, VitamClientException, InvalidCreateOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Response startDeletionWorkflow(String transactionId, DeletionRequestBody deletionRequestBody, Contexts deletionWorkflowContext) throws InvalidGuidOperationException, LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException, ContentAddressableStorageServerException, InvalidParseOperationException, OperationContextException, InternalServerException, BadRequestException, VitamClientException, InvalidCreateOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadSipOnTransaction(String transactionId, String contentType, InputStream uploadedInputStream) throws LogbookClientAlreadyExistsException, VitamClientException, InternalServerException, BadRequestException, InvalidParseOperationException, LogbookClientServerException, ContentAddressableStorageException, LogbookClientBadRequestException, InvalidGuidOperationException, CollectInternalException {
        try {
            ParametersChecker.checkParameter((String)"HTTP Request must contains stream", (Object[])new Object[]{uploadedInputStream});
            this.checkTransactionStatus(transactionId);
            this.pushSipStreamToWorkspaceCollect(transactionId, contentType, uploadedInputStream);
            String string = this.launchCollectSipWorkflow(transactionId);
            return string;
        }
        finally {
            StreamUtils.closeSilently((InputStream)uploadedInputStream);
        }
    }

    private void checkTransactionStatus(String transactionId) throws CollectInternalException {
        ParametersChecker.checkParameter((String)"Missing transactionId", (String[])new String[]{transactionId});
        Optional<TransactionModel> transactionModelOptional = this.findTransaction(transactionId);
        if (transactionModelOptional.isEmpty()) {
            throw new CollectInternalNotFoundException(TRANSACTION_NOT_FOUND);
        }
        this.ensureTransactionIsOpen(transactionModelOptional.get());
    }

    /*
     * Exception decompiling
     */
    private String launchCollectSipWorkflow(String transactionId) throws InvalidGuidOperationException, LogbookClientAlreadyExistsException, LogbookClientBadRequestException, LogbookClientServerException, ContentAddressableStorageServerException, InternalServerException, BadRequestException, VitamClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSipStreamToWorkspaceCollect(String containerName, String contentType, InputStream uploadedInputStream) throws ContentAddressableStorageException {
        LOGGER.debug("Try to push stream to workspace...");
        try (WorkspaceClient workspaceCollectClient = this.workspaceCollectClientFactory.getClient();){
            if (workspaceCollectClient.isExistingContainer(containerName)) {
                throw new ContentAddressableStorageException(containerName + " container already exist");
            }
            MediaType mediaType = CommonMediaType.valueOf((String)contentType);
            String archiveMimeType = CommonMediaType.mimeTypeOf((MediaType)mediaType);
            workspaceCollectClient.createContainer(containerName);
            workspaceCollectClient.uncompressObject(containerName, FOLDER_SIP, archiveMimeType, uploadedInputStream);
            String manifestPath = "SIP/manifest.xml";
            Response manifestResponse = workspaceCollectClient.getObject(containerName, manifestPath);
            InputStream manifestInputStream = (InputStream)manifestResponse.getEntity();
            try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                workspaceClient.createContainer(containerName);
                workspaceClient.putObject(containerName, "SIP/manifest.xml", manifestInputStream);
            }
            finally {
                StreamUtils.closeSilently((InputStream)manifestInputStream);
            }
        }
        finally {
            StreamUtils.closeSilently((InputStream)uploadedInputStream);
        }
        LOGGER.debug("Push stream to workspace collect finished");
    }

    public void abortTransaction(String transactionId) throws CollectInternalException {
        LOGGER.info("Aborting transaction " + transactionId);
        Optional<TransactionModel> transactionModelOptional = this.findTransaction(transactionId);
        if (transactionModelOptional.isEmpty()) {
            throw new CollectInternalNotFoundException(TRANSACTION_NOT_FOUND);
        }
        this.changeTransactionStatus(TransactionStatus.ABORTED, transactionModelOptional.get());
    }

    public void reopenTransaction(String transactionId) throws CollectInternalException {
        LOGGER.info("Reopening transaction " + transactionId);
        Optional<TransactionModel> transactionModelOptional = this.findTransaction(transactionId);
        if (transactionModelOptional.isEmpty()) {
            throw new CollectInternalNotFoundException(TRANSACTION_NOT_FOUND);
        }
        this.changeTransactionStatus(TransactionStatus.OPEN, transactionModelOptional.get());
    }

    public void checkSipDownloadable(TransactionModel transaction) throws CollectInternalInvalidRequestException {
        switch (transaction.getStatus()) {
            case VALIDATED: 
            case SENDING: 
            case SENT: 
            case ACK_KO: {
                break;
            }
            case READY: {
                throw new CollectInternalInvalidRequestException("Transaction SIP is being generated (" + transaction.getId() + ")");
            }
            case OPEN: 
            case ACK_OK: 
            case ACK_WARNING: 
            case ABORTED: 
            case KO: {
                throw new CollectInternalInvalidRequestException("Cannot download SIP. Invalid transaction status %s (%s)".formatted(transaction.getStatus(), transaction.getId()));
            }
            case ACK_WAITING: {
                throw new IllegalStateException("Unused status. Should never occur.");
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(transaction.getStatus()));
            }
        }
    }

    public void closeTransaction(TransactionModel transaction) throws CollectInternalException {
        this.changeTransactionStatus(TransactionStatus.READY, transaction);
    }

    public void awaitTransactionValidationForIngest(String transactionId) throws CollectInternalException {
        Optional<TransactionModel> initialTransaction = this.findTransaction(transactionId);
        if (initialTransaction.isEmpty()) {
            throw new CollectInternalNotFoundException("No such transaction '" + transactionId + "'");
        }
        boolean noNeedToWait = switch (initialTransaction.get().getStatus()) {
            default -> throw new MatchException(null, null);
            case TransactionStatus.OPEN, TransactionStatus.ABORTED -> throw new CollectInternalInvalidRequestException("Concurrent update for transaction '" + transactionId + "'. Expected " + String.valueOf(TransactionStatus.READY) + "/" + String.valueOf(TransactionStatus.VALIDATED) + ", got " + String.valueOf(initialTransaction.get().getStatus()));
            case TransactionStatus.SENDING, TransactionStatus.SENT, TransactionStatus.ACK_OK, TransactionStatus.ACK_WARNING, TransactionStatus.ACK_KO -> throw new CollectInternalInvalidRequestException("Another process started ingest for transaction '" + transactionId + "'. Expected " + String.valueOf(TransactionStatus.READY) + "/" + String.valueOf(TransactionStatus.VALIDATED) + ", got " + String.valueOf(initialTransaction.get().getStatus()));
            case TransactionStatus.READY -> {
                LOGGER.info("Transaction " + transactionId + " is being processed. Waiting for transaction validation");
                yield false;
            }
            case TransactionStatus.VALIDATED -> {
                LOGGER.info("Transaction " + transactionId + " has been validated. No need for waiting");
                yield true;
            }
            case TransactionStatus.KO -> throw new CollectInternalInvalidRequestException("Cannot ingest transaction " + transactionId + " because it has errors");
            case TransactionStatus.ACK_WAITING -> throw new IllegalStateException("Unused status. Should never occur.");
        };
        if (noNeedToWait) {
            return;
        }
        int sleepDelayInMs = 250;
        int maxSleepDelayInMs = 60000;
        StopWatch stopWatch = StopWatch.createStarted();
        while (true) {
            if (stopWatch.getTime(TimeUnit.SECONDS) > (long)this.maxWaitDelayForTransactionValidationInSeconds) {
                throw new CollectInternalInvalidRequestException("Timeout while waiting for transaction to become " + String.valueOf(TransactionStatus.VALIDATED));
            }
            try {
                Thread.sleep(Duration.ofMillis(sleepDelayInMs));
            }
            catch (InterruptedException e) {
                throw new CollectInternalException("Thread interrupted", (Throwable)e);
            }
            Optional<TransactionModel> currentTransaction = this.findTransaction(transactionId);
            if (currentTransaction.isEmpty()) {
                throw new CollectInternalInvalidRequestException("Concurrent update for transaction '" + transactionId + "'. Transaction deleted meanwhile?");
            }
            boolean doneWaiting = switch (currentTransaction.get().getStatus()) {
                default -> throw new MatchException(null, null);
                case TransactionStatus.OPEN, TransactionStatus.SENDING, TransactionStatus.SENT, TransactionStatus.ACK_OK, TransactionStatus.ACK_WARNING, TransactionStatus.ACK_KO, TransactionStatus.ABORTED -> throw new CollectInternalInvalidRequestException("Concurrent update for transaction '" + transactionId + "'. Expected " + String.valueOf(TransactionStatus.READY) + "/" + String.valueOf(TransactionStatus.VALIDATED) + ", got " + String.valueOf(initialTransaction.get().getStatus()));
                case TransactionStatus.READY -> {
                    LOGGER.info("Transaction " + transactionId + " is being processed. Waiting for transaction validation...");
                    yield false;
                }
                case TransactionStatus.VALIDATED -> {
                    LOGGER.info("Transaction " + transactionId + " has been " + String.valueOf(TransactionStatus.VALIDATED) + ". Done waiting.");
                    yield true;
                }
                case TransactionStatus.KO -> throw new CollectInternalInvalidRequestException("Cannot ingest transaction " + transactionId + " because it has errors");
                case TransactionStatus.ACK_WAITING -> throw new IllegalStateException("Unused status. Should never occur.");
            };
            if (doneWaiting) {
                return;
            }
            sleepDelayInMs = Math.min(sleepDelayInMs * 2, maxSleepDelayInMs);
        }
    }
}

