/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalNotFoundException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.common.BatchStatus;
import fr.gouv.vitam.collect.internal.core.common.TransactionModel;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.helpers.SipHelper;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.service.TransactionService;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.ExportException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.manifest.ManifestBuilder;
import fr.gouv.vitam.common.manifest.naming.CollectFilenameResolver;
import fr.gouv.vitam.common.manifest.naming.FilenameResolver;
import fr.gouv.vitam.common.manifest.naming.FlatFolderResolver;
import fr.gouv.vitam.common.manifest.naming.FolderResolver;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.ExportRequestParameters;
import fr.gouv.vitam.common.model.export.ExportType;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceCollectClientFactory;
import fr.gouv.vitam.workspace.common.CompressInformation;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;

public class SipService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SipService.class);
    private static final String SIP_EXTENSION = ".zip";
    private static final int DEFAULT_MAX_ELEMENT_IN_QUERY = 1000;
    private final int maxElementsInQuery;
    private final WorkspaceCollectClientFactory workspaceCollectClientFactory;
    private final MetadataRepository metadataRepository;
    private final TransactionService transactionService;

    public SipService(WorkspaceCollectClientFactory workspaceCollectClientFactory, MetadataRepository metadataRepository, TransactionService transactionService) {
        this(workspaceCollectClientFactory, metadataRepository, transactionService, 1000);
    }

    @VisibleForTesting
    public SipService(WorkspaceCollectClientFactory workspaceCollectClientFactory, MetadataRepository metadataRepository, TransactionService transactionService, int maxElementsInQuery) {
        this.workspaceCollectClientFactory = workspaceCollectClientFactory;
        this.metadataRepository = metadataRepository;
        this.transactionService = transactionService;
        this.maxElementsInQuery = maxElementsInQuery;
    }

    public void generateSipAsync(TransactionModel transaction) {
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                LOGGER.info("Starting background generation and validation of SIP for transaction " + transaction.getId());
                this.preSipGenerationChecks(transaction);
                this.generateSip(transaction);
                this.transactionService.changeTransactionStatus(TransactionStatus.VALIDATED, transaction);
            }
            catch (Exception exception) {
                LOGGER.error("Cannot generate SIP for transaction " + transaction.getId() + ". Trying to updating status to KO", (Throwable)exception);
                this.tryUpdateTransactionStatusToKO(transaction, exception);
            }
        });
    }

    private void preSipGenerationChecks(TransactionModel transaction) throws CollectInternalException {
        boolean hasBatchKo;
        boolean bl = hasBatchKo = transaction.getBatches() != null && transaction.getBatches().stream().anyMatch(batch -> BatchStatus.KO.equals((Object)batch.getBatchStatus()));
        if (hasBatchKo) {
            throw new CollectInternalInvalidRequestException("Cannot generate the SIP for the transaction " + transaction.getId() + " because it has at least one batch KO.");
        }
        if (this.transactionService.isTransactionContentEmpty(transaction.getId())) {
            throw new CollectInternalInvalidRequestException("Cannot generate the SIP of an empty transaction (" + transaction.getId() + ")");
        }
    }

    private void generateSip(TransactionModel transactionModel) throws CollectInternalException, XMLStreamException, JAXBException, IOException, InvalidCreateOperationException, InvalidParseOperationException, ExportException, ContentAddressableStorageServerException {
        File manifestFile = PropertiesUtils.fileFromTmpFolder((String)(transactionModel.getId() + "-" + VitamThreadUtils.getVitamSession().getRequestId() + "-manifest.xml"));
        try {
            this.generateManifest(transactionModel, manifestFile);
            this.saveManifestInWorkspace(transactionModel, manifestFile);
            this.compressSipInWorkspace(transactionModel);
        }
        finally {
            FileUtils.deleteQuietly((File)manifestFile);
        }
    }

    private void generateManifest(TransactionModel transactionModel, File manifestFile) throws IOException, XMLStreamException, InvalidCreateOperationException, JAXBException, InvalidParseOperationException, CollectInternalException, ExportException {
        try (FileOutputStream outputStream = new FileOutputStream(manifestFile);
             ManifestBuilder manifestBuilder = new ManifestBuilder((OutputStream)outputStream, null);){
            ExportRequestParameters exportRequestParameters = SipHelper.buildExportRequestParameters(transactionModel);
            ExportRequest exportRequest = SipHelper.buildExportRequest(transactionModel, exportRequestParameters);
            manifestBuilder.startDocument(transactionModel.getManifestContext().getMessageIdentifier(), ExportType.ArchiveTransfer, exportRequestParameters);
            ArrayListMultimap multimap = ArrayListMultimap.create();
            HashSet originatingAgencies = new HashSet();
            HashMap ogs = new HashMap();
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(exportRequest.getDslRequest());
            SelectMultiQuery request = parser.getRequest();
            ScrollSpliterator<JsonNode> scrollRequest = this.metadataRepository.selectUnits(request, transactionModel.getId());
            StreamSupport.stream(scrollRequest, false).forEach(arg_0 -> SipService.lambda$generateManifest$2((ListMultimap)multimap, originatingAgencies, ogs, arg_0));
            manifestBuilder.startDataObjectPackage();
            Select select = new Select();
            Iterable partitions = Iterables.partition(ogs.entrySet(), (int)this.maxElementsInQuery);
            HashSet<String> exportedObjectGroupIds = new HashSet<String>();
            for (List partition : partitions) {
                ListMultimap unitsForObjectGroupId = (ListMultimap)partition.stream().collect(ArrayListMultimap::create, (map, entry) -> map.put((Object)((String)entry.getValue()), (Object)((String)entry.getKey())), (list1, list2) -> list1.putAll((Multimap)list2));
                InQuery in = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])((String[])partition.stream().map(Map.Entry::getValue).toArray(String[]::new)));
                select.setQuery((Query)in);
                JsonNode response = this.metadataRepository.selectObjectGroups((JsonNode)select.getFinalSelect(), transactionModel.getId());
                ArrayNode objectGroups = (ArrayNode)response.get("$results");
                for (JsonNode object : objectGroups) {
                    String objectGroupId = object.get(VitamFieldsHelper.id()).textValue();
                    if (exportedObjectGroupIds.contains(objectGroupId)) continue;
                    List linkedUnits = unitsForObjectGroupId.get((Object)objectGroupId);
                    manifestBuilder.writeGOT(object, (String)linkedUnits.getLast(), Stream.empty(), (FolderResolver)FlatFolderResolver.INSTANCE, (FilenameResolver)CollectFilenameResolver.INSTANCE);
                    exportedObjectGroupIds.add(objectGroupId);
                }
            }
            manifestBuilder.startDescriptiveMetadata();
            SelectParserMultiple initialQueryParser = new SelectParserMultiple();
            initialQueryParser.parse(exportRequest.getDslRequest());
            scrollRequest = this.metadataRepository.selectUnits(initialQueryParser.getRequest(), transactionModel.getId());
            StreamSupport.stream(scrollRequest, false).forEach(arg_0 -> SipService.lambda$generateManifest$6(manifestBuilder, (ListMultimap)multimap, ogs, arg_0));
            manifestBuilder.endDescriptiveMetadata();
            String archivalProfile = transactionModel.getManifestContext().getArchivalProfile();
            String submissionAgencyIdentifier = transactionModel.getManifestContext().getSubmissionAgencyIdentifier();
            String legalStatus = transactionModel.getManifestContext().getLegalStatus();
            String acquisitionInformation = transactionModel.getManifestContext().getAcquisitionInformation();
            if (submissionAgencyIdentifier == null) {
                submissionAgencyIdentifier = transactionModel.getManifestContext().getOriginatingAgencyIdentifier();
            }
            manifestBuilder.writeManagementMetadata(acquisitionInformation, legalStatus, transactionModel.getManifestContext().getOriginatingAgencyIdentifier(), submissionAgencyIdentifier, archivalProfile);
            manifestBuilder.endDataObjectPackage();
            manifestBuilder.writeFooter(ExportType.ArchiveTransfer, exportRequest.getExportRequestParameters());
            manifestBuilder.closeManifest();
        }
    }

    private void saveManifestInWorkspace(TransactionModel transactionModel, File manifestFile) throws IOException, ContentAddressableStorageServerException {
        LOGGER.debug("Try to push manifest to workspace...");
        try (WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
             FileInputStream inputStream = new FileInputStream(manifestFile);){
            workspaceClient.putObject(transactionModel.getId(), "manifest.xml", (InputStream)inputStream);
            LOGGER.debug(" -> push manifest to workspace finished");
        }
    }

    private void compressSipInWorkspace(TransactionModel transactionModel) throws CollectInternalException {
        try (WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();){
            CompressInformation compressInformation = new CompressInformation();
            compressInformation.getFiles().add("manifest.xml");
            compressInformation.getFiles().add("Content");
            compressInformation.setOutputFile(transactionModel.getId() + SIP_EXTENSION);
            compressInformation.setOutputContainer(transactionModel.getId());
            workspaceClient.compress(transactionModel.getId(), compressInformation);
        }
        catch (ContentAddressableStorageException e) {
            throw new CollectInternalException((Throwable)e);
        }
    }

    private void tryUpdateTransactionStatusToKO(TransactionModel transactionModel, Exception exception) {
        try {
            this.transactionService.changeTransactionStatus(TransactionStatus.KO, transactionModel);
        }
        catch (Exception e) {
            LOGGER.error("Cannot mark status to KO for transaction " + transactionModel.getId(), (Throwable)exception);
        }
    }

    public InputStream getIngestedFileFromWorkspace(String transactionId) throws CollectInternalException {
        InputStream inputStream;
        block9: {
            LOGGER.debug("Try to get Zip from workspace...");
            WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();
            try {
                Response response = workspaceClient.getObject(transactionId, transactionId + SIP_EXTENSION);
                inputStream = (InputStream)response.readEntity(InputStream.class);
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageNotFoundException e) {
                    throw new CollectInternalNotFoundException("No SIP found for transaction " + transactionId, (Throwable)e);
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new CollectInternalException("An error occurred during access to the SIP of the transaction " + transactionId, (Throwable)e);
                }
            }
            workspaceClient.close();
        }
        return inputStream;
    }

    public void cleanupSip(String transactionId) throws CollectInternalException {
        LOGGER.info("Deleting SIP if transaction " + transactionId + " from workspace...");
        try (WorkspaceClient workspaceClient = this.workspaceCollectClientFactory.getClient();){
            workspaceClient.deleteObject(transactionId, transactionId + SIP_EXTENSION);
        }
        catch (ContentAddressableStorageNotFoundException ignored) {
            LOGGER.info("No SIP to delete for transaction " + transactionId);
        }
        catch (ContentAddressableStorageServerException e) {
            throw new CollectInternalServerSideException("An error occurred during SIP cleanup for transaction " + transactionId, (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$generateManifest$6(ManifestBuilder manifestBuilder, ListMultimap multimap, Map ogs, JsonNode result) {
        try {
            ArchiveUnitModel archiveUnitModel = (ArchiveUnitModel)VitamObjectMapper.getDeserializationObjectMapper().treeToValue((TreeNode)result, ArchiveUnitModel.class);
            manifestBuilder.writeArchiveUnit(archiveUnitModel, multimap, ogs);
        }
        catch (JsonProcessingException | ExportException | JAXBException | DatatypeConfigurationException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private static /* synthetic */ void lambda$generateManifest$2(ListMultimap multimap, Set originatingAgencies, Map ogs, JsonNode item) {
        CollectHelper.createGraph((ListMultimap<String, String>)multimap, originatingAgencies, ogs, item);
    }
}

