/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.enums.TransactionStatus;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.common.ProjectStatus;
import fr.gouv.vitam.collect.internal.core.helpers.CollectHelper;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.transformers.JsltTransformer;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProjectService {
    public static final String ARCHIVING_FIELDS_CREATION_CONSTRAINT = "Fields 'ArchivingSystemId' and 'ArchivingSystemTenant' must be null when 'ConnectedToArchivingSystem' is not true, and must not be null when 'ConnectedToArchivingSystem' is true";
    public static final String ARCHIVING_FIELDS_MODIFICATION_FORBIDDEN = "Fields 'ArchivingSystemId', 'ArchivingSystemTenant' and 'ConnectedToArchivingSystem' must not be changed";
    private final ProjectRepository projectRepository;

    public ProjectService(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public ProjectDto createProject(ProjectDto projectDto) throws CollectInternalException {
        Boolean connectedToArchivingSystem = projectDto.getConnectedToArchivingSystem();
        String archivingSystemId = projectDto.getArchivingSystemId();
        Integer archivingSystemTenant = projectDto.getArchivingSystemTenant();
        if (Boolean.TRUE.equals(connectedToArchivingSystem) ? Objects.isNull(archivingSystemId) || Objects.isNull(archivingSystemTenant) : Objects.nonNull(archivingSystemId) || Objects.nonNull(archivingSystemTenant)) {
            throw new CollectInternalException(ARCHIVING_FIELDS_CREATION_CONSTRAINT);
        }
        String creationDate = LocalDateUtil.nowFormatted();
        JsltTransformer.validate(projectDto.getTransformationRules());
        ProjectModel projectModel = new ProjectModel.Builder().id(GUIDFactory.newGUID().getId()).name(projectDto.getName()).manifestContext(CollectHelper.mapProjectDtoToManifestContext(projectDto)).status(ProjectStatus.OPEN).creationDate(creationDate).lastUpdate(creationDate).unitUp(projectDto.getUnitUp()).unitUps(projectDto.getUnitUps()).tenant(ParameterHelper.getTenantParameter()).automaticIngest(projectDto.getAutomaticIngest()).archivingSystemId(archivingSystemId).archivingSystemTenant(archivingSystemTenant).connectedToArchivingSystem(connectedToArchivingSystem).transformationRules(projectDto.getTransformationRules()).build();
        this.projectRepository.createProject(projectModel);
        return CollectHelper.convertProjectModeltoProjectDto(projectModel);
    }

    public Optional<ProjectDto> findProject(String id) throws CollectInternalException {
        return this.projectRepository.findProjectById(id).map(CollectHelper::convertProjectModeltoProjectDto);
    }

    public ProjectDto updateProject(ProjectDto projectDto, ProjectDto existingProjectDto) throws CollectInternalException {
        if (!(Objects.equals(existingProjectDto.getArchivingSystemId(), projectDto.getArchivingSystemId()) && Objects.equals(existingProjectDto.getArchivingSystemTenant(), projectDto.getArchivingSystemTenant()) && Objects.equals(existingProjectDto.getConnectedToArchivingSystem(), projectDto.getConnectedToArchivingSystem()))) {
            throw new CollectInternalException(ARCHIVING_FIELDS_MODIFICATION_FORBIDDEN);
        }
        projectDto.setStatus(projectDto.getStatus() != null ? projectDto.getStatus() : TransactionStatus.OPEN.name());
        String lastUpdate = LocalDateUtil.nowFormatted();
        JsltTransformer.validate(projectDto.getTransformationRules());
        ProjectModel projectModel = new ProjectModel.Builder().id(projectDto.getId()).name(projectDto.getName()).manifestContext(CollectHelper.mapProjectDtoToManifestContext(projectDto)).status(ProjectStatus.valueOf(projectDto.getStatus())).creationDate(existingProjectDto.getCreationDate()).lastUpdate(lastUpdate).unitUp(projectDto.getUnitUp()).unitUps(projectDto.getUnitUps()).tenant(existingProjectDto.getTenant()).automaticIngest(projectDto.getAutomaticIngest()).archivingSystemId(existingProjectDto.getArchivingSystemId()).archivingSystemTenant(existingProjectDto.getArchivingSystemTenant()).connectedToArchivingSystem(existingProjectDto.getConnectedToArchivingSystem()).transformationRules(projectDto.getTransformationRules()).build();
        this.projectRepository.updateProject(projectModel);
        return CollectHelper.convertProjectModeltoProjectDto(projectModel);
    }

    public List<ProjectDto> searchProject(CriteriaProjectDto criteriaProjectDto) throws CollectInternalException {
        List<ProjectModel> listProjects = this.projectRepository.searchProject(criteriaProjectDto, ParameterHelper.getTenantParameter());
        return listProjects.stream().map(CollectHelper::convertProjectModeltoProjectDto).collect(Collectors.toList());
    }

    public void deleteProjectById(String id) {
        this.projectRepository.deleteProject(id);
    }
}

