/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalInvalidRequestException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.common.CollectJsonMetadataLine;
import fr.gouv.vitam.collect.internal.core.common.ProjectModel;
import fr.gouv.vitam.collect.internal.core.configuration.CollectInternalConfiguration;
import fr.gouv.vitam.collect.internal.core.csv.CsvHelper;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidJsltTransformerException;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectJsltTransformationFailedException;
import fr.gouv.vitam.collect.internal.core.helpers.MetadataHelper;
import fr.gouv.vitam.collect.internal.core.helpers.TempWorkspace;
import fr.gouv.vitam.collect.internal.core.jsonl.JsonlHelper;
import fr.gouv.vitam.collect.internal.core.jsonl.JsonlMetadataFileValidator;
import fr.gouv.vitam.collect.internal.core.repository.MetadataRepository;
import fr.gouv.vitam.collect.internal.core.repository.ProjectRepository;
import fr.gouv.vitam.collect.internal.core.service.CollectService;
import fr.gouv.vitam.collect.internal.core.service.MetadataService;
import fr.gouv.vitam.collect.internal.core.transformers.JsltTransformer;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.mapping.mapper.VitamObjectMapper;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.unit.ArchiveUnitModel;
import fr.gouv.vitam.common.model.unit.LevelType;
import fr.gouv.vitam.common.storage.compress.ArchiveEntryInputStream;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;

public class FluxService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FluxService.class);
    private static final int BULK_SIZE = 1000;
    static final String METADATA_CSV_FILE = "metadata.csv";
    static final String METADATA_JSONL_FILE = "metadata.jsonl";
    public static final TypeReference<CollectJsonMetadataLine> COLLECT_JSON_METADATA_LINE_TYPE_REFERENCE = new TypeReference<CollectJsonMetadataLine>(){};
    public static final TypeReference<JsonLineModel> JSON_LINE_MODEL_TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    private static final String TITLE_FIELD = "Title";
    private static final String DESCRIPTION_LEVEL_FIELD = "DescriptionLevel";
    private final CollectService collectService;
    private final MetadataService metadataService;
    private final ProjectRepository projectRepository;
    private final MetadataRepository metadataRepository;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final CollectInternalConfiguration configuration;

    public FluxService(CollectService collectService, MetadataService metadataService, ProjectRepository projectRepository, MetadataRepository metadataRepository, AdminManagementClientFactory adminManagementClientFactory, CollectInternalConfiguration configuration) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.collectService = collectService;
        this.metadataService = metadataService;
        this.projectRepository = projectRepository;
        this.metadataRepository = metadataRepository;
        this.configuration = configuration;
    }

    public void processStream(InputStream inputStreamObject, String projectId, String transactionId, @Nullable String encoding, @Nullable String explicitAttachementId) throws CollectInternalException {
        ProjectModel projectModel = this.getProjectModel(projectId);
        this.validateExplicitAttachementId(transactionId, explicitAttachementId);
        Map<String, String> attachmentUnitsBySystemId = this.createOrGetAttachementUnits(transactionId, explicitAttachementId, projectModel);
        try (TempWorkspace tempWorkspace = new TempWorkspace();){
            PreprocessingResult preprocessingResult = this.preprocessZipFile(inputStreamObject, transactionId, encoding, tempWorkspace, projectModel);
            File unitsToWriteFile = preprocessingResult.unitsToWriteFile();
            File objectGroupsToWriteFile = preprocessingResult.objectGroupsToWriteFile();
            File metadataFile = preprocessingResult.metadataFile();
            File jsonlMetadataFile = this.validateAndConvertMetadataToJsonl(metadataFile, tempWorkspace, explicitAttachementId != null);
            BidiMap<String, String> unitIdToObjectGroupIdOverrideMap = this.parseObjectFilesPathDeclarations(jsonlMetadataFile, unitsToWriteFile);
            unitsToWriteFile = FluxService.updateUnitObjectGroups(tempWorkspace, unitsToWriteFile, unitIdToObjectGroupIdOverrideMap);
            objectGroupsToWriteFile = this.updateObjectGroupsParentUnits(tempWorkspace, objectGroupsToWriteFile, unitIdToObjectGroupIdOverrideMap);
            jsonlMetadataFile = this.applyPreDynamicAttachementJsltTransformation(jsonlMetadataFile, unitsToWriteFile, projectModel, tempWorkspace);
            TopLevelUnitAttachmentResolver topLevelUnitAttachementResolver = this.computeTopLevelUnitAttachments(jsonlMetadataFile, projectModel, explicitAttachementId, attachmentUnitsBySystemId);
            jsonlMetadataFile = this.applyPostDynamicAttachementJsltTransformation(jsonlMetadataFile, unitsToWriteFile, projectModel, tempWorkspace);
            this.bulkWriteUnits(unitsToWriteFile, tempWorkspace, topLevelUnitAttachementResolver);
            this.bulkWriteObjectGroups(objectGroupsToWriteFile);
            this.bulkUpdateUnits(transactionId, jsonlMetadataFile);
        }
        catch (CollectInternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CollectInternalException("An unexpected error occurs when try to upload the ZIP: " + e.getMessage(), (Throwable)e);
        }
    }

    private PreprocessingResult preprocessZipFile(InputStream inputStreamObject, String transactionId, String encoding, TempWorkspace tempWorkspace, ProjectModel projectModel) throws IOException, CollectInternalException {
        File unitsToWriteFile = tempWorkspace.tempFile();
        File objectGroupsToWriteFile = tempWorkspace.tempFile();
        File metadataFile = null;
        boolean isEmpty = true;
        try (InputStream inputStreamClosable = StreamUtils.getRemainingReadOnCloseInputStream((InputStream)inputStreamObject);
             ZipArchiveInputStream archiveInputStream = new ZipArchiveInputStream(inputStreamClosable, encoding);
             FileOutputStream unitsToWriteOutputStream = new FileOutputStream(unitsToWriteFile);
             JsonLineWriter unitToWriteWriter = new JsonLineWriter((OutputStream)unitsToWriteOutputStream);
             FileOutputStream objectGroupsToWriteOutputStream = new FileOutputStream(objectGroupsToWriteFile);
             JsonLineWriter objectGroupsToWriteWriter = new JsonLineWriter((OutputStream)objectGroupsToWriteOutputStream);){
            ZipArchiveEntry entry;
            HashMap<String, String> unitIdsByUploadPath = new HashMap<String, String>();
            ArchiveEntryInputStream entryInputStream = new ArchiveEntryInputStream((InputStream)archiveInputStream);
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (archiveInputStream.canReadEntryData((ArchiveEntry)entry)) {
                    this.checkNonEmptyBinary((ArchiveEntry)entry);
                    if (Strings.isNullOrEmpty((String)entry.getName())) continue;
                    String path = FilenameUtils.normalize((String)entry.getName());
                    if (!FilenameUtils.equals((String)entry.getName(), (String)path)) {
                        throw new IllegalStateException("path " + path + " is not canonical");
                    }
                    path = FilenameUtils.normalizeNoEndSeparator((String)path);
                    if (!entry.isDirectory() && (path.equals(METADATA_JSONL_FILE) || path.equals(METADATA_CSV_FILE))) {
                        if (metadataFile != null) {
                            throw new CollectInternalInvalidRequestException("Cannot process zip upload for " + projectModel.getId() + "/" + transactionId + ". Multiple metadata update files found.");
                        }
                        metadataFile = tempWorkspace.writeToFile(path, (InputStream)entryInputStream);
                    } else {
                        this.createMetadata(tempWorkspace, unitToWriteWriter, objectGroupsToWriteWriter, transactionId, path, (InputStream)entryInputStream, entry.isDirectory(), unitIdsByUploadPath, projectModel);
                    }
                    isEmpty = false;
                }
                entryInputStream.setClosed(false);
            }
        }
        catch (ZipException e) {
            throw new CollectInternalInvalidRequestException("Invalid ZIP archive: " + e.getMessage(), (Throwable)e);
        }
        if (isEmpty) {
            throw new CollectInternalInvalidRequestException("Empty zip file.");
        }
        return new PreprocessingResult(unitsToWriteFile, objectGroupsToWriteFile, metadataFile);
    }

    private ProjectModel getProjectModel(String projectId) throws CollectInternalException {
        Optional<ProjectModel> projectById = this.projectRepository.findProjectById(projectId);
        if (projectById.isEmpty()) {
            throw new CollectInternalException("Project not found");
        }
        return projectById.get();
    }

    private void validateExplicitAttachementId(String transactionId, String explicitAttachementId) throws CollectInternalException {
        if (explicitAttachementId == null) {
            return;
        }
        try {
            SelectMultiQuery query = new SelectMultiQuery();
            query.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.id(), (String)explicitAttachementId)});
            query.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            RequestResponseOK<JsonNode> units = this.metadataService.selectUnitsByTransactionId((JsonNode)query.getFinalSelect(), transactionId);
            if (units.getResults().isEmpty()) {
                throw new CollectInternalInvalidRequestException("No such unit with id '" + explicitAttachementId + "' in the transaction");
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new CollectInternalServerSideException(e);
        }
    }

    private Map<String, String> createOrGetAttachementUnits(String transactionId, String explicitAttachementId, ProjectModel projectModel) throws CollectInternalException {
        if (explicitAttachementId != null) {
            return Collections.emptyMap();
        }
        return this.metadataService.prepareAttachmentUnits(projectModel, transactionId);
    }

    private File validateAndConvertMetadataToJsonl(File metadataFile, TempWorkspace tempWorkspace, boolean explicitAttachementMode) throws CollectInternalException {
        if (metadataFile == null) {
            return null;
        }
        if (metadataFile.getName().equals(METADATA_CSV_FILE)) {
            return this.csvMetadataToConvertedJsonlMetadataFile(tempWorkspace, metadataFile, explicitAttachementMode);
        }
        return this.validateJsonlMetadataFile(metadataFile, explicitAttachementMode);
    }

    @Beta
    private File applyPreDynamicAttachementJsltTransformation(File jsonlMetadataFile, File unitsToWriteFile, ProjectModel projectModel, TempWorkspace tempWorkspace) throws CollectInternalException, IOException {
        if (StringUtils.isBlank((CharSequence)projectModel.getTransformationRules()) || this.configuration.isApplyJsltPostDynamicAttachement()) {
            return jsonlMetadataFile;
        }
        File fullJsonlMetadataFile = this.mergeDefaultMetadataIntoMetadataJsonl(unitsToWriteFile, jsonlMetadataFile, tempWorkspace);
        return this.transformJsonMetadataFile(projectModel, tempWorkspace, fullJsonlMetadataFile);
    }

    @Beta
    private File applyPostDynamicAttachementJsltTransformation(File jsonlMetadataFile, File unitsToWriteFile, ProjectModel projectModel, TempWorkspace tempWorkspace) throws CollectInternalException, IOException {
        if (StringUtils.isBlank((CharSequence)projectModel.getTransformationRules()) || !this.configuration.isApplyJsltPostDynamicAttachement()) {
            return jsonlMetadataFile;
        }
        File fullJsonlMetadataFile = this.mergeDefaultMetadataIntoMetadataJsonl(unitsToWriteFile, jsonlMetadataFile, tempWorkspace);
        return this.transformJsonMetadataFile(projectModel, tempWorkspace, fullJsonlMetadataFile);
    }

    private File mergeDefaultMetadataIntoMetadataJsonl(File unitsToWriteFile, File jsonlMetadataFile, TempWorkspace tempWorkspace) throws IOException, CollectInternalException {
        Map<String, TitleAndDescriptionLevel> defaultUnitMetadataByUploadPath = this.loadDefaultMetadataUnits(unitsToWriteFile);
        File fullMetadataJsonlFile = tempWorkspace.tempFile();
        try (FileOutputStream outputStream = new FileOutputStream(fullMetadataJsonlFile);
             JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
            if (jsonlMetadataFile != null) {
                try (JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)new FileInputStream(jsonlMetadataFile), COLLECT_JSON_METADATA_LINE_TYPE_REFERENCE);){
                    while (iterator.hasNext()) {
                        CollectJsonMetadataLine entry = (CollectJsonMetadataLine)iterator.next();
                        String uploadPath = JsonlHelper.getInitialUploadPath(entry);
                        TitleAndDescriptionLevel unitMetadata = defaultUnitMetadataByUploadPath.get(uploadPath);
                        if (unitMetadata == null) {
                            throw new CollectInternalInvalidRequestException("Invalid metadata file. No such File '" + uploadPath + "'");
                        }
                        if (!entry.getUnitContent().has(TITLE_FIELD)) {
                            entry.getUnitContent().put(TITLE_FIELD, unitMetadata.title());
                        }
                        if (!entry.getUnitContent().has(DESCRIPTION_LEVEL_FIELD)) {
                            entry.getUnitContent().put(DESCRIPTION_LEVEL_FIELD, unitMetadata.descriptionLevel());
                        }
                        writer.addEntry((Object)entry);
                        defaultUnitMetadataByUploadPath.remove(uploadPath);
                    }
                }
            }
            for (String fileUploadPath : defaultUnitMetadataByUploadPath.keySet()) {
                TitleAndDescriptionLevel unitMetadata = defaultUnitMetadataByUploadPath.get(fileUploadPath);
                ObjectNode metadata = JsonHandler.createObjectNode();
                metadata.put(TITLE_FIELD, unitMetadata.title());
                metadata.put(DESCRIPTION_LEVEL_FIELD, unitMetadata.descriptionLevel());
                writer.addEntry((Object)new CollectJsonMetadataLine(fileUploadPath, null, null, metadata));
            }
        }
        return fullMetadataJsonlFile;
    }

    private Map<String, TitleAndDescriptionLevel> loadDefaultMetadataUnits(File unitsToWriteFile) throws IOException {
        HashMap<String, TitleAndDescriptionLevel> unitMetadataByPath = new HashMap<String, TitleAndDescriptionLevel>();
        try (FileInputStream inputStream = new FileInputStream(unitsToWriteFile);
             JsonLineGenericIterator unitsToWriteIterator = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);){
            while (unitsToWriteIterator.hasNext()) {
                JsonLineModel entry = (JsonLineModel)unitsToWriteIterator.next();
                unitMetadataByPath.put(entry.getParams().get(VitamFieldsHelper.uploadPath()).asText(), new TitleAndDescriptionLevel(entry.getParams().get(TITLE_FIELD).asText(), entry.getParams().get(DESCRIPTION_LEVEL_FIELD).asText()));
            }
        }
        return unitMetadataByPath;
    }

    @Beta
    private File transformJsonMetadataFile(ProjectModel projectModel, TempWorkspace tempWorkspace, File validatedJsonlMetadataFile) throws CollectInternalException, IOException {
        try {
            JsltTransformer jsltTransformer = new JsltTransformer(projectModel.getTransformationRules());
            File transformedJsonlMetadataFile = tempWorkspace.tempFile();
            try (JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)new FileInputStream(validatedJsonlMetadataFile), COLLECT_JSON_METADATA_LINE_TYPE_REFERENCE);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)new FileOutputStream(transformedJsonlMetadataFile));){
                while (iterator.hasNext()) {
                    CollectJsonMetadataLine entry = (CollectJsonMetadataLine)iterator.next();
                    ObjectNode initialUnitContent = entry.getUnitContent();
                    ObjectNode transformedUnitContent = jsltTransformer.transform((JsonNode)initialUnitContent);
                    CollectJsonMetadataLine transformedJsonMetadataLine = new CollectJsonMetadataLine(entry.getFile(), entry.getObjectFiles(), entry.getSelector(), transformedUnitContent);
                    writer.addEntry((Object)transformedJsonMetadataLine);
                }
            }
            return transformedJsonlMetadataFile;
        }
        catch (CollectJsltTransformationFailedException e) {
            throw new CollectInternalInvalidRequestException("Invalid JSLT transformation", (Throwable)((Object)e));
        }
        catch (CollectInvalidJsltTransformerException e) {
            throw new CollectInternalServerSideException("JSLT transformation failed: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    private File csvMetadataToConvertedJsonlMetadataFile(TempWorkspace tempWorkspace, File metadataFile, boolean explicitAttachementMode) throws CollectInternalException {
        SedaSchemaInfoResolver sedaSchemaInfoResolver = new SedaSchemaInfoResolver(this.adminManagementClientFactory);
        try {
            File tranformedMetadataFile = tempWorkspace.tempFile();
            try (FileInputStream is = new FileInputStream(metadataFile);){
                CsvHelper.convertCsvToJsonlMetadataFile(sedaSchemaInfoResolver, is, tranformedMetadataFile, true, explicitAttachementMode);
            }
            return tranformedMetadataFile;
        }
        catch (IOException e) {
            throw new CollectInternalServerSideException("An internal error occurred during csv metadata file processing", (Throwable)e);
        }
    }

    private File validateJsonlMetadataFile(File jsonlMetadataFile, boolean explicitAttachementMode) throws CollectInternalException {
        JsonlMetadataFileValidator jsonlMetadataFileValidator = new JsonlMetadataFileValidator();
        jsonlMetadataFileValidator.validate(jsonlMetadataFile, true, explicitAttachementMode);
        return jsonlMetadataFile;
    }

    private BidiMap<String, String> parseObjectFilesPathDeclarations(File jsonlMetadataFile, File unitsToWriteFile) throws IOException, CollectInternalInvalidRequestException {
        if (jsonlMetadataFile == null) {
            return new DualHashBidiMap();
        }
        HashMap<String, String> initialUploadPathToUnitId = new HashMap<String, String>();
        HashMap<String, String> initialUploadPathToObjectGroupId = new HashMap<String, String>();
        try (FileInputStream inputStream = new FileInputStream(unitsToWriteFile);
             JsonLineGenericIterator unitsToWrite = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);){
            while (unitsToWrite.hasNext()) {
                JsonLineModel entry = (JsonLineModel)unitsToWrite.next();
                String uploadPath = entry.getParams().get(VitamFieldsHelper.uploadPath()).asText();
                String unitId = entry.getParams().get(VitamFieldsHelper.id()).asText();
                initialUploadPathToUnitId.put(uploadPath, unitId);
                if (!entry.getParams().has(VitamFieldsHelper.object())) continue;
                String objectGroupId = entry.getParams().get(VitamFieldsHelper.object()).asText();
                initialUploadPathToObjectGroupId.put(uploadPath, objectGroupId);
            }
        }
        HashSet<String> duplicatePaths = new HashSet<String>();
        DualHashBidiMap unitPathToObjectFilePathMap = new DualHashBidiMap();
        try (JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)new FileInputStream(jsonlMetadataFile), COLLECT_JSON_METADATA_LINE_TYPE_REFERENCE);){
            while (iterator.hasNext()) {
                CollectJsonMetadataLine entry = (CollectJsonMetadataLine)iterator.next();
                String uploadPath = JsonlHelper.getInitialUploadPath(entry);
                if (duplicatePaths.contains(uploadPath)) {
                    throw new CollectInternalInvalidRequestException("Duplicate File or #uploadPath selector declaration for '" + uploadPath + "'");
                }
                duplicatePaths.add(uploadPath);
                if (!initialUploadPathToUnitId.containsKey(uploadPath)) {
                    throw new CollectInternalInvalidRequestException("Invalid File or #uploadPath selector '" + uploadPath + "'. No such file or directory.");
                }
                String objectFilesPath = entry.getObjectFiles();
                if (objectFilesPath == null) continue;
                if (!initialUploadPathToObjectGroupId.containsKey(objectFilesPath)) {
                    if (initialUploadPathToUnitId.containsKey(objectFilesPath)) {
                        throw new CollectInternalInvalidRequestException("Invalid ObjectFiles value '" + objectFilesPath + "'. Must be a file.");
                    }
                    throw new CollectInternalInvalidRequestException("Invalid ObjectFiles value '" + objectFilesPath + "'. No such file.");
                }
                if (objectFilesPath.equals(uploadPath)) continue;
                if (duplicatePaths.contains(objectFilesPath)) {
                    throw new CollectInternalInvalidRequestException("Duplicate ObjectFiles declaration for '" + objectFilesPath + "'");
                }
                duplicatePaths.add(objectFilesPath);
                if (initialUploadPathToObjectGroupId.containsKey(uploadPath)) {
                    throw new CollectInternalInvalidRequestException("ObjectFiles value '" + objectFilesPath + "' can only be set when File or #uploadPath selector '" + uploadPath + "' is a directory.");
                }
                unitPathToObjectFilePathMap.put((Object)uploadPath, (Object)objectFilesPath);
            }
        }
        if (unitPathToObjectFilePathMap.isEmpty()) {
            return unitPathToObjectFilePathMap;
        }
        DualHashBidiMap unitIdToObjectGroupIdRemapping = new DualHashBidiMap();
        for (String uploadPath : unitPathToObjectFilePathMap.keySet()) {
            String newObjectPath = (String)unitPathToObjectFilePathMap.get((Object)uploadPath);
            String unitId = (String)initialUploadPathToUnitId.get(uploadPath);
            String objectGroupId = (String)initialUploadPathToObjectGroupId.get(newObjectPath);
            unitIdToObjectGroupIdRemapping.put((Object)unitId, (Object)objectGroupId);
        }
        return unitIdToObjectGroupIdRemapping;
    }

    private static File updateUnitObjectGroups(TempWorkspace tempWorkspace, File unitsToWriteFile, BidiMap<String, String> unitIdToObjectGroupIdOverrideMap) throws IOException {
        if (unitIdToObjectGroupIdOverrideMap.isEmpty()) {
            return unitsToWriteFile;
        }
        File updatedUnitsToWriteFile = tempWorkspace.tempFile();
        try (FileInputStream inputStream = new FileInputStream(unitsToWriteFile);
             JsonLineGenericIterator unitsToWrite = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);
             FileOutputStream unitsToWriteOutputStream = new FileOutputStream(updatedUnitsToWriteFile);
             JsonLineWriter unitToWriteWriter = new JsonLineWriter((OutputStream)unitsToWriteOutputStream);){
            while (unitsToWrite.hasNext()) {
                String objectGroupId;
                JsonLineModel entry = (JsonLineModel)unitsToWrite.next();
                ObjectNode unit = (ObjectNode)entry.getParams();
                String unitId = unit.get(VitamFieldsHelper.id()).asText();
                if (unit.has(VitamFieldsHelper.object()) && unitIdToObjectGroupIdOverrideMap.containsValue((Object)(objectGroupId = unit.get(VitamFieldsHelper.object()).asText()))) continue;
                if (unitIdToObjectGroupIdOverrideMap.containsKey((Object)unitId)) {
                    String newObjectGroupId = (String)unitIdToObjectGroupIdOverrideMap.get((Object)unitId);
                    unit.put(VitamFieldsHelper.object(), newObjectGroupId);
                    unit.put(DESCRIPTION_LEVEL_FIELD, LevelType.ITEM.value());
                }
                unitToWriteWriter.addEntry(entry);
            }
        }
        return updatedUnitsToWriteFile;
    }

    private File updateObjectGroupsParentUnits(TempWorkspace tempWorkspace, File objectsToWriteFile, BidiMap<String, String> unitIdToObjectGroupIdOverrideMap) throws IOException {
        if (unitIdToObjectGroupIdOverrideMap.isEmpty()) {
            return objectsToWriteFile;
        }
        File updatedObjectGroupsToWriteFile = tempWorkspace.tempFile();
        try (JsonLineGenericIterator ogIterator = new JsonLineGenericIterator((InputStream)new FileInputStream(objectsToWriteFile), (TypeReference)new TypeReference<ObjectNode>(this){});
             FileOutputStream objectGroupsToWriteOutputStream = new FileOutputStream(updatedObjectGroupsToWriteFile);
             JsonLineWriter objectGroupsToWriteWriter = new JsonLineWriter((OutputStream)objectGroupsToWriteOutputStream);){
            while (ogIterator.hasNext()) {
                ObjectNode objectGroup = (ObjectNode)ogIterator.next();
                String objectGroupId = objectGroup.get(VitamFieldsHelper.id()).asText();
                if (unitIdToObjectGroupIdOverrideMap.containsValue((Object)objectGroupId)) {
                    String newUnitId = (String)unitIdToObjectGroupIdOverrideMap.getKey((Object)objectGroupId);
                    objectGroup.set(VitamFieldsHelper.unitups(), (JsonNode)JsonHandler.createStringArrayNode((String[])new String[]{newUnitId}));
                }
                objectGroupsToWriteWriter.addEntry((Object)objectGroup);
            }
        }
        return updatedObjectGroupsToWriteFile;
    }

    private void checkNonEmptyBinary(ArchiveEntry entry) throws CollectInternalInvalidRequestException {
        if (!entry.isDirectory() && entry.getSize() == 0L) {
            throw new CollectInternalInvalidRequestException("Cannot upload empty file '" + entry.getName() + "'");
        }
    }

    private TopLevelUnitAttachmentResolver computeTopLevelUnitAttachments(File jsonlMetadataFile, ProjectModel projectModel, String explicitAttachementId, Map<String, String> attachmentUnitsBySystemId) throws IOException {
        String staticAttachmentUnitId;
        if (explicitAttachementId != null) {
            return TopLevelUnitAttachmentResolver.singleton(explicitAttachementId);
        }
        if (attachmentUnitsBySystemId.isEmpty()) {
            return TopLevelUnitAttachmentResolver.empty();
        }
        String string = staticAttachmentUnitId = projectModel.getUnitUp() != null ? attachmentUnitsBySystemId.get(projectModel.getUnitUp()) : null;
        if (jsonlMetadataFile == null) {
            if (projectModel.getUnitUp() != null) {
                return TopLevelUnitAttachmentResolver.singleton(staticAttachmentUnitId);
            }
            return TopLevelUnitAttachmentResolver.empty();
        }
        Map<String, Set<String>> unitUpsByUploadPath = this.computeUnitUpsFormUnitMetadata(jsonlMetadataFile, projectModel, attachmentUnitsBySystemId, staticAttachmentUnitId);
        return uploadPath -> {
            if (unitUpsByUploadPath.containsKey(uploadPath)) {
                return (Set)unitUpsByUploadPath.get(uploadPath);
            }
            if (staticAttachmentUnitId != null) {
                return Collections.singleton(staticAttachmentUnitId);
            }
            return Collections.emptySet();
        };
    }

    private Map<String, Set<String>> computeUnitUpsFormUnitMetadata(File jsonlMetadataFile, ProjectModel projectModel, Map<String, String> attachmentUnitsBySystemId, String staticAttachmentUnitId) throws IOException {
        HashMap<String, Set<String>> unitUpsByUploadPath = new HashMap<String, Set<String>>();
        try (JsonLineGenericIterator iterator = new JsonLineGenericIterator((InputStream)new FileInputStream(jsonlMetadataFile), COLLECT_JSON_METADATA_LINE_TYPE_REFERENCE);){
            while (iterator.hasNext()) {
                CollectJsonMetadataLine jsonMetadataLine = (CollectJsonMetadataLine)iterator.next();
                String uploadPath = jsonMetadataLine.getFile();
                if (FluxService.isNotRootLevelUnit(uploadPath)) continue;
                ObjectNode unitContent = jsonMetadataLine.getUnitContent();
                Set<String> unitUps = this.computeAttachmentUnitUps(unitContent, projectModel, attachmentUnitsBySystemId, staticAttachmentUnitId);
                unitUpsByUploadPath.put(uploadPath, unitUps);
            }
        }
        return unitUpsByUploadPath;
    }

    private Set<String> computeAttachmentUnitUps(ObjectNode unitContent, ProjectModel projectModel, Map<String, String> attachmentUnitsBySystemId, String staticAttachmentUnitId) {
        Set<String> dynamicAttachmentUnitUps;
        if (unitContent.has(VitamFieldsHelper.management()) && unitContent.get(VitamFieldsHelper.management()).has("UpdateOperation")) {
            return Collections.emptySet();
        }
        if (CollectionUtils.isNotEmpty(projectModel.getUnitUps()) && !(dynamicAttachmentUnitUps = MetadataHelper.findUnitParent(unitContent, projectModel.getUnitUps(), attachmentUnitsBySystemId)).isEmpty()) {
            return dynamicAttachmentUnitUps;
        }
        if (staticAttachmentUnitId != null) {
            return Collections.singleton(staticAttachmentUnitId);
        }
        return Collections.emptySet();
    }

    private static boolean isNotRootLevelUnit(String uploadPath) {
        return StringUtils.contains((CharSequence)uploadPath, (int)File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetadata(TempWorkspace tempWorkspace, JsonLineWriter unitToWriteWriter, JsonLineWriter objectGroupsToWriteWriter, String transactionId, String path, InputStream entryInputStream, boolean isDirectory, Map<String, String> unitIdsByUploadPath, ProjectModel projectModel) throws IOException, CollectInternalException {
        String parentUnit;
        LevelType descriptionLevel = isDirectory ? LevelType.RECORD_GRP : LevelType.ITEM;
        String parentPath = FilenameUtils.getPathNoEndSeparator((String)path);
        if (Strings.isNullOrEmpty((String)parentPath)) {
            parentUnit = null;
        } else {
            parentUnit = unitIdsByUploadPath.get(parentPath);
            if (parentUnit == null) {
                LOGGER.debug("Creating implicit parent folder '{}'", (Object)parentPath);
                this.createMetadata(tempWorkspace, unitToWriteWriter, objectGroupsToWriteWriter, transactionId, parentPath, null, true, unitIdsByUploadPath, projectModel);
            }
            parentUnit = unitIdsByUploadPath.get(parentPath);
        }
        String fileName = FilenameUtils.getName((String)path);
        String originationAgency = null;
        if (projectModel.getManifestContext() != null && StringUtils.isNotEmpty((CharSequence)projectModel.getManifestContext().getOriginatingAgencyIdentifier())) {
            originationAgency = projectModel.getManifestContext().getOriginatingAgencyIdentifier();
        }
        ArchiveUnitModel unit = MetadataHelper.createUnit(transactionId, descriptionLevel, path, fileName, parentUnit, originationAgency);
        unitIdsByUploadPath.put(path, unit.getId());
        if (!isDirectory) {
            String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
            String objectId = GUIDFactory.newGUID().getId();
            String newFilename = Strings.isNullOrEmpty((String)extension) ? objectId : objectId + "." + extension;
            File binaryFile = tempWorkspace.writeToFile(newFilename, entryInputStream);
            try {
                Optional<FormatIdentifierResponse> formatIdentifierResponseOpt = this.collectService.detectFileFormat(binaryFile);
                DigestWithSize binaryInfo = this.writeObjectToWorkspace(transactionId, binaryFile, newFilename);
                String originatingAgency = null;
                if (projectModel.getManifestContext() != null && StringUtils.isNotEmpty((CharSequence)projectModel.getManifestContext().getOriginatingAgencyIdentifier())) {
                    originatingAgency = projectModel.getManifestContext().getOriginatingAgencyIdentifier();
                }
                ObjectGroupResponse objectGroup = MetadataHelper.createObjectGroup(transactionId, fileName, objectId, newFilename, formatIdentifierResponseOpt, binaryInfo.digest(), binaryInfo.size(), originatingAgency, unit.getId());
                FluxService.writeObjectGroupToTemporaryFile(objectGroupsToWriteWriter, objectGroup);
                unit.setOg(objectGroup.getId());
            }
            finally {
                Files.deleteIfExists(binaryFile.toPath());
            }
        }
        FluxService.writeUnitToTemporaryFile(unitToWriteWriter, StringUtils.countMatches((CharSequence)path, (CharSequence)File.separator), unit);
    }

    private void bulkWriteUnits(File unitsToWriteFile, TempWorkspace tempWorkspace, TopLevelUnitAttachmentResolver topLevelUnitAttachementResolver) throws IOException {
        List<File> filePerLevel = this.splitFilePerLevel(unitsToWriteFile, tempWorkspace);
        for (File file : filePerLevel) {
            try (FileInputStream inputStream = new FileInputStream(file);
                 JsonLineGenericIterator unitsToWrite = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);){
                Iterator unitIterator = IteratorUtils.transformedIterator((Iterator)unitsToWrite, e -> {
                    ObjectNode unitContent = (ObjectNode)e.getParams();
                    if (e.getDistribGroup() == 0) {
                        this.updateParents(unitContent, topLevelUnitAttachementResolver);
                    }
                    return unitContent;
                });
                Iterators.partition((Iterator)unitIterator, (int)1000).forEachRemaining(units -> {
                    try {
                        this.metadataRepository.saveArchiveUnits((List<ObjectNode>)units);
                    }
                    catch (CollectInternalException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> splitFilePerLevel(File unitsToWriteFile, TempWorkspace tempWorkspace) throws IOException {
        ArrayList<File> filePerLevel = new ArrayList<File>();
        ArrayList<JsonLineWriter> writerPerLevel = new ArrayList<JsonLineWriter>();
        try (FileInputStream inputStream = new FileInputStream(unitsToWriteFile);
             JsonLineGenericIterator unitsToWrite = new JsonLineGenericIterator((InputStream)inputStream, JSON_LINE_MODEL_TYPE_REFERENCE);){
            while (unitsToWrite.hasNext()) {
                JsonLineWriter writer;
                JsonLineModel entry = (JsonLineModel)unitsToWrite.next();
                int level = entry.getDistribGroup();
                if (writerPerLevel.size() > level) {
                    writer = (JsonLineWriter)writerPerLevel.get(level);
                } else if (writerPerLevel.size() == level) {
                    File file = tempWorkspace.tempFile();
                    filePerLevel.add(file);
                    writer = new JsonLineWriter((OutputStream)new FileOutputStream(file));
                    writerPerLevel.add(writer);
                } else {
                    throw new IllegalStateException("Level : " + level + ", nb writers: " + writerPerLevel.size());
                }
                writer.addEntry(entry);
            }
        }
        finally {
            for (JsonLineWriter writer : writerPerLevel) {
                writer.close();
            }
        }
        return filePerLevel;
    }

    private void updateParents(ObjectNode unit, TopLevelUnitAttachmentResolver topLevelUnitAttachmentResolver) {
        String unitUploadPath = unit.get(VitamFieldsHelper.uploadPath()).asText();
        Set<String> parentUnitIds = topLevelUnitAttachmentResolver.getParentUnits(unitUploadPath);
        if (CollectionUtils.isNotEmpty(parentUnitIds)) {
            unit.set(VitamFieldsHelper.unitups(), (JsonNode)JsonHandler.createStringArrayNode(parentUnitIds));
        }
    }

    private void bulkWriteObjectGroups(File ogFile) throws IOException {
        if (!ogFile.exists()) {
            LOGGER.info("No object group to insert");
            return;
        }
        try (JsonLineGenericIterator ogIterator = new JsonLineGenericIterator((InputStream)new FileInputStream(ogFile), (TypeReference)new TypeReference<ObjectNode>(this){});){
            Iterators.partition((Iterator)ogIterator, (int)1000).forEachRemaining(objectGroups -> {
                try {
                    this.metadataRepository.saveObjectGroups((List<ObjectNode>)objectGroups);
                }
                catch (CollectInternalException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static void writeObjectGroupToTemporaryFile(JsonLineWriter objectGroupsToWriteWriter, ObjectGroupResponse objectGroup) throws IOException {
        objectGroupsToWriteWriter.addEntry(VitamObjectMapper.getSerializationObjectMapper().convertValue((Object)objectGroup, JsonNode.class));
    }

    private static void writeUnitToTemporaryFile(JsonLineWriter unitToWriteWriter, int level, ArchiveUnitModel unit) throws IOException {
        JsonNode unitJson = (JsonNode)VitamObjectMapper.getSerializationObjectMapper().convertValue((Object)unit, JsonNode.class);
        unitToWriteWriter.addEntry(new JsonLineModel(unit.getId(), Integer.valueOf(level), unitJson));
    }

    private DigestWithSize writeObjectToWorkspace(String transactionId, File fileToWrite, String fileName) throws IOException, CollectInternalException {
        try (BoundedInputStream countingInputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)new FileInputStream(fileToWrite))).get();){
            String digest = this.collectService.pushStreamToWorkspace(transactionId, (InputStream)countingInputStream, "Content".concat(File.separator).concat(fileName));
            DigestWithSize digestWithSize = new DigestWithSize(digest, countingInputStream.getCount());
            return digestWithSize;
        }
    }

    private void bulkUpdateUnits(String transactionId, File jsonlMetadataFile) throws IOException, CollectInternalException {
        if (jsonlMetadataFile != null) {
            try (FileInputStream is = new FileInputStream(jsonlMetadataFile);){
                this.metadataService.updateUnitsWithJsonlMetadataFile(transactionId, is);
            }
        }
    }

    private record PreprocessingResult(File unitsToWriteFile, File objectGroupsToWriteFile, File metadataFile) {
    }

    @FunctionalInterface
    private static interface TopLevelUnitAttachmentResolver {
        public Set<String> getParentUnits(String var1);

        public static TopLevelUnitAttachmentResolver empty() {
            return uploadPath -> Collections.emptySet();
        }

        public static TopLevelUnitAttachmentResolver singleton(String parentId) {
            Set<String> parentUnits = Collections.singleton(parentId);
            return uploadPath -> parentUnits;
        }
    }

    private record TitleAndDescriptionLevel(String title, String descriptionLevel) {
    }

    public record DigestWithSize(String digest, long size) {
    }
}

