/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.InsertMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserHelper;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertEntry;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertRequest;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.metadata.common.utils.TransactionRestrictionHelper;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.ProcessingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataRepository {
    private static final String DATA_CATEGORY = "Data category ";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataRepository.class);
    private static final String NOT_A_SELECT_OPERATION = "Not a Select operation";
    private final MetaDataClientFactory metaDataCollectClientFactory;

    public MetadataRepository(MetaDataClientFactory metaDataCollectClientFactory) {
        this.metaDataCollectClientFactory = metaDataCollectClientFactory;
    }

    public RequestResponseOK<JsonNode> selectUnits(JsonNode queryDsl, @Nonnull String transactionId) throws CollectInternalException {
        RequestResponseOK requestResponseOK;
        block8: {
            MetaDataClient metaDataClient = this.metaDataCollectClientFactory.getClient();
            try {
                SelectParserMultiple parser = new SelectParserMultiple();
                parser.parse(queryDsl);
                TransactionRestrictionHelper.applyTransactionToQuery((String)transactionId, (RequestMultiple)parser.getRequest());
                JsonNode jsonNode = metaDataClient.selectUnits((JsonNode)parser.getRequest().getFinalSelect());
                requestResponseOK = (RequestResponseOK)JsonHandler.getFromJsonNode((JsonNode)jsonNode, RequestResponseOK.class, JsonNode.class);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    LOGGER.error("Error when getting units in metadata:", e);
                    throw new CollectInternalException("Error when getting units in metadata: " + String.valueOf(e));
                }
            }
            metaDataClient.close();
        }
        return requestResponseOK;
    }

    public ScrollSpliterator<JsonNode> selectUnits(SelectMultiQuery request, @Nonnull String transactionId) {
        return new ScrollSpliterator(request, query -> {
            try {
                return this.selectUnits((JsonNode)request.getFinalSelect(), transactionId);
            }
            catch (CollectInternalException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
    }

    public ScrollSpliterator<JsonNode> selectObjectGroups(SelectMultiQuery request, @Nonnull String transactionId) {
        return new ScrollSpliterator(request, query -> {
            try {
                return (RequestResponse)JsonHandler.getFromJsonNode((JsonNode)this.selectObjectGroups((JsonNode)request.getFinalSelect(), transactionId), RequestResponseOK.class, JsonNode.class);
            }
            catch (CollectInternalException | InvalidParseOperationException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
    }

    public JsonNode selectUnitById(String unitId) throws CollectInternalException {
        JsonNode jsonNode;
        block9: {
            MetaDataClient client = this.metaDataCollectClientFactory.getClient();
            try {
                SelectMultiQuery select = new SelectMultiQuery();
                JsonNode jsonNode2 = client.selectUnitbyId((JsonNode)select.getFinalSelect(), unitId);
                RequestResponseOK response = (RequestResponseOK)JsonHandler.getFromJsonNode((JsonNode)jsonNode2, RequestResponseOK.class, JsonNode.class);
                if (response.getResults().isEmpty()) {
                    throw new CollectInternalException("Cannot find unit with id = " + unitId);
                }
                jsonNode = (JsonNode)response.getFirstResult();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataException e) {
                    LOGGER.error("Error when fetching unit in metadata:", e);
                    throw new CollectInternalException("Error when fetching unit in metadata: " + String.valueOf(e));
                }
            }
            client.close();
        }
        return jsonNode;
    }

    public JsonNode selectObjectGroups(JsonNode queryDsl, @Nonnull String transactionId) throws CollectInternalException {
        JsonNode jsonNode;
        block8: {
            MetaDataClient metaDataClient = this.metaDataCollectClientFactory.getClient();
            try {
                SelectParserMultiple parser = new SelectParserMultiple();
                parser.parse(queryDsl);
                TransactionRestrictionHelper.applyTransactionToQuery((String)transactionId, (RequestMultiple)parser.getRequest());
                jsonNode = metaDataClient.selectObjectGroups((JsonNode)parser.getRequest().getFinalSelect());
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    LOGGER.error("Error when getting units in metadata:", e);
                    throw new CollectInternalException("Error when getting units in metadata: " + String.valueOf(e));
                }
            }
            metaDataClient.close();
        }
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode selectObjectGroupById(String objectGroupId, boolean isRaw) throws CollectInternalException {
        try (MetaDataClient client = this.metaDataCollectClientFactory.getClient();){
            SelectMultiQuery select = new SelectMultiQuery();
            if (isRaw) {
                JsonNode jsonNode2 = (JsonNode)((RequestResponseOK)client.getObjectGroupByIdRaw(objectGroupId)).getFirstResult();
                return jsonNode2;
            }
            JsonNode jsonNode = client.selectObjectGrouptbyId((JsonNode)select.getFinalSelect(), objectGroupId);
            return jsonNode;
        }
        catch (InvalidParseOperationException | VitamClientException | MetaDataException e) {
            LOGGER.error("Error when fetching unit in metadata:", e);
            throw new CollectInternalException("Error when fetching unit in metadata: " + String.valueOf(e));
        }
    }

    public RequestResponse<JsonNode> atomicBulkUpdate(@Nonnull List<JsonNode> updateMultiQueries) throws CollectInternalException {
        RequestResponse requestResponse;
        block8: {
            MetaDataClient metaDataClient = this.metaDataCollectClientFactory.getClient();
            try {
                requestResponse = metaDataClient.atomicUpdateBulk(updateMultiQueries);
                if (metaDataClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                    throw new CollectInternalException(e);
                }
            }
            metaDataClient.close();
        }
        return requestResponse;
    }

    public JsonNode saveArchiveUnit(ObjectNode unit) throws CollectInternalException {
        JsonNode jsonNode;
        block8: {
            MetaDataClient client = this.metaDataCollectClientFactory.getClient();
            try {
                BulkUnitInsertEntry insertEntry = MetadataRepository.createInsertEntry(unit);
                jsonNode = client.insertUnitBulk(new BulkUnitInsertRequest(Collections.singletonList(insertEntry)));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataException e) {
                    LOGGER.error("Error while saving unit in metadata:", e);
                    throw new CollectInternalException("Error while saving unit in metadata: " + String.valueOf(e));
                }
            }
            client.close();
        }
        return jsonNode;
    }

    public JsonNode saveArchiveUnits(List<ObjectNode> units) throws CollectInternalException {
        JsonNode jsonNode;
        block8: {
            MetaDataClient client = this.metaDataCollectClientFactory.getClient();
            try {
                List list = units.stream().map(MetadataRepository::createInsertEntry).collect(Collectors.toList());
                jsonNode = client.insertUnitBulk(new BulkUnitInsertRequest(list));
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataException e) {
                    LOGGER.error("Error while saving unit in metadata:", e);
                    throw new CollectInternalException("Error while saving unit in metadata: " + String.valueOf(e));
                }
            }
            client.close();
        }
        return jsonNode;
    }

    private static BulkUnitInsertEntry createInsertEntry(ObjectNode e) {
        JsonNode jsonNode = e.get(VitamFieldsHelper.unitups());
        try {
            if (jsonNode == null || jsonNode.isNull()) {
                return new BulkUnitInsertEntry(Collections.emptySet(), (JsonNode)e);
            }
            return new BulkUnitInsertEntry((Set)JsonHandler.getFromJsonNode((JsonNode)jsonNode, Set.class, String.class), (JsonNode)e);
        }
        catch (InvalidParseOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void updateUnitById(UpdateMultiQuery updateQuery, String transactionId, String unitId) throws CollectInternalException {
        try (MetaDataClient client = this.metaDataCollectClientFactory.getClient();){
            TransactionRestrictionHelper.applyTransactionToQuery((String)transactionId, (RequestMultiple)updateQuery);
            client.updateUnitById((JsonNode)updateQuery.getFinalUpdateById(), unitId);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataException e) {
            LOGGER.error("Error while update updating in metadata:", e);
            throw new CollectInternalException("Error while updating unit in metadata: " + String.valueOf(e));
        }
    }

    public JsonNode saveObjectGroup(ObjectNode og) throws CollectInternalException {
        JsonNode jsonNode;
        block8: {
            MetaDataClient client = this.metaDataCollectClientFactory.getClient();
            try {
                InsertMultiQuery insert = new InsertMultiQuery();
                insert.resetFilter();
                insert.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
                insert.addData(new ObjectNode[]{og});
                jsonNode = client.insertObjectGroup((JsonNode)insert.getFinalInsert());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataException e) {
                    LOGGER.error("Error while saving objectGroup in metadata:", e);
                    throw new CollectInternalException("Error while saving objectGroup in metadata: " + String.valueOf(e));
                }
            }
            client.close();
        }
        return jsonNode;
    }

    public JsonNode saveObjectGroups(List<ObjectNode> objectGroups) throws CollectInternalException {
        JsonNode jsonNode;
        block8: {
            MetaDataClient client = this.metaDataCollectClientFactory.getClient();
            try {
                List collect = objectGroups.stream().map(e -> {
                    InsertMultiQuery insert = new InsertMultiQuery();
                    insert.resetFilter();
                    insert.addData(new ObjectNode[]{e});
                    return insert.getFinalInsert();
                }).collect(Collectors.toList());
                jsonNode = client.insertObjectGroups(collect);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataException e2) {
                    LOGGER.error("Error while saving objectGroup in metadata:", e2);
                    throw new CollectInternalException("Error while saving objectGroup in metadata: " + String.valueOf(e2));
                }
            }
            client.close();
        }
        return jsonNode;
    }

    public void updateObjectGroupById(UpdateMultiQuery updateQuery, String objectGroupId, String transactionId) throws CollectInternalException {
        try (MetaDataClient client = this.metaDataCollectClientFactory.getClient();){
            TransactionRestrictionHelper.applyTransactionToQuery((String)transactionId, (RequestMultiple)updateQuery);
            client.updateObjectGroupById((JsonNode)updateQuery.getFinalUpdate(), objectGroupId);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataException e) {
            LOGGER.error("Error while updating objectGroup in metadata:", e);
            throw new CollectInternalException("Error while updating objectGroup in metadata: " + String.valueOf(e));
        }
    }

    public void deleteUnits(Collection<String> listUnitIds) throws CollectInternalException {
        try (MetaDataClient client = this.metaDataCollectClientFactory.getClient();){
            client.deleteUnitsBulk(listUnitIds);
        }
        catch (MetaDataException e) {
            LOGGER.error("Error when delete units and objects in metadata:", (Throwable)e);
            throw new CollectInternalException("Error when delete units and objects in metadata: " + String.valueOf((Object)e));
        }
    }

    public void deleteObjectGroups(Collection<String> listGotGUID) throws CollectInternalException {
        try (MetaDataClient client = this.metaDataCollectClientFactory.getClient();){
            client.deleteObjectGroupBulk(listGotGUID);
        }
        catch (InvalidParseOperationException | MetaDataException e) {
            LOGGER.error("Error when delete units and objects in metadata:", e);
            throw new CollectInternalException("Error when delete units and objects in metadata: " + String.valueOf(e));
        }
    }

    public JsonNode selectUnitsWithInheritedRules(JsonNode jsonQuery, @Nonnull String transactionId) throws InvalidParseOperationException {
        JsonNode jsonNode;
        block9: {
            ParametersChecker.checkParameter((String)DATA_CATEGORY, (Object[])new Object[]{jsonQuery});
            RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)jsonQuery.deepCopy());
            if (!(parser instanceof SelectParserMultiple)) {
                LOGGER.error(NOT_A_SELECT_OPERATION);
                throw new InvalidParseOperationException(NOT_A_SELECT_OPERATION);
            }
            MetaDataClient metaDataClient = this.metaDataCollectClientFactory.getClient();
            try {
                TransactionRestrictionHelper.applyTransactionToQuery((String)transactionId, (RequestMultiple)parser.getRequest());
                jsonNode = metaDataClient.selectUnitsWithInheritedRules(jsonQuery);
                if (metaDataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | ProcessingException e) {
                    LOGGER.error("Error on selecting units with Inherited Rules", e);
                    throw new InvalidParseOperationException(e);
                }
            }
            metaDataClient.close();
        }
        return jsonNode;
    }
}

