/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.ObjectDto;
import fr.gouv.vitam.collect.internal.core.helpers.builders.DbQualifiersModelBuilder;
import fr.gouv.vitam.collect.internal.core.helpers.builders.DbVersionsModelBuilder;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbQualifiersModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import java.util.HashMap;
import java.util.List;

public class QueryHandler {
    private QueryHandler() throws IllegalAccessException {
        throw new IllegalAccessException("Utility class!");
    }

    public static UpdateMultiQuery getQualifiersAddMultiQuery(DbObjectGroupModel objectGroupModel, DataObjectVersionType usage, int version, ObjectDto objectDto) throws InvalidParseOperationException, InvalidCreateOperationException {
        DbQualifiersModel newQualifier = new DbQualifiersModelBuilder().withUsage(usage).withVersion(objectDto.getId(), objectDto.getFileInfo().getFileName(), usage, version).withNbc(1).build();
        objectGroupModel.getQualifiers().add(newQualifier);
        HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
        action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), JsonHandler.toJsonNode((Object)objectGroupModel.getQualifiers()));
        SetAction setQualifier = new SetAction(action);
        UpdateMultiQuery query = new UpdateMultiQuery();
        query.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
        query.addActions(new Action[]{setQualifier, UpdateActionHelper.set((String)VitamFieldsHelper.nbobjects(), (long)((long)objectGroupModel.getNbc() + 1L))});
        return query;
    }

    public static UpdateMultiQuery getQualifiersUpdateMultiQuery(DbQualifiersModel qualifierModelToUpdate, DataObjectVersionType usage, int version, List<DbQualifiersModel> qualifiers, ObjectDto objectDto, int nbc) throws InvalidParseOperationException, InvalidCreateOperationException {
        int index = qualifiers.indexOf(qualifierModelToUpdate);
        DbVersionsModel dbversion = new DbVersionsModelBuilder().build(objectDto.getId(), objectDto.getFileInfo().getFileName(), usage, version);
        qualifierModelToUpdate.getVersions().add(dbversion);
        qualifierModelToUpdate.setNbc(qualifierModelToUpdate.getNbc() + 1);
        qualifiers.set(index, qualifierModelToUpdate);
        HashMap<String, JsonNode> action = new HashMap<String, JsonNode>();
        action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), JsonHandler.toJsonNode(qualifiers));
        UpdateMultiQuery query = new UpdateMultiQuery();
        query.addActions(new Action[]{UpdateActionHelper.set((String)VitamFieldsHelper.nbobjects(), (long)((long)nbc + 1L)), new SetAction(action)});
        return query;
    }
}

