/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.helpers;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractErrorAccumulator<E extends Exception>
implements AutoCloseable {
    private final List<String> errorMessages = new ArrayList<String>();
    private final int maxErrorCount;

    protected AbstractErrorAccumulator(int maxErrorCount) {
        this.maxErrorCount = maxErrorCount;
    }

    public void report(String errorMessage) throws E {
        this.errorMessages.add(errorMessage);
        if (this.errorMessages.size() >= this.maxErrorCount) {
            this.throwException();
        }
    }

    private void throwException() throws E {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.errorMessages.size() == 1) {
                stringBuilder.append("1 error:");
            } else if (this.errorMessages.size() < this.maxErrorCount) {
                stringBuilder.append(this.errorMessages.size()).append(" errors:");
            } else {
                stringBuilder.append("At least ").append(this.errorMessages.size()).append(" errors:");
            }
            for (String errorMessage : this.errorMessages) {
                stringBuilder.append("\n- ").append(errorMessage);
            }
            throw this.buildException(stringBuilder.toString());
        }
        catch (Throwable throwable) {
            this.errorMessages.clear();
            throw throwable;
        }
    }

    protected abstract E buildException(String var1);

    @Override
    public void close() throws E {
        if (!this.errorMessages.isEmpty()) {
            this.throwException();
        }
    }
}

