/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.collect.common.exception.CollectInternalException;
import fr.gouv.vitam.collect.common.exception.CollectInternalServerSideException;
import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfo;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.schema.SchemaCardinality;
import fr.gouv.vitam.common.model.administration.schema.SchemaOrigin;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaType;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SedaSchemaInfoResolver {
    private final Map<String, SedaSchemaInfo> contentSchemaBySedaPath;
    private final Map<String, SedaSchemaInfo> managementSedaSchemaBySedaPath;

    public SedaSchemaInfoResolver(AdminManagementClientFactory adminManagementClientFactory) throws CollectInternalException {
        List<SchemaResponse> allSchemaModels = SedaSchemaInfoResolver.loadUnitSchema(adminManagementClientFactory);
        List<SchemaResponse> sedaSchemaModels = SedaSchemaInfoResolver.skipSystemSchemaModels(allSchemaModels);
        SedaSchemaInfoResolver.hotfixSchemaModels(sedaSchemaModels);
        this.contentSchemaBySedaPath = SedaSchemaInfoResolver.getContentSchemaBySedaPath(sedaSchemaModels);
        this.managementSedaSchemaBySedaPath = SedaSchemaInfoResolver.getManagementSchemaBySedaPath(sedaSchemaModels);
    }

    @Deprecated
    private static void hotfixSchemaModels(List<SchemaResponse> schemaModels) {
        schemaModels.stream().filter(model -> model.getOrigin() == SchemaOrigin.INTERNAL && model.getType() == SchemaType.OBJECT).forEach(model -> {
            if (model.getApiPath().equals("#management")) {
                model.setSedaField("Management");
            } else if (model.getApiPath().startsWith("#management") && StringUtils.equalsAny((CharSequence)model.getApiField(), (CharSequence[])new CharSequence[]{"EndDate", "Rules", "Inheritance"})) {
                model.setSedaField(null);
            } else {
                model.setSedaField(model.getFieldName());
            }
        });
    }

    private static List<SchemaResponse> skipSystemSchemaModels(List<SchemaResponse> schemaModels) {
        return schemaModels.stream().filter(model -> !StringUtils.startsWith((CharSequence)model.getApiPath(), (CharSequence)"#") || StringUtils.startsWith((CharSequence)model.getApiPath(), (CharSequence)"#management")).filter(model -> !StringUtils.equalsAny((CharSequence)model.getApiField(), (CharSequence[])new CharSequence[]{"Title_", "Description_"})).filter(model -> !StringUtils.startsWith((CharSequence)model.getApiPath(), (CharSequence)"#management") || !"EndDate".equals(model.getApiField())).toList();
    }

    private static List<SchemaResponse> loadUnitSchema(AdminManagementClientFactory adminManagementClientFactory) throws CollectInternalException {
        List list;
        block8: {
            AdminManagementClient client = adminManagementClientFactory.getClient();
            try {
                list = ((RequestResponseOK)client.getUnitSchema()).getResults();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    throw new CollectInternalServerSideException("Cannot load unit schema", (Throwable)e);
                }
            }
            client.close();
        }
        return list;
    }

    private static Map<String, SedaSchemaInfo> getContentSchemaBySedaPath(List<SchemaResponse> contentSchemaModels) {
        List<SchemaResponse> sortedContentSchemaFields = contentSchemaModels.stream().filter(model -> !StringUtils.startsWith((CharSequence)model.getApiPath(), (CharSequence)"#management")).sorted(Comparator.comparing(schema -> schema.getOrigin() == SchemaOrigin.INTERNAL ? schema.getApiPath() : schema.getPath())).toList();
        HashMap<String, CallSite> apiPathToSedaPath = new HashMap<String, CallSite>();
        HashMap<Object, SedaSchemaInfo> sedaPathToSedaInfo = new HashMap<Object, SedaSchemaInfo>();
        for (SchemaResponse schema2 : sortedContentSchemaFields) {
            String sedaPath;
            String sedaField;
            boolean isObject = schema2.getType() == SchemaType.OBJECT;
            boolean isExternal = schema2.getOrigin() == SchemaOrigin.EXTERNAL;
            boolean isArray = isExternal || schema2.getCardinality() == SchemaCardinality.MANY || schema2.getCardinality() == SchemaCardinality.MANY_REQUIRED;
            String apiField = isExternal ? schema2.getFieldName() : schema2.getApiField();
            String apiPath = isExternal ? schema2.getPath() : schema2.getApiPath();
            String string = sedaField = isExternal ? schema2.getFieldName() : schema2.getSedaField();
            if (!apiPath.contains(".")) {
                sedaPath = "Content." + sedaField;
            } else {
                String parentApiPath = StringUtils.substringBeforeLast((String)apiPath, (String)".");
                sedaPath = (String)apiPathToSedaPath.get(parentApiPath) + "." + sedaField;
            }
            boolean isSedaExtensionPoint = isExternal ? isObject : CsvMetadataUtils.SEDA_EXTENSION_POINTS.contains(sedaPath);
            apiPathToSedaPath.put(apiPath, (CallSite)((Object)sedaPath));
            sedaPathToSedaInfo.put(sedaPath, new SedaSchemaInfo(sedaPath, apiPath, apiField, isObject, isArray, isExternal, isSedaExtensionPoint, false, SedaSchemaInfoResolver.isForbiddenCsvHeader(sedaPath)));
        }
        sedaPathToSedaInfo.put("Content", new SedaSchemaInfo("Content", null, null, true, false, false, true, false, false));
        return MapUtils.unmodifiableMap(sedaPathToSedaInfo);
    }

    private static boolean isForbiddenCsvHeader(String sedaPath) {
        return CsvMetadataUtils.FORBIDDEN_CONTENT_SEDA_PATHS.contains(sedaPath);
    }

    private static Map<String, SedaSchemaInfo> getManagementSchemaBySedaPath(List<SchemaResponse> allSchemaModels) {
        List<SchemaResponse> sortedManagementSchemaModels = allSchemaModels.stream().filter(model -> StringUtils.startsWith((CharSequence)model.getApiPath(), (CharSequence)"#management")).sorted(Comparator.comparing(SchemaResponse::getApiPath)).toList();
        HashMap<String, String> apiPathToSedaPath = new HashMap<String, String>();
        HashMap<String, SedaSchemaInfo> sedaPathToSedaInfo = new HashMap<String, SedaSchemaInfo>();
        for (SchemaResponse schema : sortedManagementSchemaModels) {
            String sedaPath;
            String apiSubPath;
            if (schema.getSedaField() == null) continue;
            if (!schema.getApiPath().contains(".")) {
                apiSubPath = schema.getApiPath();
                sedaPath = schema.getSedaField();
            } else {
                sedaPath = schema.getSedaField();
                String parentPath = schema.getApiPath();
                apiSubPath = null;
                do {
                    apiSubPath = CsvMetadataUtils.buildPath(StringUtils.substringAfterLast((String)parentPath, (String)"."), apiSubPath);
                } while (!apiPathToSedaPath.containsKey(parentPath = StringUtils.substringBeforeLast((String)parentPath, (String)".")));
                sedaPath = CsvMetadataUtils.buildPath((String)apiPathToSedaPath.get(parentPath), sedaPath);
            }
            apiPathToSedaPath.put(schema.getApiPath(), sedaPath);
            boolean isObject = schema.getType() == SchemaType.OBJECT;
            sedaPathToSedaInfo.put(sedaPath, new SedaSchemaInfo(sedaPath, schema.getApiPath(), apiSubPath, isObject, SedaSchemaInfoResolver.isArrayManagementField(schema, sedaPath), false, false, SedaSchemaInfoResolver.isSpecialRulePropertyArrayIndex(sedaPath), false));
        }
        SedaSchemaInfoResolver.addSpecialManagementLogbookField(sedaPathToSedaInfo);
        SedaSchemaInfoResolver.addSpecialArchiveUnitProfileField(sedaPathToSedaInfo);
        SedaSchemaInfoResolver.addSpecialManagementUpdateOperationFields(sedaPathToSedaInfo);
        return MapUtils.unmodifiableMap(sedaPathToSedaInfo);
    }

    private static void addSpecialManagementLogbookField(Map<String, SedaSchemaInfo> sedaPathToSedaInfo) {
        sedaPathToSedaInfo.put("Management.LogBook", new SedaSchemaInfo("Management.LogBook", null, null, true, false, false, false, false, true));
    }

    private static void addSpecialArchiveUnitProfileField(Map<String, SedaSchemaInfo> sedaPathToSedaInfo) {
        sedaPathToSedaInfo.put("ArchiveUnitProfile", new SedaSchemaInfo("ArchiveUnitProfile", "ArchiveUnitProfile", "ArchiveUnitProfile", false, false, false, false, false, false));
    }

    private static void addSpecialManagementUpdateOperationFields(Map<String, SedaSchemaInfo> sedaPathToSedaInfo) {
        sedaPathToSedaInfo.put("Management.UpdateOperation", new SedaSchemaInfo("Management.UpdateOperation", "#management.UpdateOperation", "UpdateOperation", true, false, false, false, false, false));
        sedaPathToSedaInfo.put("Management.UpdateOperation.SystemId", new SedaSchemaInfo("Management.UpdateOperation.SystemId", "#management.UpdateOperation.SystemId", "SystemId", false, false, false, false, false, false));
        sedaPathToSedaInfo.put("Management.UpdateOperation.ArchiveUnitIdentifierKey", new SedaSchemaInfo("Management.UpdateOperation.ArchiveUnitIdentifierKey", "#management.UpdateOperation.ArchiveUnitIdentifierKey", "ArchiveUnitIdentifierKey", true, false, false, false, false, false));
        sedaPathToSedaInfo.put("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName", new SedaSchemaInfo("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName", "#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName", "MetadataName", false, false, false, false, false, false));
        sedaPathToSedaInfo.put("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue", new SedaSchemaInfo("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue", "#management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue", "MetadataValue", false, false, false, false, false, false));
    }

    private static boolean isArrayManagementField(SchemaResponse schema, String sedaPath) {
        if (schema.getCardinality() == SchemaCardinality.MANY || schema.getCardinality() == SchemaCardinality.MANY_REQUIRED) {
            return true;
        }
        return CsvMetadataUtils.SEDA_MANAGEMENT_SPECIAL_ARRAY_FIELDS.contains(sedaPath);
    }

    private static boolean isSpecialRulePropertyArrayIndex(String sedaPath) {
        return CsvMetadataUtils.SEDA_MANAGEMENT_SPECIAL_RULE_PROPERTY_ARRAY_FIELDS.contains(sedaPath);
    }

    public SedaSchemaInfo getContentSchemaInfo(String sedaPath) {
        return this.contentSchemaBySedaPath.get(sedaPath);
    }

    @VisibleForTesting
    Collection<SedaSchemaInfo> getAllContentSchemaInfo() {
        return this.contentSchemaBySedaPath.values();
    }

    public SedaSchemaInfo getManagementModelBySedaPath(String sedaPath) {
        return this.managementSedaSchemaBySedaPath.get(sedaPath);
    }

    public List<SedaSchemaInfo> getChildContentSchemaInfo(String sedaPathPrefix) {
        return this.getChildSchemaInfo(sedaPathPrefix, this.contentSchemaBySedaPath);
    }

    public List<SedaSchemaInfo> getChildManagementSchemaInfo(String sedaPathPrefix) {
        return this.getChildSchemaInfo(sedaPathPrefix, this.managementSedaSchemaBySedaPath);
    }

    private List<SedaSchemaInfo> getChildSchemaInfo(String sedaPathPrefix, Map<String, SedaSchemaInfo> contentSchemaBySedaPath) {
        return contentSchemaBySedaPath.values().stream().filter(s -> {
            if (!s.sedaPath().startsWith(sedaPathPrefix + ".")) {
                return false;
            }
            String subSedaPath = StringUtils.removeStart((String)s.sedaPath(), (String)(sedaPathPrefix + "."));
            return !subSedaPath.contains(".");
        }).toList();
    }
}

