/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import fr.gouv.vitam.collect.internal.core.csv.CsvHeaderFieldNameIterable;
import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataValidator;
import fr.gouv.vitam.collect.internal.core.csv.FieldNameValidationUtils;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfo;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class CsvToJsonConverter {
    private final List<String> headerNames;
    private final Map<String, String> normalizedHeaderMap;

    public CsvToJsonConverter(SedaSchemaInfoResolver sedaSchemaInfoResolver, List<String> headerNames, boolean isFirstUpload) throws CollectInvalidCsvFormatException {
        this.headerNames = headerNames;
        CsvMetadataValidator csvMetadataValidator = new CsvMetadataValidator();
        csvMetadataValidator.validateHeaderNames(sedaSchemaInfoResolver, headerNames, isFirstUpload);
        Map<String, String> normalizedContentHeaderMap = CsvToJsonConverter.initializeContentHeaders(headerNames, sedaSchemaInfoResolver);
        Map<String, String> normalizedManagementHeaderMap = this.initializeManagementHeaders(headerNames, sedaSchemaInfoResolver);
        this.normalizedHeaderMap = CsvToJsonConverter.mergeMaps(normalizedContentHeaderMap, normalizedManagementHeaderMap);
    }

    private static Map<String, String> initializeContentHeaders(List<String> headerNames, SedaSchemaInfoResolver sedaSchemaInfoResolver) {
        return headerNames.stream().filter(CsvMetadataUtils::isContentField).filter(headerName -> !CsvMetadataUtils.isContentTitleField(headerName) && !CsvMetadataUtils.isContentDescriptionField(headerName)).collect(Collectors.toMap(headerName -> headerName, headerName -> CsvToJsonConverter.normalizeContentHeaderName(sedaSchemaInfoResolver, headerName)));
    }

    private static String normalizeContentHeaderName(SedaSchemaInfoResolver sedaSchemaInfoResolver, String headerName) {
        Object normalizedHeaderName = null;
        for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
            if (fieldEntry.simpleSedaPath().equals("Content.Signature.ReferencedObject.SignedObjectDigest") && !fieldEntry.isDeclaredAsObject()) {
                return CsvMetadataUtils.buildPath(normalizedHeaderName, "SignedObjectDigest.MessageDigest");
            }
            if (fieldEntry.simpleSedaPath().equals("Content.Signature.ReferencedObject.SignedObjectDigest.attr")) {
                return CsvMetadataUtils.buildPath(normalizedHeaderName, "Algorithm");
            }
            SedaSchemaInfo schemaInfo = sedaSchemaInfoResolver.getContentSchemaInfo(fieldEntry.simpleSedaPath());
            normalizedHeaderName = schemaInfo == null ? CsvMetadataUtils.buildPath(normalizedHeaderName, fieldEntry.sedaFieldName()) : CsvMetadataUtils.buildPath(normalizedHeaderName, schemaInfo.apiSubPath());
            boolean isArray = schemaInfo == null || schemaInfo.isArray();
            if (!isArray) continue;
            int arrayIndex = 0;
            if (fieldEntry.isDeclaredAsArray()) {
                arrayIndex = fieldEntry.arrayIndex();
            }
            normalizedHeaderName = (String)normalizedHeaderName + "[" + arrayIndex + "]";
        }
        return normalizedHeaderName;
    }

    private Map<String, String> initializeManagementHeaders(List<String> headerNames, SedaSchemaInfoResolver sedaSchemaInfoResolver) {
        return headerNames.stream().filter(CsvMetadataUtils::isManagementField).collect(Collectors.toMap(headerName -> headerName, headerName -> this.normalizeManagementHeaderName(sedaSchemaInfoResolver, (String)headerName)));
    }

    private String normalizeManagementHeaderName(SedaSchemaInfoResolver sedaSchemaInfoResolver, String headerName) {
        Object normalizedHeaderName = null;
        for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
            SedaSchemaInfo schemaInfo = sedaSchemaInfoResolver.getManagementModelBySedaPath(fieldEntry.simpleSedaPath());
            if (schemaInfo == null) {
                throw new IllegalStateException("Unexpected management seda header name '" + headerName + "'");
            }
            if (schemaInfo.isArray()) {
                int arrayIndex = 0;
                if (fieldEntry.isDeclaredAsArray()) {
                    arrayIndex = fieldEntry.arrayIndex();
                }
                if (schemaInfo.apiSubPath().startsWith("Rules.")) {
                    normalizedHeaderName = CsvMetadataUtils.buildPath((String)normalizedHeaderName, "Rules");
                    normalizedHeaderName = (String)normalizedHeaderName + "[" + arrayIndex + "]";
                    normalizedHeaderName = CsvMetadataUtils.buildPath((String)normalizedHeaderName, StringUtils.removeStart((String)schemaInfo.apiSubPath(), (String)"Rules."));
                    continue;
                }
                normalizedHeaderName = CsvMetadataUtils.buildPath((String)normalizedHeaderName, schemaInfo.apiSubPath());
                normalizedHeaderName = (String)normalizedHeaderName + "[" + arrayIndex + "]";
                continue;
            }
            normalizedHeaderName = CsvMetadataUtils.buildPath(normalizedHeaderName, schemaInfo.apiSubPath());
        }
        return normalizedHeaderName;
    }

    private static ImmutableMap<String, String> mergeMaps(Map<String, String> map1, Map<String, String> map2) {
        return ImmutableMap.builder().putAll(map1).putAll(map2).build();
    }

    public ObjectNode convertCsvRecordToJson(CSVRecord record, boolean isTopLevelFolder, boolean explicitAttachementMode) throws CollectInvalidCsvFormatException {
        ObjectNode unitContent;
        this.validateUpdateOperationFields(record, isTopLevelFolder, explicitAttachementMode);
        TreeMap<String, String> flatFieldValueMap = new TreeMap<String, String>();
        List<String> mainHeaderNames = this.headerNames.stream().filter(headerName -> CsvMetadataUtils.isManagementField(headerName) || CsvMetadataUtils.isContentField(headerName)).filter(headerName -> !CsvMetadataUtils.isContentTitleField(headerName) && !CsvMetadataUtils.isContentDescriptionField(headerName)).filter(headerName -> StringUtils.isNotEmpty((CharSequence)record.get(headerName))).toList();
        for (String headerName2 : mainHeaderNames) {
            String flatFieldName = this.normalizedHeaderMap.get(headerName2);
            String fieldValue = record.get(headerName2);
            if (CsvMetadataUtils.matchesPattern(headerName2, CsvMetadataUtils.CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_ATTR_PATTERN)) {
                fieldValue = CsvToJsonConverter.validateAndFixSignatureReferencedObjectSignedObjectDigestAlgorithm(headerName2, fieldValue);
            }
            flatFieldValueMap.put(flatFieldName, fieldValue);
        }
        flatFieldValueMap.putAll(this.mapMultiLangAttrHeaders(record, "Content.Title", "Title", "Title_"));
        flatFieldValueMap.putAll(this.mapMultiLangAttrHeaders(record, "Content.Description", "Description", "Description_"));
        this.checkSparseHeaders(flatFieldValueMap);
        String jsonStr = JsonUnflattener.unflatten(flatFieldValueMap);
        try {
            unitContent = (ObjectNode)JsonHandler.getFromString((String)jsonStr);
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("An error occurred during Csv metadata mapping", e);
        }
        return unitContent;
    }

    public void validateUpdateOperationFields(CSVRecord record, boolean isTopLevelFolder, boolean explicitAttachementMode) throws CollectInvalidCsvFormatException {
        List<String> updateOperationHeaders = this.headerNames.stream().filter(CsvMetadataUtils::isManagementUpdateOperationField).filter(headerName -> StringUtils.isNotEmpty((CharSequence)record.get(headerName))).toList();
        if (updateOperationHeaders.isEmpty()) {
            return;
        }
        if (explicitAttachementMode) {
            throw new CollectInvalidCsvFormatException("Cannot set 'Management.UpdateOperation.*' CSV headers when explicit HTTP header 'X-Attachement-Id' is set");
        }
        if (!isTopLevelFolder) {
            throw new CollectInvalidCsvFormatException("Only top-level (root) units can have 'Management.UpdateOperation.*' headers.");
        }
        this.validateUpdateOperationFields(updateOperationHeaders);
        this.checkIncompatibleFieldsWithUpdateOperationFields(record);
    }

    private void validateUpdateOperationFields(List<String> updateOperationHeaders) throws CollectInvalidCsvFormatException {
        boolean hasSystemId = updateOperationHeaders.contains("Management.UpdateOperation.SystemId");
        boolean hasMetadataName = updateOperationHeaders.contains("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName");
        boolean hasMetadataValue = updateOperationHeaders.contains("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue");
        if (hasSystemId && hasMetadataName) {
            throw new CollectInvalidCsvFormatException("Both '%s' and '%s' headers are set".formatted("Management.UpdateOperation.SystemId", "Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName"));
        }
        if (hasSystemId && hasMetadataValue) {
            throw new CollectInvalidCsvFormatException("Both '%s' and '%s' headers are set".formatted("Management.UpdateOperation.SystemId", "Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue"));
        }
        if (hasMetadataName && !hasMetadataValue || !hasMetadataName && hasMetadataValue) {
            throw new CollectInvalidCsvFormatException("Headers '%s' and '%s' must be set together".formatted("Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataName", "Management.UpdateOperation.ArchiveUnitIdentifierKey.MetadataValue"));
        }
    }

    private void checkIncompatibleFieldsWithUpdateOperationFields(CSVRecord record) throws CollectInvalidCsvFormatException {
        Optional<String> anyOtherIncompatibleMetadataHeaderName = this.headerNames.stream().filter(headerName -> CsvMetadataUtils.isManagementField(headerName) || CsvMetadataUtils.isContentField(headerName)).filter(headerName -> !CsvMetadataUtils.isManagementUpdateOperationField(headerName)).filter(headerName -> !CsvMetadataUtils.isContentTitleField(headerName) && !"Content.DescriptionLevel".equals(headerName)).filter(headerName -> StringUtils.isNotEmpty((CharSequence)record.get(headerName))).findFirst();
        if (anyOtherIncompatibleMetadataHeaderName.isPresent()) {
            throw new CollectInvalidCsvFormatException("Cannot set other metadata header '" + anyOtherIncompatibleMetadataHeaderName.get() + "' when a 'Management.UpdateOperation.*' header is defined.");
        }
    }

    private static String validateAndFixSignatureReferencedObjectSignedObjectDigestAlgorithm(String headerName, String fieldValue) throws CollectInvalidCsvFormatException {
        Matcher matcher = CsvMetadataUtils.ALGORITHM_ATTR_VALUE_PATTERN.matcher(fieldValue);
        if (!matcher.find()) {
            throw new CollectInvalidCsvFormatException("Invalid algorithm attribute for header '" + headerName + "'");
        }
        fieldValue = matcher.group(1);
        return fieldValue;
    }

    private void checkSparseHeaders(SortedMap<String, String> flatFieldValueMap) throws CollectInvalidCsvFormatException {
        HashSetValuedHashMap flatFieldArrayIndexes = new HashSetValuedHashMap();
        for (String flatFieldName : flatFieldValueMap.keySet()) {
            int arrayStartSeparatorIndex = -1;
            while ((arrayStartSeparatorIndex = flatFieldName.indexOf(91, arrayStartSeparatorIndex + 1)) != -1) {
                int arrayEndSeparatorIndex = flatFieldName.indexOf(93, arrayStartSeparatorIndex + 1);
                String flatArrayFieldName = flatFieldName.substring(0, arrayStartSeparatorIndex);
                Integer arrayIndex = Integer.parseInt(flatFieldName.substring(arrayStartSeparatorIndex + 1, arrayEndSeparatorIndex));
                flatFieldArrayIndexes.put((Object)flatArrayFieldName, (Object)arrayIndex);
            }
        }
        for (String flatFieldName : flatFieldArrayIndexes.keySet()) {
            Set arrayIndexes = flatFieldArrayIndexes.get((Object)flatFieldName);
            for (int i = 0; i < arrayIndexes.size(); ++i) {
                if (arrayIndexes.contains(i)) continue;
                throw new CollectInvalidCsvFormatException("Missing value for " + flatFieldName.replaceAll("\\[", ".").replaceAll("]", "") + "." + i);
            }
        }
    }

    private Map<String, String> mapMultiLangAttrHeaders(CSVRecord record, String sedaFieldName, String singleValueApiFieldName, String multiValueApiFieldName) throws CollectInvalidCsvFormatException {
        String value;
        List<String> fieldHeaderNames = this.headerNames.stream().filter(headerName -> CsvMetadataUtils.equalsOrStartsWith(headerName, sedaFieldName)).filter(headerName -> !record.get(headerName).isEmpty()).toList();
        HashMap<Integer, String> valueByIndex = new HashMap<Integer, String>();
        HashMap<Integer, String> langAttrByIndex = new HashMap<Integer, String>();
        for (String fieldHeaderName : fieldHeaderNames) {
            value = record.get(fieldHeaderName);
            Integer arrayIndex = CsvToJsonConverter.getMultiLangHeaderArrayIndex(fieldHeaderName, sedaFieldName);
            if (fieldHeaderName.endsWith(".attr")) {
                Matcher matcher = CsvMetadataUtils.LANG_ATTR_VALUE_PATTERN.matcher(value);
                if (!matcher.find()) {
                    throw new CollectInvalidCsvFormatException("Invalid xml:lang attribute for header '" + fieldHeaderName + "'");
                }
                String lang = matcher.group(1);
                langAttrByIndex.put(arrayIndex, lang);
                continue;
            }
            valueByIndex.put(arrayIndex, value);
        }
        for (int arrayIndex = 0; arrayIndex < valueByIndex.size(); ++arrayIndex) {
            if (valueByIndex.containsKey(arrayIndex)) continue;
            throw new CollectInvalidCsvFormatException("Missing value for '" + sedaFieldName + "." + arrayIndex + "'");
        }
        for (Integer arrayIndex : langAttrByIndex.keySet()) {
            if (valueByIndex.containsKey(arrayIndex)) continue;
            throw new CollectInvalidCsvFormatException("Missing value for " + sedaFieldName + "." + arrayIndex + " header");
        }
        HashMap<String, String> flatFieldValueMap = new HashMap<String, String>();
        for (int arrayIndex = 0; arrayIndex < valueByIndex.size(); ++arrayIndex) {
            value = (String)valueByIndex.get(arrayIndex);
            if (langAttrByIndex.containsKey(arrayIndex)) {
                String lang = (String)langAttrByIndex.get(arrayIndex);
                try {
                    FieldNameValidationUtils.validateRegularVitamFieldName(lang);
                }
                catch (IllegalArgumentException e) {
                    throw new CollectInvalidCsvFormatException("Invalid lang value '" + StringEscapeUtils.escapeJava((String)StringUtils.abbreviate((String)lang, (int)100)) + "' for '" + sedaFieldName + ".*': " + e.getMessage());
                }
                String fieldName = multiValueApiFieldName + "." + lang;
                if (flatFieldValueMap.containsKey(fieldName)) {
                    throw new CollectInvalidCsvFormatException("Multiple values for '" + sedaFieldName + "' header with same lang attribute '" + lang + "'");
                }
                flatFieldValueMap.put(fieldName, value);
                continue;
            }
            if (flatFieldValueMap.containsKey(singleValueApiFieldName)) {
                throw new CollectInvalidCsvFormatException("Multiple values for '" + sedaFieldName + "' header");
            }
            flatFieldValueMap.put(singleValueApiFieldName, value);
        }
        return flatFieldValueMap;
    }

    private static Integer getMultiLangHeaderArrayIndex(String fieldHeaderName, String sedaFieldName) {
        String baseHeaderName = StringUtils.substringBeforeLast((String)fieldHeaderName, (String)".attr");
        if (baseHeaderName.equals(sedaFieldName)) {
            return 0;
        }
        String arrayIndexStr = StringUtils.substringAfter((String)baseHeaderName, (String)(sedaFieldName + "."));
        return Integer.parseInt(arrayIndexStr);
    }

    @VisibleForTesting
    Map<String, String> getNormalizedHeaderMap() {
        return this.normalizedHeaderMap;
    }
}

