/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.csv.CsvHeaderFieldNameIterable;
import fr.gouv.vitam.collect.internal.core.csv.CsvHeaderValidationManager;
import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import fr.gouv.vitam.collect.internal.core.csv.FieldNameValidationUtils;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfo;
import fr.gouv.vitam.collect.internal.core.csv.SedaSchemaInfoResolver;
import fr.gouv.vitam.collect.internal.core.exceptions.CollectInvalidCsvFormatException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;

public class CsvMetadataValidator {
    private static final int MAX_HEADER_NAMES = 10000;
    private static final int MIN_HEADER_COUNT = 2;
    private static final int MAX_ARRAY_INDEX_LENGTH = 4;

    public void validateHeaderNames(SedaSchemaInfoResolver sedaSchemaInfoResolver, List<String> headerNames, boolean isFirstUpload) throws CollectInvalidCsvFormatException {
        this.checkTooManyHeaderNames(headerNames);
        this.checkDuplicateHeaderNames(headerNames);
        this.checkRequiredHeaderNames(headerNames);
        try (CsvHeaderValidationManager csvHeaderValidationManager = new CsvHeaderValidationManager(headerNames);){
            this.commonHeaderNameChecks(csvHeaderValidationManager);
            this.validateContentHeaderNames(sedaSchemaInfoResolver, csvHeaderValidationManager);
            this.validateManagementHeaderNames(sedaSchemaInfoResolver, csvHeaderValidationManager, isFirstUpload);
        }
    }

    private void checkTooManyHeaderNames(List<String> headerNames) throws CollectInvalidCsvFormatException {
        if (headerNames.size() > 10000) {
            throw new CollectInvalidCsvFormatException("Invalid header names. Too many header names " + headerNames.size() + " (max = 10000)");
        }
    }

    private void checkDuplicateHeaderNames(Collection<String> headerNames) throws CollectInvalidCsvFormatException {
        HashSet<String> headerNameSet = new HashSet<String>();
        for (String headerName : headerNames) {
            if (headerNameSet.add(headerName)) continue;
            throw new CollectInvalidCsvFormatException("Invalid header names. Duplicate header name '" + headerName + "'");
        }
    }

    private void checkRequiredHeaderNames(List<String> headerNames) throws CollectInvalidCsvFormatException {
        if (!headerNames.contains("File")) {
            throw new CollectInvalidCsvFormatException("Invalid header names. Missing required 'File' header name");
        }
        if (headerNames.size() < 2) {
            throw new CollectInvalidCsvFormatException("Invalid header names. No header to set");
        }
    }

    private void commonHeaderNameChecks(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        CsvMetadataValidator.checkHeaderNameTooLong(csvHeaderValidationManager);
        CsvMetadataValidator.checkHeaderNameCategory(csvHeaderValidationManager);
        this.headerNameSanityChecks(csvHeaderValidationManager);
        this.checkAttributeHeaderNames(csvHeaderValidationManager);
        this.checkInvalidArraysOfArrays(csvHeaderValidationManager);
        this.checkHeaderImplicitAndExplicitArrayIndexMix(csvHeaderValidationManager);
    }

    private static void checkHeaderNameTooLong(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            if (headerName.length() <= 255) continue;
            csvHeaderValidationManager.report(headerName, "Header name is too long");
        }
    }

    private static void checkHeaderNameCategory(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            if (CsvMetadataUtils.isContentField(headerName) || CsvMetadataUtils.isManagementField(headerName) || CsvMetadataUtils.isFileField(headerName) || CsvMetadataUtils.IsObjectFilesField(headerName)) continue;
            csvHeaderValidationManager.report(headerName, "Only accepted names are 'File', 'ObjectFiles', 'Content.*', 'Management.*' or 'ArchiveUnitProfile'");
        }
    }

    private void headerNameSanityChecks(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            CsvMetadataValidator.headerNameSanityChecks(csvHeaderValidationManager, headerName);
        }
    }

    private static void headerNameSanityChecks(CsvHeaderValidationManager csvHeaderValidationManager, String headerName) throws CollectInvalidCsvFormatException {
        String[] fieldNames;
        for (String fieldName : fieldNames = StringUtils.splitPreserveAllTokens((String)headerName, (char)'.')) {
            if (CsvMetadataUtils.matchesPattern(fieldName, CsvMetadataUtils.ARRAY_INDEX_PATTERN)) {
                if (fieldName.length() <= 4) continue;
                csvHeaderValidationManager.report(headerName, "Array index '" + fieldName + "' too large");
                return;
            }
            try {
                FieldNameValidationUtils.validateRegularVitamFieldName(fieldName);
            }
            catch (IllegalArgumentException e) {
                csvHeaderValidationManager.report(headerName, e.getMessage());
                return;
            }
        }
    }

    private void checkAttributeHeaderNames(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            if (!headerName.contains(".attr.")) continue;
            csvHeaderValidationManager.report(headerName, "Reserved 'attr' keyword can only be used as a suffix");
        }
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            String baseHeaderName;
            if (!headerName.endsWith(".attr") || csvHeaderValidationManager.containsHeaderName(baseHeaderName = StringUtils.removeEnd((String)headerName, (String)".attr"))) continue;
            csvHeaderValidationManager.report(headerName, "Missing base header name '" + baseHeaderName + "'");
        }
    }

    private void checkHeaderImplicitAndExplicitArrayIndexMix(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        HashSet<String> fieldsWithArrayIndexes = new HashSet<String>();
        HashSet<String> fieldsWithoutArrayIndexes = new HashSet<String>();
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
                if (fieldEntry.isDeclaredAsArray()) {
                    fieldsWithArrayIndexes.add(fieldEntry.fullSedaPathWithoutLastArrayIndex());
                    continue;
                }
                fieldsWithoutArrayIndexes.add(fieldEntry.fullSedaPathWithoutLastArrayIndex());
            }
        }
        for (String fieldName : fieldsWithoutArrayIndexes) {
            if (!fieldsWithArrayIndexes.contains(fieldName)) continue;
            for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidateByPrefix(fieldName)) {
                csvHeaderValidationManager.report(headerName, "Invalid header names. Cannot mix implicit array and array index syntaxes for field '" + fieldName + "'");
            }
        }
    }

    private void checkInvalidArraysOfArrays(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate()) {
            CsvMetadataValidator.checkInvalidArraysOfArrays(csvHeaderValidationManager, headerName);
        }
    }

    private static void checkInvalidArraysOfArrays(CsvHeaderValidationManager csvHeaderValidationManager, String headerName) throws CollectInvalidCsvFormatException {
        for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
            if (!CsvMetadataUtils.matchesPattern(fieldEntry.sedaFieldName(), CsvMetadataUtils.ARRAY_INDEX_PATTERN)) continue;
            csvHeaderValidationManager.report(headerName, "Invalid array declaration at '" + fieldEntry.parentFullSedaPath() + "'");
            return;
        }
    }

    private void validateContentHeaderNames(SedaSchemaInfoResolver sedaSchemaInfoResolver, CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        this.preventUsingApiFieldNameAsSedaPath(sedaSchemaInfoResolver, csvHeaderValidationManager);
        this.checkSparseContentArraysHeaderNames(csvHeaderValidationManager);
        this.validateSpecialContentTitleHeaderNames(csvHeaderValidationManager);
        this.validateSpecialContentDescriptionHeaderNames(csvHeaderValidationManager);
        this.validateRegularContentHeaderNames(sedaSchemaInfoResolver, csvHeaderValidationManager);
    }

    private void preventUsingApiFieldNameAsSedaPath(SedaSchemaInfoResolver sedaSchemaInfoResolver, CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        HashMap<Object, String> reservedSedaPaths = new HashMap<Object, String>();
        reservedSedaPaths.put("Content.Title_", "Content.Title");
        reservedSedaPaths.put("Content.Description_", "Content.Description");
        reservedSedaPaths.put("Content.Signature.ReferencedObject.SignedObjectDigest.MessageDigest", "Content.Signature.ReferencedObject.SignedObjectDigest");
        reservedSedaPaths.put("Content.Signature.ReferencedObject.SignedObjectDigest.Algorithm", "Content.Signature.ReferencedObject.SignedObjectDigest.attr");
        for (SedaSchemaInfo schemaInfo : sedaSchemaInfoResolver.getAllContentSchemaInfo()) {
            String contentApiPath = "Content." + schemaInfo.apiPath();
            if (contentApiPath.equals(schemaInfo.sedaPath())) continue;
            reservedSedaPaths.put(contentApiPath, schemaInfo.sedaPath());
        }
        for (String headerName : csvHeaderValidationManager.getRemainingContentHeaderNamesToValidate()) {
            String sedaPath = headerName.replaceAll("\\.\\d+$", "").replaceAll("\\.\\d+\\.", ".");
            Optional<Map.Entry> reservedPathEntry = reservedSedaPaths.entrySet().stream().filter(reservedPath -> CsvMetadataUtils.equalsOrStartsWith(sedaPath, (String)reservedPath.getKey())).findFirst();
            if (!reservedPathEntry.isPresent()) continue;
            csvHeaderValidationManager.report(headerName, "Header must be Seda path '" + (String)reservedPathEntry.get().getValue() + "' instead of Vitam field name '" + (String)reservedPathEntry.get().getKey() + "'");
        }
    }

    private void checkSparseContentArraysHeaderNames(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        HashSetValuedHashMap sedaPathWithArrayIndexes = new HashSetValuedHashMap();
        for (String headerName : csvHeaderValidationManager.getRemainingContentHeaderNamesToValidate()) {
            for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
                if (!fieldEntry.isDeclaredAsArray()) continue;
                sedaPathWithArrayIndexes.put((Object)fieldEntry.fullSedaPathWithoutLastArrayIndex(), (Object)fieldEntry.arrayIndex());
            }
        }
        this.checkNoMissingArrayIndexes((HashSetValuedHashMap<String, Integer>)sedaPathWithArrayIndexes, csvHeaderValidationManager);
    }

    private void checkNoMissingArrayIndexes(HashSetValuedHashMap<String, Integer> sedaPathWithArrayIndexes, CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        block0: for (String sedaPath : sedaPathWithArrayIndexes.keySet()) {
            Set arrayIndexes = sedaPathWithArrayIndexes.get((Object)sedaPath);
            for (int i = 0; i < arrayIndexes.size(); ++i) {
                if (arrayIndexes.contains(i)) continue;
                int finalI = i;
                int nextHeaderIndex = arrayIndexes.stream().mapToInt(index -> index).filter(index -> index > finalI).min().orElseThrow();
                String unexpectedHeaderNamePrefix = CsvMetadataUtils.buildPath(sedaPath, String.valueOf(nextHeaderIndex));
                for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidateByPrefix(unexpectedHeaderNamePrefix)) {
                    csvHeaderValidationManager.report(headerName, "Expected header name '" + CsvMetadataUtils.buildPath(sedaPath, String.valueOf(i)) + "' since header '" + unexpectedHeaderNamePrefix + "' is declared");
                }
                continue block0;
            }
        }
    }

    private void validateSpecialContentTitleHeaderNames(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate(CsvMetadataUtils::isContentTitleField)) {
            if (CsvMetadataUtils.matchesPattern(headerName, CsvMetadataUtils.CONTENT_TITLE_VALID_HEADER_NAME_PATTERN)) continue;
            csvHeaderValidationManager.report(headerName, "Valid Content.Title[.*] or Content.Title[.*].attr expected");
        }
    }

    private void validateSpecialContentDescriptionHeaderNames(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingHeaderNamesToValidate(CsvMetadataUtils::isContentDescriptionField)) {
            if (CsvMetadataUtils.matchesPattern(headerName, CsvMetadataUtils.CONTENT_DESCRIPTION_VALID_HEADER_NAME_PATTERN)) continue;
            csvHeaderValidationManager.report(headerName, "Valid Content.Description[.*] or Content.Description[.*].attr expected");
        }
    }

    private void validateRegularContentHeaderNames(SedaSchemaInfoResolver sedaSchemaInfoResolver, CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        this.preventAttributeInRegularHeaderName(csvHeaderValidationManager);
        HashMap<String, SedaSchemaInfo> extraExternalSchemaFields = new HashMap<String, SedaSchemaInfo>();
        block0: for (String headerName : csvHeaderValidationManager.getRemainingMainContentHeaderNamesToValidate()) {
            SedaSchemaInfo parentSchemaInfo = null;
            for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
                String parentSedaPath = parentSchemaInfo == null ? null : parentSchemaInfo.sedaPath();
                String currentSedaPath = CsvMetadataUtils.buildPath(parentSedaPath, fieldEntry.sedaFieldName());
                SedaSchemaInfo schemaInfo = sedaSchemaInfoResolver.getContentSchemaInfo(currentSedaPath = CsvMetadataValidator.patchSpecialSignedObjectDigestPath(currentSedaPath, fieldEntry.isDeclaredAsObject()));
                if (schemaInfo == null) {
                    if (parentSchemaInfo != null) {
                        if (!parentSchemaInfo.isObject()) {
                            csvHeaderValidationManager.report(headerName, "Value field '" + parentSedaPath + "' cannot have a sub-field '" + fieldEntry.sedaFieldName() + "'");
                            continue block0;
                        }
                        if (!parentSchemaInfo.isSedaExtensionPoint()) {
                            List<String> availableSedaFields = sedaSchemaInfoResolver.getChildContentSchemaInfo(parentSedaPath).stream().filter(s -> !s.isForbiddenCsvHeader()).map(s -> StringUtils.removeStart((String)s.sedaPath(), (String)(parentSedaPath + "."))).sorted().toList();
                            csvHeaderValidationManager.report(headerName, "Invalid seda extension point '" + parentSedaPath + "'. Invalid field '" + fieldEntry.sedaFieldName() + "'. Available fields: " + availableSedaFields.stream().collect(Collectors.joining(", ", "[", "]")));
                            continue block0;
                        }
                    }
                    if (!extraExternalSchemaFields.containsKey(currentSedaPath)) {
                        String apiPath = parentSchemaInfo != null ? CsvMetadataUtils.buildPath(parentSchemaInfo.apiPath(), fieldEntry.sedaFieldName()) : fieldEntry.sedaFieldName();
                        extraExternalSchemaFields.put(currentSedaPath, new SedaSchemaInfo(currentSedaPath, apiPath, fieldEntry.sedaFieldName(), fieldEntry.isDeclaredAsObject(), true, true, true, false, false));
                    }
                    schemaInfo = (SedaSchemaInfo)extraExternalSchemaFields.get(currentSedaPath);
                }
                if (schemaInfo.isForbiddenCsvHeader()) {
                    csvHeaderValidationManager.report(headerName, "Seda Field '" + fieldEntry.simpleSedaPath() + "' is reserved / forbidden.");
                    continue block0;
                }
                if (fieldEntry.isDeclaredAsArray() && !schemaInfo.isArray()) {
                    csvHeaderValidationManager.report(headerName, "Field '" + currentSedaPath + "' is not an array");
                    continue block0;
                }
                if (fieldEntry.isDeclaredAsObject() && !schemaInfo.isObject()) {
                    csvHeaderValidationManager.report(headerName, "Field '" + currentSedaPath + "' is not an object.");
                    continue block0;
                }
                if (!fieldEntry.isDeclaredAsObject() && schemaInfo.isObject()) {
                    csvHeaderValidationManager.report(headerName, "Field '" + currentSedaPath + "' is an object.");
                    continue block0;
                }
                parentSchemaInfo = schemaInfo;
            }
        }
    }

    private void preventAttributeInRegularHeaderName(CsvHeaderValidationManager csvHeaderValidationManager) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingMainContentHeaderNamesToValidate()) {
            if (headerName.contains(".attr.")) {
                csvHeaderValidationManager.report(headerName, "Reserved 'attr' suffix");
                break;
            }
            if (!headerName.endsWith(".attr")) continue;
            if (CsvMetadataUtils.matchesPattern(headerName, CsvMetadataUtils.CONTENT_SIGNATURE_REFERENCED_OBJECT_SIGNED_OBJECT_DIGEST_ATTR_PATTERN)) break;
            csvHeaderValidationManager.report(headerName, "Reserved 'attr' suffix");
            break;
        }
    }

    private static String patchSpecialSignedObjectDigestPath(String currentSedaPath, boolean isDeclaredAsObject) {
        if (currentSedaPath.equals("Content.Signature.ReferencedObject.SignedObjectDigest") && !isDeclaredAsObject) {
            currentSedaPath = "Content.Signature.ReferencedObject.SignedObjectDigest.MessageDigest";
        }
        if (currentSedaPath.equals("Content.Signature.ReferencedObject.SignedObjectDigest.attr")) {
            currentSedaPath = "Content.Signature.ReferencedObject.SignedObjectDigest.Algorithm";
        }
        return currentSedaPath;
    }

    private void validateManagementHeaderNames(SedaSchemaInfoResolver sedaSchemaInfoResolver, CsvHeaderValidationManager csvHeaderValidationManager, boolean isFirstUpload) throws CollectInvalidCsvFormatException {
        CsvMetadataValidator.validateManagementHeaderNamesAgainstSedaModel(csvHeaderValidationManager, sedaSchemaInfoResolver);
        this.checkManagementHeaderArrayIndexes(csvHeaderValidationManager, sedaSchemaInfoResolver);
        this.preventUpdateOperationHeadersUsageOnUpdateMode(csvHeaderValidationManager, isFirstUpload);
    }

    private static void validateManagementHeaderNamesAgainstSedaModel(CsvHeaderValidationManager csvHeaderValidationManager, SedaSchemaInfoResolver sedaSchemaInfoResolver) throws CollectInvalidCsvFormatException {
        for (String headerName : csvHeaderValidationManager.getRemainingManagementHeaderNamesToValidate()) {
            CsvMetadataValidator.validateManagementHeaderNamesAgainstSedaModel(csvHeaderValidationManager, sedaSchemaInfoResolver, headerName);
        }
    }

    private void preventUpdateOperationHeadersUsageOnUpdateMode(CsvHeaderValidationManager csvHeaderValidationManager, boolean isFirstUpload) throws CollectInvalidCsvFormatException {
        if (isFirstUpload) {
            return;
        }
        Iterable<String> updateOperationHeaderNames = csvHeaderValidationManager.getRemainingHeaderNamesToValidate(CsvMetadataUtils::isManagementUpdateOperationField);
        for (String headerName : updateOperationHeaderNames) {
            csvHeaderValidationManager.report(headerName, "Declaring Management.UpdateOperation.* headers is not supported in update APIs.");
        }
    }

    private static void validateManagementHeaderNamesAgainstSedaModel(CsvHeaderValidationManager csvHeaderValidationManager, SedaSchemaInfoResolver sedaSchemaInfoResolver, String headerName) throws CollectInvalidCsvFormatException {
        for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
            SedaSchemaInfo sedaManagementModel = sedaSchemaInfoResolver.getManagementModelBySedaPath(fieldEntry.simpleSedaPath());
            if (sedaManagementModel == null) {
                List<String> availableSedaFields = sedaSchemaInfoResolver.getChildManagementSchemaInfo(fieldEntry.parentSimpleSedaPath()).stream().filter(s -> !s.isForbiddenCsvHeader()).map(s -> StringUtils.removeStart((String)s.sedaPath(), (String)(fieldEntry.parentSimpleSedaPath() + "."))).sorted().toList();
                csvHeaderValidationManager.report(headerName, "Invalid seda extension point '" + fieldEntry.parentFullSedaPath() + "'. Invalid field '" + fieldEntry.sedaFieldName() + "'. Available fields: " + availableSedaFields.stream().collect(Collectors.joining(", ", "[", "]")));
                return;
            }
            if (sedaManagementModel.isForbiddenCsvHeader()) {
                csvHeaderValidationManager.report(headerName, "Seda Field '" + fieldEntry.simpleSedaPath() + "' is reserved / forbidden.");
                return;
            }
            if (fieldEntry.isDeclaredAsArray() && !sedaManagementModel.isArray()) {
                csvHeaderValidationManager.report(headerName, "Field '" + fieldEntry.simpleSedaPath() + "' is not an array");
                return;
            }
            if (fieldEntry.isDeclaredAsObject() && !sedaManagementModel.isObject()) {
                csvHeaderValidationManager.report(headerName, "Field '" + fieldEntry.simpleSedaPath() + "' is not an object.");
                return;
            }
            if (fieldEntry.isDeclaredAsObject() || !sedaManagementModel.isObject()) continue;
            csvHeaderValidationManager.report(headerName, "Field '" + fieldEntry.simpleSedaPath() + "' is an object.");
            return;
        }
    }

    private void checkManagementHeaderArrayIndexes(CsvHeaderValidationManager csvHeaderValidationManager, SedaSchemaInfoResolver sedaSchemaInfoResolver) throws CollectInvalidCsvFormatException {
        this.checkSparseManagementArraysHeaderNames(csvHeaderValidationManager, sedaSchemaInfoResolver);
        this.checkRulePropertiesWithIndexRelativeToRuleId(csvHeaderValidationManager, sedaSchemaInfoResolver);
    }

    private void checkSparseManagementArraysHeaderNames(CsvHeaderValidationManager csvHeaderValidationManager, SedaSchemaInfoResolver sedaSchemaInfoResolver) throws CollectInvalidCsvFormatException {
        HashSetValuedHashMap fieldsWithArrayIndexes = new HashSetValuedHashMap();
        for (String headerName : csvHeaderValidationManager.getRemainingManagementHeaderNamesToValidate()) {
            for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
                SedaSchemaInfo sedaManagementModel = sedaSchemaInfoResolver.getManagementModelBySedaPath(fieldEntry.simpleSedaPath());
                if (sedaManagementModel == null) {
                    throw new IllegalStateException("Expected valid seda path '" + fieldEntry.simpleSedaPath() + "'");
                }
                if (!fieldEntry.isDeclaredAsArray() || sedaManagementModel.isSpecialRulePropertyArrayIndex()) continue;
                fieldsWithArrayIndexes.put((Object)CsvMetadataUtils.buildPath(fieldEntry.parentFullSedaPath(), fieldEntry.sedaFieldName()), (Object)fieldEntry.arrayIndex());
            }
        }
        this.checkNoMissingArrayIndexes((HashSetValuedHashMap<String, Integer>)fieldsWithArrayIndexes, csvHeaderValidationManager);
    }

    private void checkRulePropertiesWithIndexRelativeToRuleId(CsvHeaderValidationManager csvHeaderValidationManager, SedaSchemaInfoResolver sedaSchemaInfoResolver) throws CollectInvalidCsvFormatException {
        HashSet<String> ruleIdFullFieldNames = new HashSet<String>();
        HashMap<String, String> rulePropertyToExpectedDeclaringRuleIdMap = new HashMap<String, String>();
        ArrayListValuedHashMap rulePropertyToInitialHeaderNames = new ArrayListValuedHashMap();
        for (String headerName : csvHeaderValidationManager.getRemainingManagementHeaderNamesToValidate()) {
            String fullFieldNameWithArrayIndex = null;
            for (CsvHeaderFieldNameIterable.FieldEntry fieldEntry : new CsvHeaderFieldNameIterable(headerName)) {
                String fullParentFieldName = fullFieldNameWithArrayIndex;
                fullFieldNameWithArrayIndex = CsvMetadataUtils.buildPath(fullFieldNameWithArrayIndex, fieldEntry.sedaFieldName());
                SedaSchemaInfo sedaManagementModel = sedaSchemaInfoResolver.getManagementModelBySedaPath(fieldEntry.simpleSedaPath());
                if (sedaManagementModel == null) {
                    throw new IllegalStateException("Expected valid seda path '" + fieldEntry.simpleSedaPath() + "'");
                }
                if (!sedaManagementModel.isArray()) continue;
                String arrayIndex = "0";
                if (fieldEntry.isDeclaredAsArray()) {
                    arrayIndex = String.valueOf(fieldEntry.arrayIndex());
                }
                fullFieldNameWithArrayIndex = CsvMetadataUtils.buildPath(fullFieldNameWithArrayIndex, arrayIndex);
                if ("Rule".equals(fieldEntry.sedaFieldName())) {
                    ruleIdFullFieldNames.add(fullFieldNameWithArrayIndex);
                }
                if (!sedaManagementModel.isSpecialRulePropertyArrayIndex()) continue;
                rulePropertyToExpectedDeclaringRuleIdMap.put(fullFieldNameWithArrayIndex, CsvMetadataUtils.buildPath(CsvMetadataUtils.buildPath(fullParentFieldName, "Rule"), arrayIndex));
                rulePropertyToInitialHeaderNames.put((Object)fullFieldNameWithArrayIndex, (Object)headerName);
            }
        }
        for (String rulePropertyFieldName : rulePropertyToExpectedDeclaringRuleIdMap.keySet()) {
            String expectedDeclaringRuleId = (String)rulePropertyToExpectedDeclaringRuleIdMap.get(rulePropertyFieldName);
            if (ruleIdFullFieldNames.contains(expectedDeclaringRuleId)) continue;
            for (String initialHeaderName : rulePropertyToInitialHeaderNames.get((Object)rulePropertyFieldName)) {
                csvHeaderValidationManager.report(initialHeaderName, "Rule property field '" + rulePropertyFieldName + "' does not have a corresponding '" + expectedDeclaringRuleId + "'.");
            }
        }
    }
}

