/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.csv;

import fr.gouv.vitam.collect.internal.core.csv.CsvMetadataUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;

public class CsvHeaderFieldNameIterable
implements Iterable<FieldEntry> {
    private final String[] fieldNames;

    public CsvHeaderFieldNameIterable(String headerName) {
        this.fieldNames = StringUtils.splitPreserveAllTokens((String)headerName, (String)".");
    }

    @Override
    public Iterator<FieldEntry> iterator() {
        return new Iterator<FieldEntry>(){
            private int index = 0;
            private String simpleSedaPath = null;
            private String fullSedaPath = null;

            @Override
            public boolean hasNext() {
                return this.index < CsvHeaderFieldNameIterable.this.fieldNames.length;
            }

            @Override
            public FieldEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String fieldName = CsvHeaderFieldNameIterable.this.fieldNames[this.index];
                String parentSimpleSedaPath = this.simpleSedaPath;
                this.simpleSedaPath = CsvMetadataUtils.buildPath(this.simpleSedaPath, fieldName);
                String parentFullSedaPath = this.fullSedaPath;
                String fullSedaPathWithoutLastArrayIndex = this.fullSedaPath = CsvMetadataUtils.buildPath(this.fullSedaPath, fieldName);
                Integer arrayIndex = null;
                if (this.index + 1 < CsvHeaderFieldNameIterable.this.fieldNames.length && CsvMetadataUtils.matchesPattern(CsvHeaderFieldNameIterable.this.fieldNames[this.index + 1], CsvMetadataUtils.ARRAY_INDEX_PATTERN)) {
                    String arrayIndexStr = CsvHeaderFieldNameIterable.this.fieldNames[this.index + 1];
                    arrayIndex = Integer.valueOf(arrayIndexStr);
                    this.fullSedaPath = CsvMetadataUtils.buildPath(this.fullSedaPath, arrayIndexStr);
                    ++this.index;
                }
                ++this.index;
                boolean isDeclaredAsObject = this.index < CsvHeaderFieldNameIterable.this.fieldNames.length;
                return new FieldEntry(fieldName, arrayIndex, isDeclaredAsObject, this.simpleSedaPath, this.fullSedaPath, fullSedaPathWithoutLastArrayIndex, parentFullSedaPath, parentSimpleSedaPath);
            }
        };
    }

    public record FieldEntry(String sedaFieldName, Integer arrayIndex, boolean isDeclaredAsObject, String simpleSedaPath, String fullSedaPath, String fullSedaPathWithoutLastArrayIndex, String parentFullSedaPath, String parentSimpleSedaPath) {
        public boolean isDeclaredAsArray() {
            return this.arrayIndex != null;
        }
    }
}

