/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.internal.core.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import fr.gouv.vitam.collect.common.dto.MetadataUnitUp;
import fr.gouv.vitam.collect.internal.core.common.ManifestContext;
import fr.gouv.vitam.collect.internal.core.common.ProjectStatus;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class ProjectModel {
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Context")
    private ManifestContext manifestContext;
    @JsonProperty(value="Status")
    private ProjectStatus status;
    @JsonProperty(value="CreationDate")
    private String creationDate;
    @JsonProperty(value="LastUpdate")
    private String lastUpdate;
    @JsonProperty(value="UnitUp")
    private String unitUp;
    @JsonProperty(value="UnitUps")
    private List<MetadataUnitUp> unitUps;
    @JsonProperty(value="_tenant")
    private Integer tenant;
    @JsonProperty(value="AutomaticIngest")
    private Boolean automaticIngest;
    @JsonProperty(value="ArchivingSystemId")
    private String archivingSystemId;
    @JsonProperty(value="ArchivingSystemTenant")
    private Integer archivingSystemTenant;
    @JsonProperty(value="ConnectedToArchivingSystem")
    private Boolean connectedToArchivingSystem;
    @JsonProperty(value="TransformationRules")
    @Beta
    private String transformationRules;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ManifestContext getManifestContext() {
        return this.manifestContext;
    }

    public void setManifestContext(ManifestContext manifestContext) {
        this.manifestContext = manifestContext;
    }

    public ProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatus status) {
        this.status = status;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getUnitUp() {
        return this.unitUp;
    }

    public void setUnitUp(String unitUp) {
        this.unitUp = unitUp;
    }

    public List<MetadataUnitUp> getUnitUps() {
        return this.unitUps;
    }

    public void setUnitUps(List<MetadataUnitUp> unitUps) {
        this.unitUps = unitUps;
    }

    public Integer getTenant() {
        return this.tenant;
    }

    public void setTenant(Integer tenant) {
        this.tenant = tenant;
    }

    public Boolean getAutomaticIngest() {
        return this.automaticIngest;
    }

    public void setAutomaticIngest(Boolean automaticIngest) {
        this.automaticIngest = automaticIngest;
    }

    public String getTransformationRules() {
        return this.transformationRules;
    }

    public String getArchivingSystemId() {
        return this.archivingSystemId;
    }

    public void setArchivingSystemId(String archivingSystemId) {
        this.archivingSystemId = archivingSystemId;
    }

    public Boolean getConnectedToArchivingSystem() {
        return this.connectedToArchivingSystem;
    }

    public Integer getArchivingSystemTenant() {
        return this.archivingSystemTenant;
    }

    public void setArchivingSystemTenant(Integer archivingSystemTenant) {
        this.archivingSystemTenant = archivingSystemTenant;
    }

    public void setConnectedToArchivingSystem(Boolean connectedToArchivingSystem) {
        this.connectedToArchivingSystem = connectedToArchivingSystem;
    }

    public ProjectModel setTransformationRules(String transformationRules) {
        this.transformationRules = transformationRules;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectModel that = (ProjectModel)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static class Builder {
        private final ProjectModel instance = new ProjectModel();

        public Builder id(String id) {
            this.instance.setId(id);
            return this;
        }

        public Builder name(String name) {
            this.instance.setName(name);
            return this;
        }

        public Builder manifestContext(ManifestContext context) {
            this.instance.setManifestContext(context);
            return this;
        }

        public Builder status(ProjectStatus status) {
            this.instance.setStatus(status);
            return this;
        }

        public Builder creationDate(String creationDate) {
            this.instance.setCreationDate(creationDate);
            return this;
        }

        public Builder lastUpdate(String lastUpdate) {
            this.instance.setLastUpdate(lastUpdate);
            return this;
        }

        public Builder unitUp(String unitUp) {
            this.instance.setUnitUp(unitUp);
            return this;
        }

        public Builder unitUps(List<MetadataUnitUp> unitUps) {
            this.instance.setUnitUps(unitUps);
            return this;
        }

        public Builder tenant(Integer tenant) {
            this.instance.setTenant(tenant);
            return this;
        }

        public Builder automaticIngest(Boolean automaticIngest) {
            this.instance.setAutomaticIngest(automaticIngest);
            return this;
        }

        public Builder archivingSystemId(String archivingSystemId) {
            this.instance.setArchivingSystemId(archivingSystemId);
            return this;
        }

        public Builder archivingSystemTenant(Integer archivingSystemTenant) {
            this.instance.setArchivingSystemTenant(archivingSystemTenant);
            return this;
        }

        public Builder connectedToArchivingSystem(Boolean connected) {
            this.instance.setConnectedToArchivingSystem(connected);
            return this;
        }

        public Builder transformationRules(String transformationRules) {
            this.instance.setTransformationRules(transformationRules);
            return this;
        }

        public ProjectModel build() {
            return this.instance;
        }
    }
}

