/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.xml;

import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.util.XMLCatalogResolver;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

@ThreadSafe
public class XsdValidator {
    private static final String CATALOG_FILENAME = "xsd_validation/catalog.xml";
    private final Schema schema;

    public XsdValidator(String internalXsdResourceFile) throws SAXException {
        this.schema = this.getSchemaFactory().newSchema(XsdValidator.class.getClassLoader().getResource(internalXsdResourceFile));
    }

    public XsdValidator(File xsdFile) throws SAXException, IOException {
        this.schema = this.getSchemaFactory().newSchema(xsdFile);
    }

    public void validate(File xmlFile) throws SAXException, IOException {
        SecureXMLFactoryUtils.validateXmlFile(xmlFile);
        Validator validator = SecureXMLFactoryUtils.internalCreateNotThatSecureSchemaValidator(this.schema);
        validator.validate(new StreamSource(xmlFile));
    }

    public Schema getSchema() {
        return this.schema;
    }

    private SchemaFactory getSchemaFactory() {
        SchemaFactory factory = SecureXMLFactoryUtils.internalCreateNotThatSecureXsdSchemaFactory();
        URL catalogUrl = XsdValidator.class.getClassLoader().getResource(CATALOG_FILENAME);
        factory.setResourceResolver((LSResourceResolver)new XMLCatalogResolver(new String[]{Objects.requireNonNull(catalogUrl).toString()}, false));
        return factory;
    }
}

