/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.xml;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.xml.InvalidXmlException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SecureXMLFactoryUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecureXMLFactoryUtils.class);
    private static final String RNG_FACTORY = "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory";
    private static final String RNG_PROPERTY_KEY = "javax.xml.validation.SchemaFactory:http://relaxng.org/ns/structure/1.0";
    private static final String HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1 = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String NONVALIDATING_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private SecureXMLFactoryUtils() {
    }

    public static XMLEventReader createSecureXMLEventReader(InputStream inputStream) throws XMLStreamException {
        return SecureXMLFactoryUtils.createSecureXMLInputFactory().createXMLEventReader(inputStream);
    }

    public static XMLStreamReader createSecureXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        return SecureXMLFactoryUtils.createSecureXMLInputFactory().createXMLStreamReader(inputStream);
    }

    public static XMLStreamReader createSecureXMLStreamReader(Reader reader) throws XMLStreamException {
        return SecureXMLFactoryUtils.createSecureXMLInputFactory().createXMLStreamReader(reader);
    }

    private static XMLInputFactory createSecureXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    }

    static SchemaFactory internalCreateNotThatSecureXsdSchemaFactory() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance(HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature(DISALLOW_DOCTYPE_DECL, true);
            return factory;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    static SchemaFactory internalCreateNotThatSecureRngSchemaFactory() {
        try {
            System.setProperty(RNG_PROPERTY_KEY, RNG_FACTORY);
            SchemaFactory factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature(DISALLOW_DOCTYPE_DECL, true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
            factory.setFeature(NONVALIDATING_LOAD_EXTERNAL_DTD, false);
            return factory;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SAXParserFactory createSecureSAXParserFactory() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature(DISALLOW_DOCTYPE_DECL, true);
            factory.setXIncludeAware(false);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            factory.setFeature(FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
            factory.setFeature(NONVALIDATING_LOAD_EXTERNAL_DTD, false);
            return factory;
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    static Validator internalCreateNotThatSecureSchemaValidator(Schema schema) {
        try {
            Validator validator = schema.newValidator();
            validator.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return validator;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void validateXmlFile(File xmlFile) throws SAXException {
        try {
            SecureXMLFactoryUtils.createSecureSAXParserFactory().newSAXParser().parse(xmlFile, new DefaultHandler(){

                @Override
                public void warning(SAXParseException e) {
                    LOGGER.warn("validation warning: " + e.getLocalizedMessage(), (Throwable)e);
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException("validation error : " + e.getLocalizedMessage(), e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new InvalidXmlException("Invalid XML file: " + e.getLocalizedMessage(), e);
                }
            });
        }
        catch (IOException | ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public static void xsltTransform(InputStream xsltInputStream, InputStream xmlInputStream, OutputStream xmlOutputStream) throws TransformerException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer(new StreamSource(xsltInputStream));
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) {
                    LOGGER.warn("An error occurred while processing xslt transformation", (Throwable)exception);
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                    throw exception;
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                    throw exception;
                }
            });
            transformer.transform(new StreamSource(xmlInputStream), new StreamResult(xmlOutputStream));
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }
}

