/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.xml;

import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.util.XMLCatalogResolver;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

@ThreadSafe
public class RngValidator {
    private static final String CATALOG_FILENAME = "xsd_validation/catalog.xml";
    private final Schema schema;

    public RngValidator(File schemaFile) throws SAXException {
        SecureXMLFactoryUtils.validateXmlFile(schemaFile);
        SchemaFactory factory = SecureXMLFactoryUtils.internalCreateNotThatSecureRngSchemaFactory();
        URL catalogUrl = RngValidator.class.getClassLoader().getResource(CATALOG_FILENAME);
        factory.setResourceResolver((LSResourceResolver)new XMLCatalogResolver(new String[]{Objects.requireNonNull(catalogUrl).toString()}, false));
        this.schema = factory.newSchema(schemaFile);
    }

    public void validate(File xmlFile) throws IOException, SAXException {
        SecureXMLFactoryUtils.validateXmlFile(xmlFile);
        Validator validator = SecureXMLFactoryUtils.internalCreateNotThatSecureSchemaValidator(this.schema);
        validator.validate(new StreamSource(xmlFile));
    }
}

