/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.utils;

import java.util.Arrays;
import java.util.Optional;

public enum SupportedSedaVersions {
    SEDA_2_1("2.1", "fr:gouv:culture:archivesdefrance:seda:v2.1", "seda-2.1/seda-2.1-main.xsd", "seda-2.1/vitam-validation/seda-vitam-main.xsd"),
    SEDA_2_2("2.2", "fr:gouv:culture:archivesdefrance:seda:v2.2", "seda-2.2/seda-2.2-main.xsd", "seda-2.2/vitam-validation/seda-vitam-main.xsd"),
    SEDA_2_3("2.3", "fr:gouv:culture:archivesdefrance:seda:v2.3", "seda-2.3/seda-2.3-main.xsd", "seda-2.3/vitam-validation/seda-vitam-main.xsd");

    public static final String UNIFIED_NAMESPACE = "fr:gouv:culture:archivesdefrance:seda:v2";
    public static final String GENERIC_VITAM_VALIDATOR = "seda-vitam/seda-vitam-main.xsd";
    private final String version;
    private final String namespaceURI;
    private final String sedaValidatorXSD;
    private final String vitamValidatorXSD;

    private SupportedSedaVersions(String version, String namespaceURI, String xsdValidator, String vitamValidatorXSD) {
        this.version = version;
        this.namespaceURI = namespaceURI;
        this.sedaValidatorXSD = xsdValidator;
        this.vitamValidatorXSD = vitamValidatorXSD;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSedaValidatorXSD() {
        return this.sedaValidatorXSD;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getVitamValidatorXSD() {
        return this.vitamValidatorXSD;
    }

    public static boolean isSedaVersionValid(String sedaVersion) {
        return Arrays.stream(SupportedSedaVersions.values()).map(SupportedSedaVersions::getVersion).anyMatch(sedaVersion::equals);
    }

    public static Optional<SupportedSedaVersions> getSupportedSedaVersionByVersion(String sedaVersion) {
        return Arrays.stream(SupportedSedaVersions.values()).filter(supportedSedaVersion -> sedaVersion.equals(supportedSedaVersion.getVersion())).findFirst();
    }

    public static Optional<SupportedSedaVersions> getSupportedSedaVersionByXmlNamespace(String xmlNamespace) {
        return Arrays.stream(SupportedSedaVersions.values()).filter(supportedSedaVersion -> supportedSedaVersion.getNamespaceURI().equals(xmlNamespace)).findFirst();
    }

    public static boolean isSedaVersionsCompatible(String metadataSedaVersion, String sedaVersionToExport) {
        return metadataSedaVersion != null && sedaVersionToExport != null && (metadataSedaVersion.equals(sedaVersionToExport) || sedaVersionToExport.equals(SEDA_2_2.getVersion()) && (metadataSedaVersion.equals(SEDA_2_1.getVersion()) || metadataSedaVersion.equals(SEDA_2_3.getVersion())) || sedaVersionToExport.equals(SEDA_2_3.getVersion()) && (metadataSedaVersion.equals(SEDA_2_1.getVersion()) || metadataSedaVersion.equals(SEDA_2_2.getVersion())));
    }
}

