/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class BufferedConsumer<T>
implements Consumer<T>,
AutoCloseable {
    private final Consumer<List<T>> bufferConsumer;
    private final List<T> entryBuffer = new ArrayList<T>();
    private final int bufferSize;

    public BufferedConsumer(int bufferSize, Consumer<List<T>> bufferConsumer) {
        this.bufferSize = bufferSize;
        this.bufferConsumer = bufferConsumer;
    }

    @Override
    public void accept(T entry) {
        this.entryBuffer.add(entry);
        if (this.entryBuffer.size() >= this.bufferSize) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.entryBuffer.isEmpty()) {
            this.bufferConsumer.accept(this.entryBuffer);
            this.entryBuffer.clear();
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

