/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.timestamp;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.timestamp.TimeStampSignature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;

public class TimeStampSignatureWithKeystore
implements TimeStampSignature {
    private final DigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
    private PrivateKey key;
    private final String tspPolicy;
    private Certificate[] certificateChain;

    public TimeStampSignatureWithKeystore(File pkcs12Path, char[] keystorePassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream fileInputStream = new FileInputStream(pkcs12Path);){
            String alias = this.loadKeystoreAndfindUniqueAlias(keystorePassword, keyStore, fileInputStream);
            this.key = (PrivateKey)keyStore.getKey(alias, keystorePassword);
            this.certificateChain = keyStore.getCertificateChain(alias);
        }
        this.tspPolicy = "1.1";
    }

    private String loadKeystoreAndfindUniqueAlias(char[] keystorePassword, KeyStore keyStore, FileInputStream fileInputStream) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        keyStore.load(fileInputStream, keystorePassword);
        Enumeration<String> aliases = keyStore.aliases();
        String alias = aliases.nextElement();
        if (aliases.hasMoreElements()) {
            throw new IllegalArgumentException("Keystore has many key");
        }
        return alias;
    }

    @Override
    public TimeStampResponse sign(TimeStampRequest request) throws OperatorCreationException, TSPException, CertificateEncodingException {
        DigestCalculator digestCalculator = this.digestCalculatorProvider.get(new AlgorithmIdentifier(request.getMessageImprintAlgOID()));
        String tspAlgorithm = this.computeTspAlgorithm(this.key, VitamConfiguration.getDefaultTimestampDigestType());
        SignerInfoGenerator signerInfoGen = new JcaSimpleSignerInfoGeneratorBuilder().build(tspAlgorithm, this.key, (X509Certificate)this.certificateChain[0]);
        ASN1ObjectIdentifier tsaPolicy = new ASN1ObjectIdentifier(this.tspPolicy);
        TimeStampTokenGenerator tokenGen = new TimeStampTokenGenerator(signerInfoGen, digestCalculator, tsaPolicy);
        tokenGen.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificateChain)));
        TimeStampResponseGenerator timeStampResponseGenerator = new TimeStampResponseGenerator(tokenGen, TSPAlgorithms.ALLOWED);
        Date currentDate = LocalDateUtil.getDate((LocalDateTime)LocalDateUtil.now());
        return timeStampResponseGenerator.generate(request, BigInteger.ONE, currentDate);
    }

    private String computeTspAlgorithm(PrivateKey privateKey, DigestType digestType) {
        return String.format("%sWith%s", digestType.name(), privateKey.getAlgorithm());
    }
}

