/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamSession;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class VitamThreadFactory
implements ThreadFactory {
    private static final VitamThreadFactory VITAM_THREAD_FACTORY = new VitamThreadFactory();
    private final AtomicLong threadNumber = new AtomicLong(0L);
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamThreadFactory.class);

    @Override
    public Thread newThread(Runnable arg0) {
        return new VitamThread(arg0, this.threadNumber.getAndIncrement());
    }

    public static final VitamThreadFactory getInstance() {
        return VITAM_THREAD_FACTORY;
    }

    public static class VitamThread
    extends Thread {
        private final ThreadLocal<VitamSession> vitamSession = ThreadLocal.withInitial(() -> new VitamSession(this));

        public VitamThread(Runnable runnable, long rank) {
            super(runnable, "vitam-thread-" + rank);
            LOGGER.debug("Created vitam-thread-{}", (Object)rank);
            this.setDaemon(true);
        }

        @NotNull
        public VitamSession getVitamSession() {
            return this.vitamSession.get();
        }
    }
}

