/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.thread;

import fr.gouv.vitam.common.thread.VitamThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorUtils {
    private ExecutorUtils() {
    }

    public static ThreadPoolExecutor createScalableBatchExecutorService(int maxBatchThreadPoolSize) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(maxBatchThreadPoolSize, maxBatchThreadPoolSize, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), VitamThreadFactory.getInstance());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor createScalableBatchExecutorService(int maxBatchThreadPoolSize, int maxQueueSizeBeforeBlocking) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(maxBatchThreadPoolSize, maxBatchThreadPoolSize, 1L, TimeUnit.MINUTES, new ThreadPoolQueue<Runnable>(maxQueueSizeBeforeBlocking), VitamThreadFactory.getInstance());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    private static class ThreadPoolQueue<T>
    extends ArrayBlockingQueue<T> {
        public ThreadPoolQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(T e) {
            try {
                this.put(e);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                return false;
            }
            return true;
        }
    }
}

