/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VitamAsyncInputStreamResponse
extends Response {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamAsyncInputStreamResponse.class);
    private final Response response;
    private final InputStream inputStream;
    private final Response.Status status;
    private final MediaType mediaType;

    public VitamAsyncInputStreamResponse(Response response) {
        this.inputStream = new VitamAsyncInputStream(response);
        this.status = (Response.Status)response.getStatusInfo();
        MediaType rmediaType = response.getMediaType();
        this.mediaType = Objects.requireNonNullElse(rmediaType, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        this.response = Response.status((Response.Status)this.status).type(this.mediaType).entity((Object)this.inputStream).build();
    }

    public VitamAsyncInputStreamResponse(Response response, Response.Status status, MediaType mediaType) {
        this.inputStream = new VitamAsyncInputStream(response);
        this.status = status;
        this.mediaType = Objects.requireNonNullElse(mediaType, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        this.response = Response.status((Response.Status)status).type(mediaType).entity((Object)this.inputStream).build();
    }

    public VitamAsyncInputStreamResponse(Response response, Response.Status status, Map<String, String> headers) {
        this.inputStream = new VitamAsyncInputStream(response);
        this.status = status;
        String mediaTypeString = headers.get("Content-Type");
        if (mediaTypeString == null || mediaTypeString.isEmpty()) {
            mediaTypeString = "application/octet-stream";
        }
        this.mediaType = MediaType.valueOf((String)mediaTypeString);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).type(this.mediaType);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            responseBuilder.header(header.getKey(), (Object)header.getValue());
        }
        this.response = responseBuilder.entity((Object)this.inputStream).build();
    }

    public VitamAsyncInputStreamResponse(InputStream inputStream, Response.Status status, Map<String, String> headers) {
        this.inputStream = inputStream;
        this.status = status;
        String mediaTypeString = headers.get("Content-Type");
        if (mediaTypeString == null || mediaTypeString.isEmpty()) {
            mediaTypeString = "application/octet-stream";
        }
        this.mediaType = MediaType.valueOf((String)mediaTypeString);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).type(this.mediaType);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            responseBuilder.header(header.getKey(), (Object)header.getValue());
        }
        this.response = responseBuilder.entity((Object)inputStream).build();
    }

    public static Map<String, String> getDefaultMapFromResponse(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        MediaType mediaType = response.getMediaType();
        String mediaTypeString = "application/octet-stream";
        if (mediaType != null) {
            mediaTypeString = mediaType.toString();
        }
        headers.put("Content-Type", mediaTypeString);
        headers.put("Content-Disposition", response.getHeaderString("Content-Disposition"));
        return headers;
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public Response.StatusType getStatusInfo() {
        return this.response.getStatusInfo();
    }

    public MediaType getMediaType() {
        return this.response.getMediaType();
    }

    public Object getEntity() {
        return this.inputStream;
    }

    public <T> T readEntity(Class<T> entityType) {
        return (T)this.inputStream;
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return (T)this.inputStream;
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return (T)this.inputStream;
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return (T)this.inputStream;
    }

    public void close() {
        StreamUtils.closeSilently((InputStream)this.inputStream);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.response.getHeaders();
    }

    public boolean hasEntity() {
        return this.response.hasEntity();
    }

    public boolean bufferEntity() {
        return this.response.bufferEntity();
    }

    public Locale getLanguage() {
        return this.response.getLanguage();
    }

    public int getLength() {
        return this.response.getLength();
    }

    public Set<String> getAllowedMethods() {
        return this.response.getAllowedMethods();
    }

    public Map<String, NewCookie> getCookies() {
        return this.response.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.response.getEntityTag();
    }

    public Date getDate() {
        return this.response.getDate();
    }

    public Date getLastModified() {
        return this.response.getLastModified();
    }

    public URI getLocation() {
        return this.response.getLocation();
    }

    public Set<Link> getLinks() {
        return this.response.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.response.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.response.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.response.getLinkBuilder(relation);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.response.getMetadata();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.response.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.response.getHeaderString(name);
    }
}

