/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.stream.StreamUtils;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class VitamAsyncInputStream
extends ProxyInputStream {
    private final Response response;
    boolean isClosed = false;

    public VitamAsyncInputStream(Response response) {
        super(VitamAsyncInputStream.readInputStream(response));
        this.response = response;
    }

    private static InputStream readInputStream(Response response) {
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            return (InputStream)entity;
        }
        return (InputStream)response.readEntity(InputStream.class);
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        StreamUtils.consumeAnyEntityAndClose((Response)this.response);
        StreamUtils.closeSilently((InputStream)this.in);
        this.isClosed = true;
    }
}

