/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;

public class MultiplexedStreamReader
implements AutoCloseable {
    public static final long EOF_MARKER = -1L;
    private final DataInputStream dataInputStream;

    public MultiplexedStreamReader(InputStream dataInputStream) {
        this.dataInputStream = new DataInputStream(dataInputStream);
    }

    public Optional<ExactSizeInputStream> readNextEntry() throws IOException {
        long size = this.dataInputStream.readLong();
        if (size == -1L) {
            if (this.dataInputStream.read() != -1) {
                throw new IOException("Expected EOF");
            }
            return Optional.empty();
        }
        return Optional.of(new ExactSizeInputStream((InputStream)new BoundedInputStream((InputStream)new CloseShieldInputStream((InputStream)this.dataInputStream), size), size));
    }

    @Override
    public void close() throws IOException {
        this.dataInputStream.close();
    }
}

