/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class ExactDigestValidatorInputStream
extends ProxyInputStream {
    private final String expectedDigest;
    private final Digest digest;

    public ExactDigestValidatorInputStream(InputStream in, DigestType digestType, String expectedDigest) {
        super((InputStream)null);
        this.digest = new Digest(digestType);
        this.in = this.digest.getDigestInputStream(in);
        this.expectedDigest = expectedDigest;
    }

    protected void afterRead(int n) throws IOException {
        String digestHex;
        if (n == -1 && !(digestHex = this.digest.digestHex()).equals(this.expectedDigest)) {
            throw new IOException("Invalid stream digest. Expected=" + this.expectedDigest + ", actual=" + digestHex);
        }
        super.afterRead(n);
    }
}

