/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.serverv2.metrics;

import fr.gouv.vitam.common.metrics.RequestLengthCountingInputStreamMetrics;
import fr.gouv.vitam.common.metrics.ResponseLengthCountingOutputStreamMetrics;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import java.io.InputStream;
import java.io.OutputStream;

@PreMatching
@Priority(value=3000)
public class ContentLengthCountingMetricsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final boolean countInputBytes;
    private final boolean countOutputBytes;

    public ContentLengthCountingMetricsFilter(boolean countInputBytes, boolean countOutputBytes) {
        this.countInputBytes = countInputBytes;
        this.countOutputBytes = countOutputBytes;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.countInputBytes && requestContext.getEntityStream() != null) {
            RequestLengthCountingInputStreamMetrics inputStream = new RequestLengthCountingInputStreamMetrics(requestContext, requestContext.getEntityStream());
            requestContext.setEntityStream((InputStream)((Object)inputStream));
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.countOutputBytes && responseContext.getEntityStream() != null) {
            ResponseLengthCountingOutputStreamMetrics inputStream = new ResponseLengthCountingOutputStreamMetrics(requestContext, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)((Object)inputStream));
        }
    }
}

