/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.serverv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.VitamConfigurationParameters;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.filter.AuthorizationFilter;
import fr.gouv.vitam.common.server.VitamServer;
import fr.gouv.vitam.common.server.VitamServerFactory;
import fr.gouv.vitam.common.server.application.configuration.VitamApplicationConfiguration;
import fr.gouv.vitam.common.tenant.filter.TenantFilter;
import fr.gouv.vitam.common.xsrf.filter.XSRFFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextListener;
import jakarta.ws.rs.core.Application;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class VitamStarter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamStarter.class);
    private static final String VITAM_CONF_FILE_NAME = "vitam.conf";
    private static final String SHIRO_FILE = "shiro.ini";
    private final String role = ServerIdentity.getInstance().getRole();
    private VitamServer vitamServer;
    private final Class<? extends Application> businessApplication;
    private final Class<? extends Application> adminApplication;
    private final Class<? extends VitamApplicationConfiguration> configurationType;
    private final List<ServletContextListener> customListeners;
    private final boolean deployStaticResources;

    public VitamStarter(Class<? extends VitamApplicationConfiguration> configurationType, String configurationFile, Class<? extends Application> businessApplication, Class<? extends Application> adminApplication) {
        this(configurationType, configurationFile, businessApplication, adminApplication, null, false);
    }

    public VitamStarter(Class<? extends VitamApplicationConfiguration> configurationType, String configurationFile, Class<? extends Application> businessApplication, Class<? extends Application> adminApplication, List<ServletContextListener> customListeners, boolean deployStaticResources) {
        this.businessApplication = businessApplication;
        this.adminApplication = adminApplication;
        this.configurationType = configurationType;
        this.customListeners = customListeners;
        this.deployStaticResources = deployStaticResources;
        this.configure(configurationFile);
    }

    protected final void configure(String configurationFile) {
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            VitamApplicationConfiguration buildConfiguration = (VitamApplicationConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, this.getConfigurationType());
            this.configure(buildConfiguration, configurationFile);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalStateException("Cannot start the " + this.role + " Application Server", e);
        }
    }

    private void configure(VitamApplicationConfiguration configuration, String configurationFile) {
        try {
            this.configureVitamParameters();
            ContextHandlerCollection applicationHandlers = new ContextHandlerCollection(new ContextHandler[0]);
            Handler.Sequence sequence = new Handler.Sequence(new Handler[0]);
            if (this.deployStaticResources) {
                URL staticResourcesUrl = this.getClass().getClassLoader().getResource("static");
                if (staticResourcesUrl != null) {
                    ResourceHandler staticContentHandler = new ResourceHandler();
                    staticContentHandler.setDirAllowed(true);
                    staticContentHandler.setWelcomeFiles(new String[]{"index.html"});
                    Resource resource = ResourceFactory.of((Container)staticContentHandler).newResource(staticResourcesUrl);
                    staticContentHandler.setBaseResource(resource);
                    ContextHandler staticContext = new ContextHandler(configuration.getBaseUri());
                    staticContext.setHandler((Handler)staticContentHandler);
                    sequence.addHandler((Handler)staticContext);
                } else {
                    LOGGER.warn("Missing static resources");
                }
            }
            sequence.addHandler(this.buildApplicationHandler(configurationFile, configuration));
            if (this.deployStaticResources) {
                sequence.addHandler((Handler)new DefaultHandler());
            }
            applicationHandlers.addHandler((Handler)sequence);
            applicationHandlers.addHandler(this.buildAdminHandler(configurationFile));
            String jettyConfig = configuration.getJettyConfig();
            LOGGER.info(this.role + " starts with jetty config");
            this.vitamServer = VitamServerFactory.newVitamServerByJettyConf(jettyConfig);
            this.vitamServer.configure((Handler)applicationHandlers);
        }
        catch (VitamApplicationServerException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalStateException(String.format("Cannot start the %s application server", this.role), e);
        }
    }

    protected void configureVitamParameters() {
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)VITAM_CONF_FILE_NAME);){
            VitamConfigurationParameters vitamConfigurationParameters = (VitamConfigurationParameters)PropertiesUtils.readYaml((InputStream)yamlIS, VitamConfigurationParameters.class);
            VitamConfiguration.importConfigurationParameters((VitamConfigurationParameters)vitamConfigurationParameters);
            VitamConfiguration.setSecret((String)vitamConfigurationParameters.getSecret());
            VitamConfiguration.setFilterActivation((Boolean)vitamConfigurationParameters.isFilterActivation());
            VitamConfiguration.setEnvironmentName((String)vitamConfigurationParameters.getEnvironmentName());
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new IllegalStateException("Cannot start the " + this.role + " Application Server", e);
        }
    }

    public final Class<? extends VitamApplicationConfiguration> getConfigurationType() {
        return this.configurationType;
    }

    protected Handler buildApplicationHandler(String configurationFile, VitamApplicationConfiguration configuration) throws VitamApplicationServerException {
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("jakarta.ws.rs.Application", this.businessApplication.getName());
        servletHolder.setInitParameter("vitam.configurationFile", configurationFile);
        ServletContextHandler context = new ServletContextHandler(configuration.isEnableSession() ? 1 : 0);
        context.addServlet(servletHolder, "/*");
        if (!Strings.isNullOrEmpty((String)configuration.getBaseUrl())) {
            context.setContextPath(configuration.getBaseUrl());
        }
        if (VitamConfiguration.isFilterActivation().booleanValue() && !Strings.isNullOrEmpty((String)VitamConfiguration.getSecret())) {
            context.addFilter(AuthorizationFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
        }
        context.setVirtualHosts(List.of("@business"));
        if (configuration.isEnableXsrFilter()) {
            context.addFilter(XSRFFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
        }
        if (configuration.isAuthentication()) {
            this.addShiroFilter(context);
        }
        if (configuration.isTenantFilter()) {
            this.addTenantFilter(context, VitamConfiguration.getTenants());
        }
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)context);
        return stats;
    }

    protected Handler buildAdminHandler(String configurationFile) {
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServletDispatcher());
        servletHolder.setInitParameter("jakarta.ws.rs.Application", this.adminApplication.getName());
        servletHolder.setInitParameter("vitam.configurationFile", configurationFile);
        ServletContextHandler context = new ServletContextHandler(0);
        context.addServlet(servletHolder, "/*");
        context.setVirtualHosts(List.of("@admin"));
        if (this.customListeners != null && !this.customListeners.isEmpty()) {
            this.customListeners.forEach(listener -> context.addEventListener((EventListener)listener));
        }
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)context);
        return stats;
    }

    private void addShiroFilter(ServletContextHandler context) throws VitamApplicationServerException {
        File shiroFile = null;
        try {
            shiroFile = PropertiesUtils.findFile((String)SHIRO_FILE);
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new VitamApplicationServerException(e.getMessage());
        }
        context.setInitParameter("shiroConfigLocations", "file:" + shiroFile.getAbsolutePath());
        context.addEventListener((EventListener)new EnvironmentLoaderListener());
        FilterHolder shiroFilterHolder = new FilterHolder(ShiroFilter.class);
        context.addFilter(shiroFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.ERROR, DispatcherType.ASYNC));
    }

    private void addTenantFilter(ServletContextHandler context, List<Integer> tenantList) throws VitamApplicationServerException {
        try {
            JsonNode node = JsonHandler.toJsonNode(tenantList);
            context.setInitParameter("tenantList", JsonHandler.unprettyPrint((Object)node));
            context.addFilter(TenantFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ERROR, DispatcherType.ASYNC));
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new VitamApplicationServerException(e.getMessage());
        }
    }

    public final void run() throws VitamApplicationServerException {
        if (this.vitamServer != null && !this.vitamServer.isStarted()) {
            this.vitamServer.startAndJoin();
        } else if (this.vitamServer == null) {
            throw new VitamApplicationServerException("VitamServer is not ready to be started");
        }
    }

    public void start() throws VitamApplicationServerException {
        try {
            this.vitamServer.start();
        }
        catch (Exception exc) {
            throw new VitamApplicationServerException("A problem occurred while attempting to start the server", (Throwable)exc);
        }
    }

    public void stop() throws VitamApplicationServerException {
        try {
            this.vitamServer.stop();
        }
        catch (Exception exc) {
            throw new VitamApplicationServerException("A problem occurred while attempting to stop the server", (Throwable)exc);
        }
    }

    public boolean isStarted() {
        return this.vitamServer.isStarted();
    }

    public VitamServer getVitamServer() {
        return this.vitamServer;
    }

    public boolean isStopped() {
        return this.vitamServer.isStopped();
    }
}

