/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadManager {
    private ConcurrentLinkedQueue<String> requests = new ConcurrentLinkedQueue();
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ThreadManager.class);

    public void addRequest(MultivaluedMap<String, String> headers) {
        String requestId = GUIDFactory.newGUID().toString();
        VitamThreadUtils.getVitamSession().setInternalRequestId(requestId);
        this.requests.add(requestId);
    }

    public void removeRequest() {
        this.requests.remove(VitamThreadUtils.getVitamSession().getInternalRequestId());
    }

    public void shutdownAndWait() {
        long timeout = 0L;
        while (!this.requests.isEmpty()) {
            try {
                if (timeout >= VitamConfiguration.getShutdownTimeout()) {
                    return;
                }
                Thread.sleep(1000L);
                timeout += 1000L;
            }
            catch (InterruptedException e) {
                LOGGER.warn("thread is already occupied", (Throwable)e);
            }
        }
    }
}

