/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

import com.google.common.base.Joiner;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class HttpHeaderHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(HttpHeaderHelper.class);
    private static final String CASE_INSENSITIVE = "(?i)";

    private HttpHeaderHelper() {
    }

    public static List<String> getHeaderValues(HttpHeaders headers, VitamHttpHeader name) {
        ParametersChecker.checkParameter((String)"Name cannot be null", (Object[])new Object[]{name});
        return HttpHeaderHelper.getHeaderValues(headers, name.getName());
    }

    public static List<String> getHeaderValues(HttpHeaders headers, String name) {
        ParametersChecker.checkParameter((String)"Name cannot be null", (String[])new String[]{name});
        ParametersChecker.checkParameter((String)"Headers cannot be null", (Object[])new Object[]{headers});
        return headers.getRequestHeader(name);
    }

    public static boolean hasValuesFor(HttpHeaders headers, VitamHttpHeader vitamHeader) {
        ParametersChecker.checkParameter((String)"Header name cannot be null", (Object[])new Object[]{vitamHeader});
        ParametersChecker.checkParameter((String)"Headers cannot be null", (Object[])new Object[]{headers});
        List values = headers.getRequestHeader(vitamHeader.getName());
        return values != null && !values.isEmpty();
    }

    public static void checkVitamHeaders(HttpHeaders headers) {
        ParametersChecker.checkParameter((String)"Headers cannot be null", (Object[])new Object[]{headers});
        MultivaluedMap requestHeaders = headers.getRequestHeaders();
        HttpHeaderHelper.checkVitamHeadersMap((MultivaluedMap<String, String>)requestHeaders);
    }

    public static void checkVitamHeadersMap(MultivaluedMap<String, String> requestHeaders) {
        if (requestHeaders != null && !requestHeaders.isEmpty()) {
            for (VitamHttpHeader vitamHttpHeader : VitamHttpHeader.values()) {
                List values = (List)requestHeaders.get((Object)vitamHttpHeader.getName());
                if (values == null || values.stream().anyMatch(value -> value.matches(CASE_INSENSITIVE + vitamHttpHeader.getRegExp()))) continue;
                throw new IllegalStateException(String.format("%s header has wrong value", vitamHttpHeader.getName()));
            }
        }
    }

    public static void validateHeaderValue(HttpHeaders headers, MultivaluedHashMap<String, String> wantedHeaders) {
        ParametersChecker.checkParameter((String)"Headers cannot be null", (Object[])new Object[]{headers});
        ArrayList<String> errorDetails = new ArrayList<String>();
        for (String wantedHeaderName : wantedHeaders.keySet()) {
            List<String> wantedValues = HttpHeaderHelper.toLowerCaseList(wantedHeaders.get((Object)wantedHeaderName));
            VitamHttpHeader vitamHeader = VitamHttpHeader.get(wantedHeaderName);
            List<String> headersValues = HttpHeaderHelper.toLowerCaseList(headers.getRequestHeader(wantedHeaderName));
            List<String> tmpWantedValues = HttpHeaderHelper.toLowerCaseList(wantedValues);
            if (headersValues.isEmpty()) {
                errorDetails.add(String.format("Header %s values are null", wantedHeaderName));
            } else {
                List<String> tmpHeadersValues = HttpHeaderHelper.toLowerCaseList(headersValues);
                if (vitamHeader != null) {
                    errorDetails.addAll(HttpHeaderHelper.collectNonMatchingItems(vitamHeader, wantedValues, wantedHeaderName, "Wanted value %s for header %s does not match with define regular %s"));
                    errorDetails.addAll(HttpHeaderHelper.collectNonMatchingItems(vitamHeader, headersValues, wantedHeaderName, "Found value %s for header %s does not match with define regular %s"));
                }
                tmpHeadersValues.removeAll(wantedValues);
                tmpWantedValues.removeAll(headersValues);
                if (!tmpHeadersValues.isEmpty()) {
                    LOGGER.warn("Some values ({}) from header {} were not check (not asked)", (Object)Joiner.on((String)", ").join(tmpHeadersValues), (Object)wantedHeaderName);
                }
            }
            if (tmpWantedValues.isEmpty()) continue;
            errorDetails.add(String.format("Some WANTED values from header %s were not found (%s)", wantedHeaderName, Joiner.on((String)", ").join(tmpWantedValues)));
        }
        if (!errorDetails.isEmpty()) {
            throw new IllegalArgumentException(String.format("There are %d errors %n%s", errorDetails.size(), Joiner.on((String)"\n").join(errorDetails)));
        }
    }

    private static List<String> toLowerCaseList(List<String> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    private static List<String> collectNonMatchingItems(VitamHttpHeader vitamHeader, List<String> valuesTocheck, String wantedHeaderName, String messageTemplate) {
        ArrayList<String> result = new ArrayList<String>();
        if (vitamHeader != null && valuesTocheck != null) {
            result.addAll(valuesTocheck.stream().filter(headerValue -> !headerValue.matches(CASE_INSENSITIVE + vitamHeader.getRegExp())).map(headerValue -> String.format(messageTemplate, headerValue, wantedHeaderName, vitamHeader.getRegExp())).collect(Collectors.toList()));
        }
        return result;
    }
}

