/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;

public class GenericExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GenericExceptionMapper.class);
    private static final String URI_HOST_PORT_PATTERN = "(https|http)://[a-zA-Z0-9.\\-_]+(:[0-9]+)?/";

    public Response toResponse(Throwable exception) {
        VitamError vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.GLOBAL_INTERNAL_SERVER_ERROR));
        String description = exception.getMessage();
        description = Strings.isNullOrEmpty((String)description) ? StringUtils.getClassName((Object)exception) : description.replaceAll(URI_HOST_PORT_PATTERN, "");
        vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getMessage()).setDescription(description).setState(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.name()).setHttpCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getStatus().getStatusCode());
        if (exception instanceof BadRequestException || exception instanceof JsonMappingException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        } else if (exception instanceof ForbiddenException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.FORBIDDEN.getStatusCode());
        } else if (exception instanceof NotAcceptableException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.NOT_ACCEPTABLE.getStatusCode());
        } else if (exception instanceof NotAllowedException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.METHOD_NOT_ALLOWED.getStatusCode());
        } else if (exception instanceof NotAuthorizedException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode());
        } else if (exception instanceof NotFoundException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
        } else if (exception instanceof NotSupportedException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        } else if (exception instanceof RedirectionException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.SEE_OTHER.getStatusCode());
        } else if (exception instanceof ServiceUnavailableException) {
            vitamError.setMessage(description).setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode());
        }
        LOGGER.error(vitamError.toString(), exception);
        return Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

