/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.VitamStreamingOutput;
import fr.gouv.vitam.common.stream.StreamUtils;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;

public class AsyncInputStreamHelper {
    private final AsyncResponse asyncResponse;
    private final Response receivedResponse;
    private InputStream inputStream;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AsyncInputStreamHelper.class);

    public AsyncInputStreamHelper(AsyncResponse asyncResponse, InputStream inputStream) {
        ParametersChecker.checkParameter((String)"Parameters should not be null", (Object[])new Object[]{asyncResponse, inputStream});
        this.asyncResponse = asyncResponse;
        this.receivedResponse = null;
        this.inputStream = inputStream;
    }

    public AsyncInputStreamHelper(AsyncResponse asyncResponse, Response receivedResponse) {
        ParametersChecker.checkParameter((String)"Parameters should not be null", (Object[])new Object[]{asyncResponse, receivedResponse});
        this.asyncResponse = asyncResponse;
        this.receivedResponse = receivedResponse;
    }

    public void writeErrorResponse(Response errorResponse) {
        if (this.inputStream != null) {
            StreamUtils.closeSilently((InputStream)this.inputStream);
            this.inputStream = null;
        }
        try {
            AsyncInputStreamHelper.asyncResponseResume(this.asyncResponse, errorResponse);
        }
        finally {
            DefaultClient.staticConsumeAnyEntityAndClose(this.receivedResponse);
        }
    }

    public void writeResponse(Response.ResponseBuilder responseBuilder) {
        try {
            ParametersChecker.checkParameter((String)"ResponseBuilder should not be null", (Object[])new Object[]{responseBuilder});
            if (this.receivedResponse != null) {
                try {
                    this.inputStream = (InputStream)this.receivedResponse.readEntity(InputStream.class);
                }
                catch (IllegalStateException e) {
                    LOGGER.error((Throwable)e);
                    AsyncInputStreamHelper.asyncResponseResume(this.asyncResponse, this.getResponseError(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR));
                    DefaultClient.staticConsumeAnyEntityAndClose(this.receivedResponse);
                    return;
                }
            }
            VitamStreamingOutput vitamStreamingOutput = new VitamStreamingOutput(this.inputStream);
            this.asyncResponse.register(throwable -> vitamStreamingOutput.close());
            this.asyncResponse.resume((Object)responseBuilder.entity((Object)vitamStreamingOutput).build());
        }
        finally {
            DefaultClient.staticConsumeAnyEntityAndClose(this.receivedResponse);
        }
    }

    public static void asyncResponseResume(AsyncResponse asyncResponse, Response response) {
        ParametersChecker.checkParameter((String)"ErrorResponse should not be null", (Object[])new Object[]{response});
        asyncResponse.register(throwable -> {
            Object entity = response.getEntity();
            if (entity != null && entity instanceof InputStream) {
                StreamUtils.closeSilently((InputStream)((InputStream)entity));
            }
        });
        asyncResponse.resume((Object)response);
    }

    public static void asyncResponseResume(AsyncResponse asyncResponse, Response response, InputStream stream) {
        StreamUtils.closeSilently((InputStream)stream);
        ParametersChecker.checkParameter((String)"ErrorResponse should not be null", (Object[])new Object[]{response});
        asyncResponse.resume((Object)response);
    }

    private Response getResponseError(VitamCode vitamCode) {
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(vitamCode.getMessage()).toString()).build();
    }
}

