/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.BasicVitamServer;
import fr.gouv.vitam.common.server.VitamServer;

public class VitamServerFactory {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamServerFactory.class);
    private static final int DEFAULT_PORT = 8082;
    private static int defaultPort = 8082;

    private VitamServerFactory() {
    }

    public static VitamServer newVitamServerOnDefaultPort() {
        return VitamServerFactory.newVitamServer(defaultPort);
    }

    public static void setDefaultPort(int port) {
        ParametersChecker.checkValue((String)"Port", (long)port, (long)1L);
        defaultPort = port;
    }

    public static int getDefaultPort() {
        return defaultPort;
    }

    public static VitamServer newVitamServer(int port) {
        ParametersChecker.checkValue((String)"Port", (long)port, (long)1L);
        return new BasicVitamServer(port);
    }

    public static VitamServer newVitamServerWithoutConnector(int port) {
        ParametersChecker.checkValue((String)"Port", (long)port, (long)1L);
        return new BasicVitamServer(port, false);
    }

    public static VitamServer newVitamServerByJettyConf(String jettyConfigFile) throws VitamApplicationServerException {
        try {
            ParametersChecker.checkParameter((String)"jetty config file", (String[])new String[]{jettyConfigFile});
            return new BasicVitamServer(jettyConfigFile);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Jetty server can not run with this jetty config file : " + jettyConfigFile + " " + e.getMessage(), (Throwable)e);
            throw new VitamApplicationServerException("Jetty server can not run with this jetty config file : " + jettyConfigFile);
        }
    }
}

