/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server;

import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.server.HeaderIdHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;

@PreMatching
@Priority(value=990)
public class RequestIdGeneratorContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        String headerTenantId = HeaderIdHelper.getHeaderString((MultivaluedMap<String, String>)requestHeaders, "X-Tenant-Id");
        if (headerTenantId != null) {
            Integer tenantId = Integer.parseInt(headerTenantId);
            GUID requestId = GUIDFactory.newRequestIdGUID((int)tenantId);
            VitamSession vitamSession = VitamThreadUtils.getVitamSession();
            vitamSession.setRequestId(requestId);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        HeaderIdHelper.putVitamIdFromSessionInExternalHeader((MultivaluedMap<String, Object>)responseContext.getHeaders(), HeaderIdHelper.Context.RESPONSE, responseContext.getStatus());
    }
}

