/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server;

import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;

public class HeaderIdHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(HeaderIdHelper.class);

    private HeaderIdHelper() {
        throw new UnsupportedOperationException("Helper class");
    }

    public static void putVitamIdFromExternalHeaderInSession(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        try {
            HeaderIdHelper.extractContractIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractTenantIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractApplicationSessionIdFromHeaders(requestHeaders, ctx);
        }
        catch (VitamThreadAccessException e) {
            LOGGER.warn("Got an exception while trying to set the headers in the current session {}; exception was : {}", requestHeaders, (Object)e.getMessage());
        }
    }

    public static void putVitamIdFromHeaderInSession(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        try {
            HeaderIdHelper.extractContractIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractContextIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractRequestIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractTenantIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractApplicationSessionIdFromHeaders(requestHeaders, ctx);
            HeaderIdHelper.extractPersonalCertificateFromHeaders(requestHeaders, ctx);
        }
        catch (VitamThreadAccessException e) {
            LOGGER.debug("Got an exception while trying to set the headers in the current session {}; exception was : {}", requestHeaders, (Object)e.getMessage());
        }
    }

    private static void extractRequestIdFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        String requestId = HeaderIdHelper.getHeaderString(requestHeaders, "X-Request-Id");
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        if (vitamSession.getRequestId() != null && !vitamSession.getRequestId().equals(requestId)) {
            LOGGER.info("Note : the requestId stored in session was not empty and different from the received requestId before {} handling ! Some cleanup must have failed... Old requestId will be discarded in session.", (Object)ctx);
        }
        vitamSession.setRequestId(requestId);
        if (requestId != null) {
            LOGGER.debug("Got requestId {} from {} headers ; setting it in the current VitamSession", (Object)requestId, (Object)ctx);
        } else {
            LOGGER.debug("No requestId found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    private static void extractContractIdFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        String contractId = HeaderIdHelper.getHeaderString(requestHeaders, "X-Access-Contract-Id");
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        if (vitamSession.getContractId() != null && !vitamSession.getContractId().equals(contractId)) {
            LOGGER.info("Note : the contractId stored in session was not empty and different from the received contractId before {} handling ! Some cleanup must have failed... Old contractId will be discarded in session.", (Object)ctx);
        }
        vitamSession.setContractId(contractId);
        if (contractId != null) {
            LOGGER.debug("Got contractId {} from {} headers ; setting it in the current VitamSession", (Object)contractId, (Object)ctx);
        } else {
            LOGGER.debug("No contractId found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    private static void extractContextIdFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        String contextId = HeaderIdHelper.getHeaderString(requestHeaders, "X-Security-Context-ID");
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        if (vitamSession.getContextId() != null && !vitamSession.getContextId().equals(contextId)) {
            LOGGER.info("Note : the contextId stored in session was not empty and different from the received contextId before {} handling ! Some cleanup must have failed... Old contextId will be discarded in session.", (Object)ctx);
        }
        vitamSession.setContextId(contextId);
        if (contextId != null) {
            LOGGER.debug("Got contextId {} from {} headers ; setting it in the current VitamSession", (Object)contextId, (Object)ctx);
        } else {
            LOGGER.debug("No contextId found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    private static void extractPersonalCertificateFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        String personalCertificate = HeaderIdHelper.getHeaderString(requestHeaders, "X-Personal-Certificate");
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        if (vitamSession.getPersonalCertificate() != null && !vitamSession.getPersonalCertificate().equals(personalCertificate)) {
            LOGGER.info("Note : the personalCertificate stored in session was not empty and different from the received personalCertificate before {} handling ! Some cleanup must have failed... Old personalCertificate will be discarded in session.", (Object)ctx);
        }
        vitamSession.setPersonalCertificate(personalCertificate);
        if (personalCertificate != null) {
            LOGGER.debug("Got personalCertificate {} from {} headers ; setting it in the current VitamSession", (Object)personalCertificate, (Object)ctx);
        } else {
            LOGGER.debug("No personalCertificate found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    private static void extractTenantIdFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        VitamSession vitamSession;
        String headerTenantId = HeaderIdHelper.getHeaderString(requestHeaders, "X-Tenant-Id");
        Integer tenantId = null;
        if (headerTenantId != null) {
            tenantId = Integer.parseInt(headerTenantId);
        }
        if ((vitamSession = VitamThreadUtils.getVitamSession()).getTenantId() != null && !vitamSession.getTenantId().equals(tenantId)) {
            LOGGER.info("Note : the tenantId stored in session was not empty and different from the received tenantId before {} handling ! Some cleanup must have failed... Old tenantId will be discarded in session.", (Object)ctx);
        }
        vitamSession.setTenantId(tenantId);
        if (tenantId != null) {
            LOGGER.debug("Got tenantId {} from {} headers ; setting it in the current VitamSession", (Object)tenantId, (Object)ctx);
        } else {
            LOGGER.debug("No tenantId found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    private static void extractApplicationSessionIdFromHeaders(MultivaluedMap<String, String> requestHeaders, Context ctx) {
        String applicationSessionId = HeaderIdHelper.getHeaderString(requestHeaders, "X-Application-Id");
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        if (vitamSession.getApplicationSessionId() != null && !vitamSession.getApplicationSessionId().equals(applicationSessionId)) {
            LOGGER.info("Note : the applicationSessionId stored in session was not empty and different from the received applicationSessionId before {} handling ! Some cleanup must have failed... Old applicationSessionId will be discarded in session.", (Object)ctx);
        }
        vitamSession.setApplicationSessionId(applicationSessionId);
        if (applicationSessionId != null) {
            LOGGER.debug("Got applicationSessionId {} from {} headers ; setting it in the current VitamSession", (Object)applicationSessionId, (Object)ctx);
        } else {
            LOGGER.debug("No applicationSessionId found in {} ; setting it as empty in the current VitamSession", (Object)ctx);
        }
    }

    public static String getHeaderString(MultivaluedMap<String, String> requestHeaders, String headerName) {
        String headerValue = (String)requestHeaders.getFirst((Object)headerName);
        if (headerValue != null) {
            headerValue = headerValue.split(",")[0];
        }
        return headerValue;
    }

    public static void putVitamIdFromSessionInExternalHeader(MultivaluedMap<String, Object> headers, Context ctx, int statusCode) {
        try {
            String requestId = VitamThreadUtils.getVitamSession().getRequestId();
            if (requestId != null) {
                if (headers.containsKey((Object)"X-Request-Id")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Request-Id", (Object)ctx);
                } else {
                    headers.add((Object)"X-Request-Id", (Object)requestId);
                    LOGGER.debug("RequestId {} found in session and set in the {} header.", (Object)requestId, (Object)ctx);
                }
            } else {
                LOGGER.info("No RequestId found in session (somebody should have set it) ! ");
                if (ctx.equals((Object)Context.RESPONSE) && statusCode >= Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    String newRequestId = GUIDFactory.newGUID().toString();
                    if (headers.containsKey((Object)"X-Request-Id")) {
                        LOGGER.info("X_REQUEST_ID  header was already present in the headers");
                    } else {
                        headers.add((Object)"X-Request-Id", (Object)newRequestId);
                    }
                }
            }
        }
        catch (VitamThreadAccessException e) {
            LOGGER.warn("Got an exception while trying to get the headers from the current session ; exception was : {}", (Object)e.getMessage());
        }
    }

    public static void putVitamIdFromSessionInHeader(MultivaluedMap<String, Object> headers, Context ctx, int statusCode) {
        try {
            String requestId = VitamThreadUtils.getVitamSession().getRequestId();
            Integer tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            String contractId = VitamThreadUtils.getVitamSession().getContractId();
            String contextId = VitamThreadUtils.getVitamSession().getContextId();
            String personalCertificate = VitamThreadUtils.getVitamSession().getPersonalCertificate();
            String applicationSessionId = VitamThreadUtils.getVitamSession().getApplicationSessionId();
            if (requestId != null) {
                if (headers.containsKey((Object)"X-Request-Id")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Request-Id", (Object)ctx);
                } else {
                    headers.add((Object)"X-Request-Id", (Object)requestId);
                    LOGGER.debug("RequestId {} found in session and set in the {} header.", (Object)requestId, (Object)ctx);
                }
            } else {
                LOGGER.info("No RequestId found in session (somebody should have set it) ! ");
                if (ctx.equals((Object)Context.RESPONSE) && statusCode >= Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                    String newRequestId = GUIDFactory.newGUID().toString();
                    if (headers.containsKey((Object)"X-Request-Id")) {
                        LOGGER.info("X_REQUEST_ID  header was already present in the headers");
                    } else {
                        headers.add((Object)"X-Request-Id", (Object)newRequestId);
                    }
                }
            }
            if (tenantId != null) {
                if (headers.containsKey((Object)"X-Tenant-Id")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Tenant-Id", (Object)ctx);
                } else {
                    headers.add((Object)"X-Tenant-Id", (Object)tenantId);
                    LOGGER.debug("tenantId {} found in session and set in the {} header.", (Object)tenantId, (Object)ctx);
                }
            } else {
                LOGGER.debug("No tenantId found in session (somebody should have set it) ! {} header will not be set in the http {}.", (Object)"X-Tenant-Id", (Object)ctx);
            }
            if (contractId != null) {
                if (headers.containsKey((Object)"X-Access-Contract-Id")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Access-Contract-Id", (Object)ctx);
                } else {
                    headers.add((Object)"X-Access-Contract-Id", (Object)contractId);
                    LOGGER.debug("contractId {} found in session and set in the {} header.", (Object)contractId, (Object)ctx);
                }
            } else {
                LOGGER.debug("No contract id found in session (somebody should have set it) ! {} header will not be set in the http {}.", (Object)"X-Access-Contract-Id", (Object)ctx);
            }
            if (contextId != null) {
                if (headers.containsKey((Object)"X-Security-Context-ID")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Security-Context-ID", (Object)ctx);
                } else {
                    headers.add((Object)"X-Security-Context-ID", (Object)contextId);
                    LOGGER.debug("contextId {} found in session and set in the {} header.", (Object)contextId, (Object)ctx);
                }
            } else {
                LOGGER.debug("No contextId found in session (somebody should have set it) ! {} header will not be set in the http {}.", (Object)"X-Security-Context-ID", (Object)ctx);
            }
            if (personalCertificate != null) {
                if (headers.containsKey((Object)"X-Personal-Certificate")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Personal-Certificate", (Object)ctx);
                } else {
                    headers.add((Object)"X-Personal-Certificate", (Object)personalCertificate);
                    LOGGER.debug("personalCertificate {} found in session and set in the {} header.", (Object)personalCertificate, (Object)ctx);
                }
            } else {
                LOGGER.debug("No contextId found in session (somebody should have set it) ! {} header will not be set in the http {}.", (Object)"X-Security-Context-ID", (Object)ctx);
            }
            if (applicationSessionId != null) {
                if (headers.containsKey((Object)"X-Application-Id")) {
                    LOGGER.info("{} header was already present in the headers of the {} ; this header will be kept.", (Object)"X-Application-Id", (Object)ctx);
                } else {
                    headers.add((Object)"X-Application-Id", (Object)applicationSessionId);
                    LOGGER.debug("applicationSessionId {} found in session and set in the {} header.", (Object)applicationSessionId, (Object)ctx);
                }
            } else {
                LOGGER.debug("No applicationSessionId found in session (somebody should have set it) ! {} header will not be set in the http {}.", (Object)"X-Application-Id", (Object)ctx);
            }
        }
        catch (VitamThreadAccessException e) {
            LOGGER.warn("Got an exception while trying to get the headers from the current session ; exception was : {}", (Object)e.getMessage());
        }
    }

    public static enum Context {
        REQUEST,
        RESPONSE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

