/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.VitamServer;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.xml.sax.SAXException;

public class BasicVitamServer
implements VitamServer {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BasicVitamServer.class);
    private static final String A_PROBLEM_OCCURRED_WHILE_ATTEMPTING_TO_START_THE_SERVER = "A problem occurred while attempting to start the server";
    private int port;
    private Handler handler;
    private Server server;
    private XmlConfiguration serverConfiguration;
    private boolean configured = false;
    VitamThreadPoolExecutor vitamThreadPoolExecutor = new VitamThreadPoolExecutor();

    protected BasicVitamServer(int port, boolean withConnector) {
        ParametersChecker.checkValue((String)"You must provide a valid port number", (long)port, (long)1L);
        this.port = port;
        this.server = new Server((ThreadPool)this.vitamThreadPoolExecutor);
        if (withConnector) {
            ServerConnector serverConnector = new ServerConnector(this.server);
            serverConnector.setPort(port);
            this.server.addConnector((Connector)serverConnector);
        }
    }

    protected BasicVitamServer(int port) {
        this(port, true);
    }

    protected BasicVitamServer(String jettyConfigPath) throws VitamApplicationServerException {
        try {
            LOGGER.info("Starting server with configuration file : " + jettyConfigPath);
            PathResourceFactory resourcePathResource = new PathResourceFactory();
            Resource resource = resourcePathResource.newResource(PropertiesUtils.getConfigFile((String)jettyConfigPath).getPath());
            this.serverConfiguration = new XmlConfiguration(resource);
            this.server = new Server((ThreadPool)this.vitamThreadPoolExecutor);
            this.server = (Server)this.serverConfiguration.configure((Object)this.server);
            this.configured = true;
            LOGGER.info("Server started.");
        }
        catch (FileNotFoundException e) {
            this.setConfigured(false);
            LOGGER.error("Server configuration file not found.", (Throwable)e);
            throw new VitamApplicationServerException((Throwable)e);
        }
        catch (SAXException e) {
            this.setConfigured(false);
            LOGGER.error("Server configuration file can't be parsed.", (Throwable)e);
            throw new VitamApplicationServerException((Throwable)e);
        }
        catch (IOException e) {
            this.setConfigured(false);
            LOGGER.error("Server configuration file can't be read.", (Throwable)e);
            throw new VitamApplicationServerException((Throwable)e);
        }
        catch (Exception e) {
            this.setConfigured(false);
            LOGGER.error("Server can't be started.", (Throwable)e);
            throw new VitamApplicationServerException((Throwable)e);
        }
    }

    @Override
    public void configure(Handler applicationHandler) throws VitamApplicationServerException {
        if (applicationHandler == null) {
            throw new VitamApplicationServerException("You must provide a handler to give to the server");
        }
        this.setHandler(applicationHandler);
        this.getServer().setHandler(applicationHandler);
        this.setConfigured(true);
    }

    @Override
    public void startAndJoin() throws VitamApplicationServerException {
        this.start();
        try {
            this.server.join();
        }
        catch (Exception exc) {
            throw new VitamApplicationServerException(A_PROBLEM_OCCURRED_WHILE_ATTEMPTING_TO_START_THE_SERVER, (Throwable)exc);
        }
    }

    @Override
    public void start() throws VitamApplicationServerException {
        if (!this.isConfigured()) {
            throw new VitamApplicationServerException("You must configure the server before running");
        }
        try {
            this.server.start();
        }
        catch (Exception exc) {
            throw new VitamApplicationServerException(A_PROBLEM_OCCURRED_WHILE_ATTEMPTING_TO_START_THE_SERVER, (Throwable)exc);
        }
    }

    @Override
    public void stop() throws VitamApplicationServerException {
        if (!this.isConfigured()) {
            throw new VitamApplicationServerException("You must configure the server before running");
        }
        try {
            this.server.stop();
        }
        catch (Exception exc) {
            throw new VitamApplicationServerException(A_PROBLEM_OCCURRED_WHILE_ATTEMPTING_TO_START_THE_SERVER, (Throwable)exc);
        }
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public XmlConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public boolean isStarted() {
        if (this.server != null) {
            return this.server.isStarted();
        }
        LOGGER.error("Jetty Server is null");
        return false;
    }

    @Override
    public boolean isStopped() {
        if (this.server != null) {
            return this.server.isStopped();
        }
        LOGGER.error("Jetty Server is null");
        return false;
    }

    public int getPort() {
        if (this.server != null && this.server.isStarted()) {
            int length = this.server.getConnectors().length;
            for (int i = 0; i < length; ++i) {
                ServerConnector c = (ServerConnector)this.server.getConnectors()[i];
                if (!"business".equals(c.getName())) continue;
                return c.getLocalPort();
            }
        }
        return this.port;
    }

    public int getAdminPort() {
        if (this.server != null && this.server.isStarted()) {
            int length = this.server.getConnectors().length;
            for (int i = 0; i < length; ++i) {
                ServerConnector c = (ServerConnector)this.server.getConnectors()[i];
                if (!"admin".equals(c.getName())) continue;
                return c.getLocalPort();
            }
        }
        return -1;
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    protected void setConfigured(boolean configured) {
        this.configured = configured;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(Handler handler) {
        ParametersChecker.checkParameter((String)"Handler must not be nul", (Object[])new Object[]{handler});
        this.handler = handler;
    }

    public VitamThreadPoolExecutor getVitamThreadPoolExecutor() {
        return this.vitamThreadPoolExecutor;
    }
}

