/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.rest;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.rest.EndpointInfo;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.security.rest.Unsecured;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class SecureEndpointScanner
implements DynamicFeature {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecureEndpointScanner.class);
    private static final Class<Annotation>[] HTTP_VERB_ANNOTATIONS = new Class[]{HEAD.class, GET.class, POST.class, PUT.class, DELETE.class, OPTIONS.class};
    private final SecureEndpointRegistry secureEndpointRegistry;
    private Set<String> uniqueIds = new HashSet<String>();
    private Set<Method> scannedMethods = new HashSet<Method>();

    public SecureEndpointScanner(SecureEndpointRegistry secureEndpointRegistry) {
        this.secureEndpointRegistry = secureEndpointRegistry;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (this.isMethodAlreadyRegistred(resourceInfo)) {
            return;
        }
        LOGGER.debug("Scanning resource method " + resourceInfo.getResourceClass().getName() + " . " + resourceInfo.getResourceMethod().getName());
        if (this.isInsecured(resourceInfo)) {
            LOGGER.debug("Skipping unsecured resource");
            return;
        }
        Secured securedAnnotation = resourceInfo.getResourceMethod().getAnnotation(Secured.class);
        if (securedAnnotation == null) {
            throw new IllegalStateException("Missing @" + Secured.class.getName() + " annotation for method " + resourceInfo.getResourceClass().getName() + " . " + resourceInfo.getResourceMethod().getName());
        }
        this.ensureUniqueEndpointId(securedAnnotation.permission().getPermission());
        this.registerEndpoints(resourceInfo, securedAnnotation);
    }

    private boolean isMethodAlreadyRegistred(ResourceInfo resourceInfo) {
        return !this.scannedMethods.add(resourceInfo.getResourceMethod());
    }

    private boolean isInsecured(ResourceInfo resourceInfo) {
        Unsecured unsecuredAnnotation = resourceInfo.getResourceMethod().getAnnotation(Unsecured.class);
        return unsecuredAnnotation != null;
    }

    private void ensureUniqueEndpointId(String id) {
        if (!this.uniqueIds.add(id)) {
            throw new IllegalStateException("Duplicate secured endpoint id '" + id + "'");
        }
    }

    private void registerEndpoints(ResourceInfo resourceInfo, Secured securedAnnotation) {
        List<String> httpVerbs = this.getHttpVerbs(resourceInfo);
        String endpointPath = this.getEndpointPath(resourceInfo);
        String[] producedMediaTypes = this.getProducedMediaTypes(resourceInfo);
        String[] consumedMediaTypes = this.getConsumedMediaTypes(resourceInfo);
        for (String verb : httpVerbs) {
            EndpointInfo endpointInfo = new EndpointInfo();
            endpointInfo.setPermission(securedAnnotation.permission().getPermission());
            endpointInfo.setVerb(verb);
            endpointInfo.setEndpoint(endpointPath);
            endpointInfo.setConsumedMediaTypes(consumedMediaTypes);
            endpointInfo.setProducedMediaTypes(producedMediaTypes);
            endpointInfo.setDescription(securedAnnotation.description());
            this.secureEndpointRegistry.add(endpointInfo);
        }
    }

    private String[] getConsumedMediaTypes(ResourceInfo resourceInfo) {
        Consumes classConsumes = resourceInfo.getResourceClass().getAnnotation(Consumes.class);
        Consumes methodConsumes = resourceInfo.getResourceMethod().getAnnotation(Consumes.class);
        String[] consumedMediaTypes = methodConsumes != null ? methodConsumes.value() : (classConsumes != null ? classConsumes.value() : ArrayUtils.EMPTY_STRING_ARRAY);
        return consumedMediaTypes;
    }

    private String[] getProducedMediaTypes(ResourceInfo resourceInfo) {
        Produces classProduces = resourceInfo.getResourceClass().getAnnotation(Produces.class);
        Produces methodProduces = resourceInfo.getResourceMethod().getAnnotation(Produces.class);
        String[] producedMediaTypes = methodProduces != null ? methodProduces.value() : (classProduces != null ? classProduces.value() : ArrayUtils.EMPTY_STRING_ARRAY);
        return producedMediaTypes;
    }

    private String getEndpointPath(ResourceInfo resourceInfo) {
        Path classPathAnnotation = resourceInfo.getResourceClass().getAnnotation(Path.class);
        Path methodPathAnnotation = resourceInfo.getResourceMethod().getAnnotation(Path.class);
        StrBuilder pathBuilder = new StrBuilder();
        pathBuilder.append('/');
        if (classPathAnnotation != null) {
            pathBuilder.append(classPathAnnotation.value());
        }
        pathBuilder.append('/');
        if (methodPathAnnotation != null) {
            pathBuilder.append(methodPathAnnotation.value());
        }
        pathBuilder.append('/');
        pathBuilder.replaceAll("//", "/");
        return pathBuilder.toString();
    }

    private List<String> getHttpVerbs(ResourceInfo resourceInfo) {
        ArrayList<String> httpVerbs = new ArrayList<String>();
        for (Class<Annotation> verbAnnotationClass : HTTP_VERB_ANNOTATIONS) {
            Annotation annotation = resourceInfo.getResourceMethod().getAnnotation(verbAnnotationClass);
            if (annotation == null) continue;
            httpVerbs.add(verbAnnotationClass.getSimpleName());
        }
        return httpVerbs;
    }
}

