/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.filter;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.alert.AlertService;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class ThrottlingAlertService {
    private final AlertService alertService;
    private final int minDelayInSeconds;
    private final String errorMessage;
    private LocalDateTime lastTimestamp;
    private int nbSuppressedRedundantAlerts = 0;

    public ThrottlingAlertService(AlertService alertService, String errorMessage, int minDelayInSeconds) {
        this.alertService = alertService;
        this.minDelayInSeconds = minDelayInSeconds;
        this.errorMessage = errorMessage;
    }

    public synchronized void reportAlert() {
        if (this.lastTimestamp == null) {
            this.triggerAlert(1);
            this.lastTimestamp = LocalDateUtil.now();
            return;
        }
        ++this.nbSuppressedRedundantAlerts;
        long elapsedSecondsSinceLastAlert = ChronoUnit.SECONDS.between(this.lastTimestamp, LocalDateUtil.now());
        if (elapsedSecondsSinceLastAlert >= (long)this.minDelayInSeconds) {
            this.triggerAlert(this.nbSuppressedRedundantAlerts);
            this.lastTimestamp = LocalDateUtil.now();
            this.nbSuppressedRedundantAlerts = 0;
        }
    }

    private void triggerAlert(int occurrences) {
        if (occurrences == 1) {
            this.alertService.createAlert(this.errorMessage);
        } else {
            this.alertService.createAlert(occurrences + " redundant errors. " + this.errorMessage);
        }
    }
}

