/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.codec.URLCodec;
import fr.gouv.vitam.common.security.filter.ThrottlingAlertService;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class RequestAuthorizationValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RequestAuthorizationValidator.class);
    private final ThrottlingAlertService warningTimestampNotificationHandler;
    private final ThrottlingAlertService criticalTimestampNotificationHandler;

    public RequestAuthorizationValidator() {
        this(new AlertServiceImpl());
    }

    @VisibleForTesting
    RequestAuthorizationValidator(AlertService alertService) {
        this.warningTimestampNotificationHandler = new ThrottlingAlertService(alertService, "Timestamp check failed. Please ensure NTP service is properly configured on all Vitam servers", VitamConfiguration.getRequestTimeAlertThrottlingDelay());
        this.criticalTimestampNotificationHandler = new ThrottlingAlertService(alertService, "Critical Timestamp check failed. Please ensure NTP service is properly configured on all Vitam servers", VitamConfiguration.getRequestTimeAlertThrottlingDelay());
    }

    public boolean checkAuthorizationHeaders(HttpServletRequest request) {
        if (request.getRequestURI().startsWith("/admin/v1") || request.getRequestURI().endsWith("/status")) {
            return true;
        }
        return this.checkHeadersValues(request);
    }

    private boolean checkHeadersValues(HttpServletRequest request) {
        String platformId = request.getHeader("X-Platform-Id");
        String timestamp = request.getHeader("X-Timestamp");
        if (Strings.isNullOrEmpty((String)platformId) || Strings.isNullOrEmpty((String)timestamp)) {
            LOGGER.error(String.format("Illegal request. Missing %s and/or %s headers", "X-Platform-Id", "X-Timestamp"));
            return false;
        }
        return this.checkTimestamp(timestamp) && this.checkPlatformId(request, platformId, timestamp);
    }

    private boolean checkTimestamp(String timestamp) {
        long requestEpoch;
        long currentEpoch = LocalDateUtil.currentTimeMillis() / 1000L;
        long timeShift = Math.abs(currentEpoch - (requestEpoch = Long.parseLong(timestamp)));
        if (timeShift <= (long)VitamConfiguration.getAcceptableRequestTime()) {
            return true;
        }
        if (timeShift <= (long)VitamConfiguration.getCriticalRequestTime()) {
            LOGGER.error("Timestamp check failed. " + timeShift + "s");
            this.warningTimestampNotificationHandler.reportAlert();
            return true;
        }
        LOGGER.error("Critical timestamp check failure. " + timeShift + "s");
        this.criticalTimestampNotificationHandler.reportAlert();
        return false;
    }

    private boolean checkPlatformId(HttpServletRequest request, String platformId, String timestamp) {
        String uri = request.getRequestURI();
        uri = URLDecoder.decode(uri, StandardCharsets.UTF_8);
        String httpMethod = request.getMethod();
        String code = URLCodec.encodeURL(httpMethod, uri, timestamp, VitamConfiguration.getSecret(), VitamConfiguration.getSecurityDigestType());
        if (code.equals(platformId)) {
            return true;
        }
        LOGGER.error("PlatformId check failed");
        return false;
    }
}

