/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.filter;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.filter.RequestAuthorizationValidator;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

public class AuthorizationFilter
implements Filter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AuthorizationFilter.class);
    private final RequestAuthorizationValidator requestAuthorizationValidator;

    public AuthorizationFilter() {
        this(new RequestAuthorizationValidator());
    }

    AuthorizationFilter(RequestAuthorizationValidator requestAuthorizationValidator) {
        this.requestAuthorizationValidator = requestAuthorizationValidator;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.requestAuthorizationValidator.checkAuthorizationHeaders((HttpServletRequest)request)) {
            LOGGER.error("Authorization headers check failed!");
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.sendError(Response.Status.UNAUTHORIZED.getStatusCode(), JsonHandler.unprettyPrint((Object)JsonHandler.createObjectNode().put("Error", "Authorization headers check failed!")));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

