/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.objectgroup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.objectgroup.DbFileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.DbFormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.DbStorageModel;
import fr.gouv.vitam.common.model.objectgroup.MetadataModel;
import fr.gouv.vitam.common.model.objectgroup.PhysicalDimensionsModel;
import fr.gouv.vitam.common.model.preservation.OtherMetadata;
import fr.gouv.vitam.common.model.unit.PersistentIdentifierModel;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DbVersionsModel {
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="DataObjectVersion")
    private String dataObjectVersion;
    @JsonProperty(value="DataObjectGroupId")
    private String dataObjectGroupId;
    @JsonProperty(value="FormatIdentification")
    private DbFormatIdentificationModel formatIdentificationModel;
    @JsonProperty(value="FileInfo")
    private DbFileInfoModel fileInfoModel;
    @JsonProperty(value="Metadata")
    private MetadataModel metadata;
    @JsonProperty(value="Size")
    private long size;
    @JsonProperty(value="Uri")
    private String uri;
    @JsonProperty(value="MessageDigest")
    private String messageDigest;
    @JsonProperty(value="Algorithm")
    private String algorithm;
    @JsonProperty(value="_storage")
    private DbStorageModel storage;
    @JsonProperty(value="PhysicalDimensions")
    private PhysicalDimensionsModel physicalDimensionsModel;
    @JsonProperty(value="PhysicalId")
    private String physicalId;
    @JsonProperty(value="OtherMetadata")
    private OtherMetadata otherMetadata = new OtherMetadata();
    @JsonProperty(value="_opi")
    private String opi;
    @JsonProperty(value="DataObjectProfile")
    private String dataObjectProfile;
    @JsonProperty(value="DataObjectUse")
    private String dataObjectUse;
    @JsonProperty(value="DataObjectNumber")
    private Integer dataObjectNumber;
    @JsonProperty(value="PersistentIdentifier")
    private List<PersistentIdentifierModel> persistentIdentifier;

    public DbVersionsModel() {
    }

    public DbVersionsModel(String id, String dataObjectProfile, String dataObjectVersion, String dataObjectGroupId, DbFormatIdentificationModel formatIdentificationModel, DbFileInfoModel fileInfoModel, MetadataModel metadata, long size, String uri, String messageDigest, String algorithm, DbStorageModel storage, PhysicalDimensionsModel physicalDimensionsModel, String physicalId, OtherMetadata otherMetadata, String opi) {
        this.id = id;
        this.dataObjectProfile = dataObjectProfile;
        this.dataObjectVersion = dataObjectVersion;
        this.dataObjectGroupId = dataObjectGroupId;
        this.formatIdentificationModel = formatIdentificationModel;
        this.fileInfoModel = fileInfoModel;
        this.metadata = metadata;
        this.size = size;
        this.uri = uri;
        this.messageDigest = messageDigest;
        this.algorithm = algorithm;
        this.storage = storage;
        this.physicalDimensionsModel = physicalDimensionsModel;
        this.physicalId = physicalId;
        this.otherMetadata = otherMetadata;
        this.opi = opi;
    }

    @JsonIgnore
    public static DbVersionsModel newVersionsFrom(DbVersionsModel that, OtherMetadata otherMetadata) {
        return new DbVersionsModel(that.id, that.dataObjectProfile, that.dataObjectVersion, that.dataObjectGroupId, that.formatIdentificationModel, that.fileInfoModel, that.metadata, that.size, that.uri, that.messageDigest, that.algorithm, that.storage, that.physicalDimensionsModel, that.physicalId, otherMetadata, that.opi);
    }

    @JsonIgnore
    public static DbVersionsModel newVersionsFrom(DbVersionsModel that, DbFormatIdentificationModel format) {
        return new DbVersionsModel(that.id, that.dataObjectProfile, that.dataObjectVersion, that.dataObjectGroupId, format, that.fileInfoModel, that.metadata, that.size, that.uri, that.messageDigest, that.algorithm, that.storage, that.physicalDimensionsModel, that.physicalId, that.otherMetadata, that.opi);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDataObjectVersion() {
        return this.dataObjectVersion;
    }

    public void setDataObjectVersion(String dataObjectVersion) {
        this.dataObjectVersion = dataObjectVersion;
    }

    public String getDataObjectGroupId() {
        return this.dataObjectGroupId;
    }

    public void setDataObjectGroupId(String dataObjectGroupId) {
        this.dataObjectGroupId = dataObjectGroupId;
    }

    public DbFormatIdentificationModel getFormatIdentificationModel() {
        return this.formatIdentificationModel;
    }

    public void setFormatIdentificationModel(DbFormatIdentificationModel formatIdentificationModel) {
        this.formatIdentificationModel = formatIdentificationModel;
    }

    public DbFileInfoModel getFileInfoModel() {
        return this.fileInfoModel;
    }

    public void setFileInfoModel(DbFileInfoModel fileInfoModel) {
        this.fileInfoModel = fileInfoModel;
    }

    public MetadataModel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataModel metadata) {
        this.metadata = metadata;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(String messageDigest) {
        this.messageDigest = messageDigest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public DbStorageModel getStorage() {
        return this.storage;
    }

    public void setStorage(DbStorageModel storage) {
        this.storage = storage;
    }

    public PhysicalDimensionsModel getPhysicalDimensionsModel() {
        return this.physicalDimensionsModel;
    }

    public void setPhysicalDimensionsModel(PhysicalDimensionsModel physicalDimensionsModel) {
        this.physicalDimensionsModel = physicalDimensionsModel;
    }

    public String getPhysicalId() {
        return this.physicalId;
    }

    public void setPhysicalId(String physicalId) {
        this.physicalId = physicalId;
    }

    public OtherMetadata getOtherMetadata() {
        return this.otherMetadata;
    }

    public void setOtherMetadata(OtherMetadata otherMetadata) {
        this.otherMetadata = otherMetadata;
    }

    public String getOpi() {
        return this.opi;
    }

    public void setOpi(String opi) {
        this.opi = opi;
    }

    public String getDataObjectProfile() {
        return this.dataObjectProfile;
    }

    public void setDataObjectProfile(String dataObjectProfile) {
        this.dataObjectProfile = dataObjectProfile;
    }

    public List<PersistentIdentifierModel> getPersistentIdentifier() {
        return this.persistentIdentifier;
    }

    public void setPersistentIdentifier(List<PersistentIdentifierModel> persistentIdentifier) {
        this.persistentIdentifier = persistentIdentifier;
    }

    public String getDataObjectUse() {
        return this.dataObjectUse;
    }

    public void setDataObjectUse(String dataObjectUse) {
        this.dataObjectUse = dataObjectUse;
    }

    public Integer getDataObjectNumber() {
        return this.dataObjectNumber;
    }

    public void setDataObjectNumber(Integer dataObjectNumber) {
        this.dataObjectNumber = dataObjectNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbVersionsModel that = (DbVersionsModel)o;
        return this.id.equals(that.id) && this.dataObjectVersion.equals(that.dataObjectVersion) && this.dataObjectGroupId.equals(that.dataObjectGroupId) && this.otherMetadata.equals((Object)that.otherMetadata) && this.formatIdentificationModel.equals(that.formatIdentificationModel);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dataObjectVersion, this.dataObjectGroupId, this.formatIdentificationModel);
    }
}

