/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.config;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.model.config.DedicatedVirtualPathsTenantConfiguration;
import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import fr.gouv.vitam.common.model.config.VirtualPathsConfiguration;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class VirtualPathsManager {
    private final Map<Integer, List<String>> virtualPathsFieldsSettingsMap = new HashMap<Integer, List<String>>();

    public VirtualPathsManager(VirtualPathsConfiguration virtualPathsConfiguration) {
        if (virtualPathsConfiguration == null || virtualPathsConfiguration.getDefaultConfiguration() == null) {
            return;
        }
        VitamConfiguration.getTenants().forEach(tenantId -> this.virtualPathsFieldsSettingsMap.put((Integer)tenantId, virtualPathsConfiguration.getDefaultConfiguration().getSourceFields()));
        List<DedicatedVirtualPathsTenantConfiguration> dedicatedTenantConfigurations = virtualPathsConfiguration.getDedicatedTenantConfiguration();
        if (CollectionUtils.isEmpty(dedicatedTenantConfigurations)) {
            return;
        }
        for (DedicatedVirtualPathsTenantConfiguration dedicatedTenantConfiguration : dedicatedTenantConfigurations) {
            List<TenantRange> tenantRanges = TenantRangeParser.parseTenantRanges(dedicatedTenantConfiguration.getTenants());
            tenantRanges.forEach(tenantRange -> {
                Iterator iterator = VitamConfiguration.getTenants().iterator();
                while (iterator.hasNext()) {
                    int tenantId = (Integer)iterator.next();
                    if (!tenantRange.isInRange(tenantId)) continue;
                    this.virtualPathsFieldsSettingsMap.put(tenantId, dedicatedTenantConfiguration.getSourceFields());
                }
            });
        }
    }

    public List<String> getVirtualPathsFieldsByTenant(Integer tenantId) {
        return this.virtualPathsFieldsSettingsMap.getOrDefault(tenantId, null);
    }

    public List<String> getVirtualPathsFieldsForCurrentTenant() {
        return this.getVirtualPathsFieldsByTenant(VitamThreadUtils.getVitamSession().getTenantId());
    }

    public Map<Integer, List<String>> getVirtualPathsFieldsConfiguration() {
        return this.virtualPathsFieldsSettingsMap;
    }
}

