/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.config;

import fr.gouv.vitam.common.model.config.TenantRange;
import fr.gouv.vitam.common.model.config.TenantRangeParser;
import java.util.List;

public final class TenantRangeValidator {
    private TenantRangeValidator() {
    }

    public static void validate(List<String> tenantRanges) throws IllegalArgumentException {
        if (tenantRanges.contains(null)) {
            throw new IllegalStateException("Invalid configuration. Missing tenants from dedicated tenant or grouped tenant configuration");
        }
        List ranges = tenantRanges.stream().flatMap(tenantRangeString -> TenantRangeParser.parseTenantRanges(tenantRangeString).stream()).toList();
        for (int i = 0; i < ranges.size(); ++i) {
            for (int j = i + 1; j < tenantRanges.size(); ++j) {
                if (!TenantRangeParser.doRangesIntersect((TenantRange)ranges.get(i), (TenantRange)ranges.get(j))) continue;
                throw new IllegalStateException("Invalid configuration. Overlapping tenant ranges " + tenantRanges.get(i) + " and " + tenantRanges.get(j));
            }
        }
    }
}

