/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.config;

import fr.gouv.vitam.common.model.config.TenantRange;
import java.util.ArrayList;
import java.util.List;

public final class TenantRangeParser {
    private TenantRangeParser() {
    }

    public static List<TenantRange> parseTenantRanges(String tenantRanges) throws IllegalStateException {
        if (tenantRanges == null) {
            throw new IllegalStateException("Invalid configuration. Null tenants");
        }
        ArrayList<TenantRange> parsedTenantRanges = new ArrayList<TenantRange>();
        for (String tenantRangeStr : tenantRanges.split(",")) {
            parsedTenantRanges.add(TenantRangeParser.parseTenantRange(tenantRangeStr));
        }
        return parsedTenantRanges;
    }

    private static TenantRange parseTenantRange(String tenantRange) throws IllegalStateException {
        int hyphenSeparatorPos = tenantRange.indexOf("-");
        if (hyphenSeparatorPos != -1) {
            int maxRange;
            String minRangeStr = tenantRange.substring(0, hyphenSeparatorPos);
            String maxRangeStr = tenantRange.substring(hyphenSeparatorPos + 1);
            int minRange = TenantRangeParser.parseTenant(minRangeStr);
            if (minRange > (maxRange = TenantRangeParser.parseTenant(maxRangeStr))) {
                throw new IllegalStateException("Invalid configuration. Illegal range '" + tenantRange + "'");
            }
            return new TenantRange(minRange, maxRange);
        }
        int tenant = TenantRangeParser.parseTenant(tenantRange);
        return new TenantRange(tenant, tenant);
    }

    private static int parseTenant(String minRangeStr) throws IllegalStateException {
        try {
            int result = Integer.parseInt(minRangeStr.trim());
            if (result < 0) {
                throw new IllegalStateException("Invalid configuration. Negative tenant value " + result);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Invalid configuration. Invalid tenant value '" + minRangeStr + "'", e);
        }
    }

    public static boolean doRangesIntersect(TenantRange tenantRange1, TenantRange tenantRange2) {
        return tenantRange1.isInRange(tenantRange2.getMinValue()) || tenantRange1.isInRange(tenantRange2.getMaxValue()) || tenantRange2.isInRange(tenantRange1.getMinValue()) || tenantRange2.isInRange(tenantRange1.getMaxValue());
    }
}

