/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.json.JsonHandler;

public class MetadataStorageHelper {
    public static final String UNIT_KEY = "unit";
    public static final String GOT_KEY = "got";
    public static final String LFC_KEY = "lfc";

    public static JsonNode getUnitWithLFC(JsonNode document, JsonNode lfc) {
        ObjectNode docWithLFC = JsonHandler.getFactory().objectNode();
        docWithLFC.set(UNIT_KEY, document);
        docWithLFC.set(LFC_KEY, lfc);
        return docWithLFC;
    }

    public static JsonNode getUnitFromUnitWithLFC(JsonNode document) {
        if (document == null || !document.hasNonNull(UNIT_KEY)) {
            throw new IllegalArgumentException("Document should contain a unit object");
        }
        return document.get(UNIT_KEY);
    }

    public static JsonNode getGotWithLFC(JsonNode document, JsonNode lfc) {
        ObjectNode docWithLFC = JsonHandler.getFactory().objectNode();
        docWithLFC.set(GOT_KEY, document);
        docWithLFC.set(LFC_KEY, lfc);
        return docWithLFC;
    }
}

